/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BigQueryUtil {
    static final ImmutableSet<String> INTERNAL_ERROR_MESSAGES = ImmutableSet.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server");
    private static final String PROJECT_PATTERN = "\\S+";
    private static final String DATASET_PATTERN = "\\w+";
    private static final String TABLE_PATTERN = "[\\S&&[^.:]]+";
    private static final Pattern QUALIFIED_TABLE_REGEX = Pattern.compile(String.format("^(((%s)[:.])?(%s)\\.)?(%s)$$", "\\S+", "\\w+", "[\\S&&[^.:]]+"));
    private static final int MAX_FILTER_LENGTH_IN_BYTES = 0x200000;

    private BigQueryUtil() {
    }

    public static boolean isRetryable(Throwable cause) {
        return Throwables.getCausalChain((Throwable)cause).stream().anyMatch(BigQueryUtil::isRetryableInternalError);
    }

    static boolean isRetryableInternalError(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            return statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && INTERNAL_ERROR_MESSAGES.stream().anyMatch(message -> statusRuntimeException.getMessage().contains((CharSequence)message));
        }
        return false;
    }

    static BigQueryException convertToBigQueryException(BigQueryError error) {
        return new BigQueryException(0, error.getMessage(), error);
    }

    static boolean areCredentialsEqual(Credentials credentials1, Credentials credentials2) {
        if (!(credentials1 instanceof ExternalAccountCredentials) && !(credentials2 instanceof ExternalAccountCredentials)) {
            return Objects.equal((Object)credentials1, (Object)credentials2);
        }
        return Arrays.equals(BigQueryUtil.getCredentialsByteArray(credentials1), BigQueryUtil.getCredentialsByteArray(credentials2));
    }

    static byte[] getCredentialsByteArray(Credentials credentials) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(credentials);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> Optional<T> firstPresent(Optional<T> ... optionals) {
        for (Optional<T> o : optionals) {
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public static TableId parseTableId(String rawTable) {
        return BigQueryUtil.parseTableId(rawTable, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static TableId parseTableId(String rawTable, Optional<String> dataset, Optional<String> project) {
        return BigQueryUtil.parseTableId(rawTable, dataset, project, Optional.empty());
    }

    public static TableId parseTableId(String rawTable, Optional<String> dataset, Optional<String> project, Optional<String> datePartition) {
        Matcher matcher = QUALIFIED_TABLE_REGEX.matcher(rawTable);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid Table ID '%s'. Must match '%s'", rawTable, QUALIFIED_TABLE_REGEX));
        }
        String table = matcher.group(5);
        Optional<String> parsedDataset = Optional.ofNullable(matcher.group(4));
        Optional<String> parsedProject = Optional.ofNullable(matcher.group(3));
        String tableAndPartition = datePartition.map(date -> String.format("%s$%s", table, date)).orElse(table);
        String actualDataset = (String)BigQueryUtil.firstPresent(parsedDataset, dataset).orElseThrow(() -> new IllegalArgumentException("'dataset' not parsed or provided."));
        return BigQueryUtil.firstPresent(parsedProject, project).map(p -> TableId.of((String)p, (String)actualDataset, (String)tableAndPartition)).orElse(TableId.of((String)actualDataset, (String)tableAndPartition));
    }

    public static String friendlyTableName(TableId tableId) {
        return tableId.getProject() != null ? String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable()) : String.format("%s.%s", tableId.getDataset(), tableId.getTable());
    }

    public static void convertAndThrow(BigQueryError error) {
        throw new BigQueryException(0, error.getMessage(), error);
    }

    public static List<String> optimizeLoadUriList(List<String> uris, String prefixRegex, String suffixRegex) {
        Pattern pattern = Pattern.compile("(" + prefixRegex + "\\d*)\\d\\**(" + suffixRegex + ")");
        ImmutableList.Builder result = ImmutableList.builder();
        List<String> workingList = uris;
        while (!workingList.isEmpty()) {
            Multimap<String, String> trimmedUriMap = BigQueryUtil.trimUris(pattern, workingList);
            ArrayList<String> nextList = new ArrayList<String>();
            for (String trimmedUri : trimmedUriMap.keySet()) {
                Collection mappedUris = trimmedUriMap.get((Object)trimmedUri);
                if (mappedUris.size() == 10) {
                    nextList.add(trimmedUri);
                    continue;
                }
                result.addAll((Iterable)mappedUris);
            }
            trimmedUriMap.clear();
            workingList = nextList;
        }
        return result.build();
    }

    private static Multimap<String, String> trimUris(Pattern pattern, List<String> workingList) {
        HashMultimap trimmedUriMap = HashMultimap.create();
        for (String uri : workingList) {
            String trimmedUri = pattern.matcher(uri).replaceFirst("$1*$2");
            trimmedUriMap.put((Object)trimmedUri, (Object)uri);
        }
        return trimmedUriMap;
    }

    public static boolean schemaWritable(Schema sourceSchema, Schema destinationSchema, boolean regardFieldOrder, boolean enableModeCheckForSchemaFields) {
        if (sourceSchema == destinationSchema) {
            return true;
        }
        if (sourceSchema == null || destinationSchema == null) {
            return false;
        }
        if (regardFieldOrder) {
            return sourceSchema.equals((Object)destinationSchema);
        }
        return BigQueryUtil.fieldListWritable(sourceSchema.getFields(), destinationSchema.getFields(), enableModeCheckForSchemaFields);
    }

    public static List<String> getStreamNames(ReadSession readSession) {
        return readSession == null ? new ArrayList<String>() : (List)readSession.getStreamsList().stream().map(ReadStream::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    @VisibleForTesting
    static boolean fieldWritable(Field sourceField, Field destinationField, boolean enableModeCheckForSchemaFields) {
        if (sourceField == destinationField) {
            return true;
        }
        if (sourceField == null || destinationField == null) {
            return false;
        }
        if (!BigQueryUtil.fieldListWritable(sourceField.getSubFields(), destinationField.getSubFields(), enableModeCheckForSchemaFields)) {
            return false;
        }
        return Objects.equal((Object)sourceField.getName(), (Object)destinationField.getName()) && Objects.equal((Object)sourceField.getType(), (Object)destinationField.getType()) && (!enableModeCheckForSchemaFields || Objects.equal((Object)BigQueryUtil.nullableIfNull(sourceField.getMode()), (Object)BigQueryUtil.nullableIfNull(destinationField.getMode()))) && (sourceField.getMaxLength() == null && destinationField.getMaxLength() == null || sourceField.getMaxLength() != null && destinationField.getMaxLength() != null && sourceField.getMaxLength() <= destinationField.getMaxLength()) && (sourceField.getScale() == null && destinationField.getScale() == null || sourceField.getScale() != null && destinationField.getScale() != null && sourceField.getScale() <= destinationField.getScale()) && (sourceField.getPrecision() == null && destinationField.getPrecision() == null || sourceField.getPrecision() != null && destinationField.getPrecision() != null && sourceField.getPrecision() <= destinationField.getPrecision());
    }

    @VisibleForTesting
    static boolean fieldListWritable(FieldList sourceFieldList, FieldList destinationFieldList, boolean enableModeCheckForSchemaFields) {
        if (sourceFieldList == destinationFieldList) {
            return true;
        }
        if (sourceFieldList == null || destinationFieldList == null) {
            return false;
        }
        Map sourceFieldsMap = sourceFieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        Map destinationFieldsMap = destinationFieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        for (Map.Entry e : sourceFieldsMap.entrySet()) {
            Field f2;
            Field f1 = (Field)e.getValue();
            if (BigQueryUtil.fieldWritable(f1, f2 = (Field)destinationFieldsMap.get(e.getKey()), enableModeCheckForSchemaFields)) continue;
            return false;
        }
        return true;
    }

    static Field.Mode nullableIfNull(Field.Mode mode) {
        return mode == null ? Field.Mode.NULLABLE : mode;
    }

    public static Optional<String> emptyIfNeeded(String value) {
        return value == null || value.length() == 0 ? Optional.empty() : Optional.of(value);
    }

    public static <T> T createVerifiedInstance(String fullyQualifiedClassName, Class<T> requiredClass, Object ... constructorArgs) {
        try {
            Class<?> clazz = Class.forName(fullyQualifiedClassName);
            Object result = clazz.getDeclaredConstructor((Class[])Arrays.stream(constructorArgs).map(Object::getClass).toArray(Class[]::new)).newInstance(constructorArgs);
            if (!requiredClass.isInstance(result)) {
                throw new IllegalArgumentException(String.format("% does not implement %s", clazz.getCanonicalName(), requiredClass.getCanonicalName()));
            }
            return (T)result;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not instantiate class [%s], implementing %s", fullyQualifiedClassName, requiredClass.getCanonicalName()), e);
        }
    }

    public static <T> T verifySerialization(T obj) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object result = in.readObject();
            in.close();
            return (T)result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("Serialization test of " + obj.getClass().getCanonicalName() + " failed", e);
        }
    }

    public static Optional<String> getPartitionField(TableInfo tableInfo) {
        TableDefinition definition = tableInfo.getDefinition();
        if (!(definition instanceof StandardTableDefinition)) {
            return Optional.empty();
        }
        StandardTableDefinition sdt = (StandardTableDefinition)definition;
        TimePartitioning timePartitioning = sdt.getTimePartitioning();
        if (timePartitioning != null) {
            return Optional.of(timePartitioning.getField());
        }
        RangePartitioning rangePartitioning = sdt.getRangePartitioning();
        if (rangePartitioning != null) {
            return Optional.of(rangePartitioning.getField());
        }
        return Optional.empty();
    }

    public static ImmutableList<String> getClusteringFields(TableInfo tableInfo) {
        TableDefinition definition = tableInfo.getDefinition();
        if (!(definition instanceof StandardTableDefinition)) {
            return ImmutableList.of();
        }
        Clustering clustering = ((StandardTableDefinition)definition).getClustering();
        if (clustering == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)clustering.getFields());
    }

    public static boolean filterLengthInLimit(Optional<String> filter) {
        return filter.map(f -> f.getBytes(StandardCharsets.UTF_8).length < 0x200000).orElse(Boolean.TRUE);
    }
}

