/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.spark.bigquery.BigQueryStreamWriter;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.streaming.OutputMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryStreamingSink
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(BigQueryStreamingSink.class);
    private final SQLContext sqlContext;
    private final Map<String, String> parameters;
    private final List<String> partitionColumns;
    private final OutputMode outputMode;
    private final SparkBigQueryConfig opts;
    private final BigQueryClient bigQueryClient;
    private volatile long latestBatchId = -1L;

    public BigQueryStreamingSink(SQLContext sqlContext, Map<String, String> parameters, List<String> partitionColumns, OutputMode outputMode, SparkBigQueryConfig opts, BigQueryClient bigQueryClient) {
        this.sqlContext = sqlContext;
        this.parameters = parameters;
        this.partitionColumns = partitionColumns;
        this.outputMode = outputMode;
        this.opts = opts;
        this.bigQueryClient = bigQueryClient;
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= this.latestBatchId) {
            log.warn("Skipping as already committed batch " + batchId);
        } else {
            log.debug("addBatch(" + batchId + ")");
            BigQueryStreamWriter.writeBatch(data, this.sqlContext, this.outputMode, this.opts, this.bigQueryClient);
            this.latestBatchId = batchId;
        }
    }

    public SQLContext getSqlContext() {
        return this.sqlContext;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public SparkBigQueryConfig getOpts() {
        return this.opts;
    }

    public BigQueryClient getBigQueryClient() {
        return this.bigQueryClient;
    }

    public long getLatestBatchId() {
        return this.latestBatchId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryStreamingSink that = (BigQueryStreamingSink)o;
        return this.latestBatchId == that.latestBatchId && Objects.equals(this.sqlContext, that.sqlContext) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.outputMode, that.outputMode) && Objects.equals(this.opts, that.opts) && Objects.equals(this.bigQueryClient, that.bigQueryClient);
    }

    public int hashCode() {
        return Objects.hash(this.sqlContext, this.parameters, this.partitionColumns, this.outputMode, this.opts, this.bigQueryClient, this.latestBatchId);
    }

    public String toString() {
        return "BigQueryStreamingSink(sqlContext=" + this.sqlContext + ", parameters=" + this.parameters + ", partitionColumns=" + this.partitionColumns + ", outputMode=" + this.outputMode + ", opts=" + this.opts + ", bigQueryClient=" + this.bigQueryClient + ", latestBatchId=" + this.latestBatchId + ')';
    }
}

