/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryConfigurationUtil;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.MaterializationConfiguration;
import com.google.cloud.bigquery.connector.common.QueryParameterHelper;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfigBuilder;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.PartitionOverwriteMode;
import com.google.cloud.spark.bigquery.SparkBigQueryProxyAndHttpConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.Credentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.ServiceOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.JobInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Optional;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Splitter;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.checkerframework.checker.nullness.qual.Nullable;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import scala.util.Properties;

public class SparkBigQueryConfig
implements BigQueryConfig,
BigQueryClient.CreateTableOptions,
BigQueryClient.LoadDataOptions,
Serializable {
    private static final long serialVersionUID = 728392817473829L;
    public static final int MAX_TRACE_ID_LENGTH = 256;
    public static final TableId QUERY_DUMMY_TABLE_ID = TableId.of("QUERY", "QUERY");
    public static final String IMPERSONATION_GLOBAL = "gcpImpersonationServiceAccount";
    public static final String IMPERSONATION_FOR_USER_PREFIX = "gcpImpersonationServiceAccountForUser.";
    public static final String IMPERSONATION_FOR_GROUP_PREFIX = "gcpImpersonationServiceAccountForGroup.";
    public static final String VIEWS_ENABLED_OPTION = "viewsEnabled";
    public static final String USE_AVRO_LOGICAL_TYPES_OPTION = "useAvroLogicalTypes";
    public static final String DATE_PARTITION_PARAM = "datePartition";
    public static final String VALIDATE_SPARK_AVRO_PARAM = "validateSparkAvroInternalParam";
    public static final String ENABLE_LIST_INFERENCE = "enableListInference";
    public static final String INTERMEDIATE_FORMAT_OPTION = "intermediateFormat";
    public static final String WRITE_METHOD_PARAM = "writeMethod";
    public static final String WRITE_AT_LEAST_ONCE_OPTION = "writeAtLeastOnce";
    @VisibleForTesting
    static final DataFormat DEFAULT_READ_DATA_FORMAT = DataFormat.ARROW;
    @VisibleForTesting
    static final IntermediateFormat DEFAULT_INTERMEDIATE_FORMAT = IntermediateFormat.PARQUET;
    @VisibleForTesting
    static final ArrowSerializationOptions.CompressionCodec DEFAULT_ARROW_COMPRESSION_CODEC = ArrowSerializationOptions.CompressionCodec.COMPRESSION_UNSPECIFIED;
    @VisibleForTesting
    static final ReadSession.TableReadOptions.ResponseCompressionCodec DEFAULT_RESPONSE_COMPRESSION_CODEC = ReadSession.TableReadOptions.ResponseCompressionCodec.RESPONSE_COMPRESSION_CODEC_UNSPECIFIED;
    static final String GCS_CONFIG_CREDENTIALS_FILE_PROPERTY = "google.cloud.auth.service.account.json.keyfile";
    static final String GCS_CONFIG_PROJECT_ID_PROPERTY = "fs.gs.project.id";
    private static final String READ_DATA_FORMAT_OPTION = "readDataFormat";
    private static final ImmutableList<String> PERMITTED_READ_DATA_FORMATS = ImmutableList.of(DataFormat.ARROW.toString(), DataFormat.AVRO.toString());
    private static final String CONF_PREFIX = "spark.datasource.bigquery.";
    private static final int DEFAULT_BIGQUERY_CLIENT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_BIGQUERY_CLIENT_READ_TIMEOUT = 60000;
    private static final Pattern QUICK_LOWERCASE_QUERY_PATTERN = Pattern.compile("(?i)^\\s*(select|with|\\()\\b[\\s\\S]*");
    private static final Pattern HAS_WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern SQL_KEYWORD_PATTERN = Pattern.compile("(?i)\\b(select|from|where|join|group by|order by|union all)\\b");
    public static final int MIN_BUFFERED_RESPONSES_PER_STREAM = 1;
    public static final int MIN_STREAMS_PER_PARTITION = 1;
    private static final int DEFAULT_BIGQUERY_CLIENT_RETRIES = 10;
    private static final String ARROW_COMPRESSION_CODEC_OPTION = "arrowCompressionCodec";
    private static final String RESPONSE_COMPRESSION_CODEC_OPTION = "responseCompressionCodec";
    private static final WriteMethod DEFAULT_WRITE_METHOD = WriteMethod.INDIRECT;
    public static final int DEFAULT_CACHE_EXPIRATION_IN_MINUTES = 15;
    static final String BIGQUERY_JOB_LABEL_PREFIX = "bigQueryJobLabel.";
    static final String BIGQUERY_TABLE_LABEL_PREFIX = "bigQueryTableLabel.";
    public static final QueryJobConfiguration.Priority DEFAULT_JOB_PRIORITY = QueryJobConfiguration.Priority.INTERACTIVE;
    static final String ALLOW_MAP_TYPE_CONVERSION = "allowMapTypeConversion";
    static final Boolean ALLOW_MAP_TYPE_CONVERSION_DEFAULT = true;
    public static final String partitionOverwriteModeProperty = "spark.sql.sources.partitionOverwriteMode";
    public PartitionOverwriteMode partitionOverwriteModeValue = PartitionOverwriteMode.STATIC;
    public static final String BIGQUERY_JOB_TIMEOUT_IN_MINUTES = "bigQueryJobTimeoutInMinutes";
    static final long BIGQUERY_JOB_TIMEOUT_IN_MINUTES_DEFAULT = 360L;
    public static final String GPN_ATTRIBUTION = "GPN";
    public static final String BIG_NUMERIC_DEFAULT_PRECISION = "bigNumericDefaultPrecision";
    public static final String BIG_NUMERIC_DEFAULT_SCALE = "bigNumericDefaultScale";
    private static final String DATAPROC_SYSTEM_BUCKET_CONFIGURATION = "fs.gs.system.bucket";
    TableId tableId;
    Optional<String> query = BigQueryConfigurationUtil.empty();
    String parentProjectId;
    boolean useParentProjectForMetadataOperations;
    Optional<String> accessTokenProviderFQCN;
    Optional<String> accessTokenProviderConfig;
    String loggedInUserName;
    Set<String> loggedInUserGroups;
    Optional<String> impersonationServiceAccount;
    Optional<Map<String, String>> impersonationServiceAccountsForUsers;
    Optional<Map<String, String>> impersonationServiceAccountsForGroups;
    Optional<String> credentialsKey;
    Optional<String> credentialsFile;
    Optional<String> accessToken;
    Optional<ImmutableList<String>> credentialsScopes;
    Optional<String> filter = BigQueryConfigurationUtil.empty();
    Optional<StructType> schema = BigQueryConfigurationUtil.empty();
    Integer maxParallelism = null;
    Integer preferredMinParallelism = null;
    int defaultParallelism = 1;
    Optional<String> temporaryGcsBucket = BigQueryConfigurationUtil.empty();
    Optional<String> persistentGcsBucket = BigQueryConfigurationUtil.empty();
    Optional<String> persistentGcsPath = BigQueryConfigurationUtil.empty();
    IntermediateFormat intermediateFormat = DEFAULT_INTERMEDIATE_FORMAT;
    DataFormat readDataFormat = DEFAULT_READ_DATA_FORMAT;
    boolean combinePushedDownFilters = true;
    boolean viewsEnabled = false;
    Optional<String> materializationProject = BigQueryConfigurationUtil.empty();
    Optional<String> materializationDataset = BigQueryConfigurationUtil.empty();
    int materializationExpirationTimeInMinutes;
    Optional<String> partitionField = BigQueryConfigurationUtil.empty();
    Long partitionExpirationMs = null;
    Optional<Boolean> partitionRequireFilter = BigQueryConfigurationUtil.empty();
    Optional<TimePartitioning.Type> partitionType = BigQueryConfigurationUtil.empty();
    Optional<Long> partitionRangeStart = BigQueryConfigurationUtil.empty();
    Optional<Long> partitionRangeEnd = BigQueryConfigurationUtil.empty();
    Optional<Long> partitionRangeInterval = BigQueryConfigurationUtil.empty();
    Optional<ImmutableList<String>> clusteredFields = BigQueryConfigurationUtil.empty();
    Optional<JobInfo.CreateDisposition> createDisposition = BigQueryConfigurationUtil.empty();
    boolean optimizedEmptyProjection = true;
    boolean useAvroLogicalTypes = false;
    List<String> decimalTargetTypes = Collections.emptyList();
    List<JobInfo.SchemaUpdateOption> loadSchemaUpdateOptions = Collections.emptyList();
    int maxReadRowsRetries = 3;
    boolean pushAllFilters = true;
    boolean enableModeCheckForSchemaFields = true;
    private Optional<String> encodedCreateReadSessionRequest = BigQueryConfigurationUtil.empty();
    private Optional<String> bigQueryStorageGrpcEndpoint = BigQueryConfigurationUtil.empty();
    private Optional<String> bigQueryHttpEndpoint = BigQueryConfigurationUtil.empty();
    private int numBackgroundThreadsPerStream = 0;
    private int numPrebufferReadRowsResponses = 1;
    private int numStreamsPerPartition = 1;
    private int channelPoolSize = 1;
    private Optional<Integer> flowControlWindowBytes = Optional.absent();
    private boolean enableReadSessionCaching = true;
    private long readSessionCacheDurationMins = 5L;
    private Long snapshotTimeMillis = null;
    private SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig;
    private ArrowSerializationOptions.CompressionCodec arrowCompressionCodec = DEFAULT_ARROW_COMPRESSION_CODEC;
    private ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec = DEFAULT_RESPONSE_COMPRESSION_CODEC;
    private WriteMethod writeMethod = DEFAULT_WRITE_METHOD;
    boolean writeAtLeastOnce = false;
    private int cacheExpirationTimeInMinutes = 15;
    private Optional<String> traceId;
    private Map<String, String> bigQueryJobLabels = Collections.emptyMap();
    private Map<String, String> bigQueryTableLabels = Collections.emptyMap();
    private Optional<Long> createReadSessionTimeoutInSeconds;
    private QueryJobConfiguration.Priority queryJobPriority = DEFAULT_JOB_PRIORITY;
    private Optional<String> destinationTableKmsKeyName = BigQueryConfigurationUtil.empty();
    private boolean allowMapTypeConversion = ALLOW_MAP_TYPE_CONVERSION_DEFAULT;
    private long bigQueryJobTimeoutInMinutes = 360L;
    private Optional<String> gpn;
    private int bigNumericDefaultPrecision;
    private int bigNumericDefaultScale;
    private QueryParameterHelper queryParameterHelper;

    @VisibleForTesting
    SparkBigQueryConfig() {
    }

    public static SparkBigQueryConfig from(Map<String, String> options, ImmutableMap<String, String> customDefaults, DataSourceVersion dataSourceVersion, SparkSession spark, java.util.Optional<StructType> schema, boolean tableIsMandatory) {
        return SparkBigQueryConfig.from(options, customDefaults, dataSourceVersion, spark, schema, tableIsMandatory, java.util.Optional.empty());
    }

    public static SparkBigQueryConfig from(Map<String, String> options, ImmutableMap<String, String> customDefaults, DataSourceVersion dataSourceVersion, SparkSession spark, java.util.Optional<StructType> schema, boolean tableIsMandatory, java.util.Optional<TableId> overrideTableId) {
        HashMap<String, String> optionsMap = new HashMap<String, String>(options);
        dataSourceVersion.updateOptionsMap(optionsMap);
        return SparkBigQueryConfig.from(ImmutableMap.copyOf(optionsMap), ImmutableMap.copyOf(SparkBigQueryUtil.scalaMapToJavaMap(spark.conf().getAll())), spark.sparkContext().hadoopConfiguration(), customDefaults, spark.sparkContext().defaultParallelism(), spark.sessionState().conf(), spark.version(), schema, tableIsMandatory, overrideTableId);
    }

    @VisibleForTesting
    public static SparkBigQueryConfig from(Map<String, String> optionsInput, ImmutableMap<String, String> originalGlobalOptions, Configuration hadoopConfiguration, ImmutableMap<String, String> customDefaults, int defaultParallelism, SQLConf sqlConf, String sparkVersion, java.util.Optional<StructType> schema, boolean tableIsMandatory) {
        return SparkBigQueryConfig.from(optionsInput, originalGlobalOptions, hadoopConfiguration, customDefaults, defaultParallelism, sqlConf, sparkVersion, schema, tableIsMandatory, java.util.Optional.empty());
    }

    @VisibleForTesting
    public static SparkBigQueryConfig from(Map<String, String> optionsInput, ImmutableMap<String, String> originalGlobalOptions, Configuration hadoopConfiguration, ImmutableMap<String, String> customDefaults, int defaultParallelism, SQLConf sqlConf, String sparkVersion, java.util.Optional<StructType> schema, boolean tableIsMandatory, java.util.Optional<TableId> overrideTableId) {
        SparkBigQueryConfig config = new SparkBigQueryConfig();
        ImmutableMap<String, String> options = SparkBigQueryConfig.toLowerCaseKeysMap(optionsInput);
        ImmutableMap<String, String> globalOptions = SparkBigQueryConfig.normalizeConf(originalGlobalOptions);
        config.sparkBigQueryProxyAndHttpConfig = SparkBigQueryProxyAndHttpConfig.from(options, globalOptions, hadoopConfiguration);
        config.viewsEnabled = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, VIEWS_ENABLED_OPTION, false);
        MaterializationConfiguration materializationConfiguration = MaterializationConfiguration.from(globalOptions, options);
        config.materializationProject = materializationConfiguration.getMaterializationProject();
        config.materializationDataset = materializationConfiguration.getMaterializationDataset();
        config.materializationExpirationTimeInMinutes = materializationConfiguration.getMaterializationExpirationTimeInMinutes();
        Optional<String> fallbackDataset = config.materializationDataset;
        java.util.Optional<String> fallbackProject = Optional.fromNullable(hadoopConfiguration.get(GCS_CONFIG_PROJECT_ID_PROPERTY)).toJavaUtil();
        java.util.Optional<String> datasetParam = BigQueryConfigurationUtil.getOption(options, "dataset").or(fallbackDataset).toJavaUtil();
        java.util.Optional<String> projectParam = BigQueryUtil.firstPresent(BigQueryConfigurationUtil.getOption(options, "project").toJavaUtil(), fallbackProject);
        config.partitionType = BigQueryConfigurationUtil.getOption(options, "partitionType").transform(TimePartitioning.Type::valueOf);
        config.partitionRangeStart = BigQueryConfigurationUtil.getOption(options, "partitionRangeStart").transform(Long::parseLong);
        config.partitionRangeEnd = BigQueryConfigurationUtil.getOption(options, "partitionRangeEnd").transform(Long::parseLong);
        config.partitionRangeInterval = BigQueryConfigurationUtil.getOption(options, "partitionRangeInterval").transform(Long::parseLong);
        if (overrideTableId.isPresent()) {
            config.tableId = overrideTableId.get();
        } else {
            java.util.Optional<String> tableParam = BigQueryConfigurationUtil.getOptionFromMultipleParams(options, ImmutableList.of("table", "path"), BigQueryConfigurationUtil.DEFAULT_FALLBACK).toJavaUtil();
            java.util.Optional<String> datePartitionParam = BigQueryConfigurationUtil.getOption(options, DATE_PARTITION_PARAM).toJavaUtil();
            datePartitionParam.ifPresent(date -> SparkBigQueryConfig.validateDateFormat(date, config.getPartitionTypeOrDefault(), DATE_PARTITION_PARAM));
            if (tableParam.isPresent()) {
                String tableParamStr = tableParam.get().trim();
                if (SparkBigQueryConfig.isQuery(tableParamStr)) {
                    config.query = Optional.of(tableParamStr);
                    config.tableId = datasetParam.map(ignored -> BigQueryUtil.parseTableId("QUERY", datasetParam, projectParam, datePartitionParam)).orElse(QUERY_DUMMY_TABLE_ID);
                } else {
                    config.tableId = BigQueryUtil.parseTableId(tableParamStr, datasetParam, projectParam, datePartitionParam);
                }
            } else {
                config.query = BigQueryConfigurationUtil.getOption(options, "query").transform(String::trim);
                if (config.query.isPresent()) {
                    config.tableId = datasetParam.map(ignored -> BigQueryUtil.parseTableId("QUERY", datasetParam, projectParam, datePartitionParam)).orElse(QUERY_DUMMY_TABLE_ID);
                } else if (tableIsMandatory) {
                    throw new IllegalArgumentException("No table has been specified");
                }
            }
        }
        config.parentProjectId = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "parentProject").or(BigQueryConfigurationUtil.defaultBilledProject());
        config.useParentProjectForMetadataOperations = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "useParentProjectForMetadataOperations", false);
        config.accessTokenProviderFQCN = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "gcpAccessTokenProvider");
        config.accessTokenProviderConfig = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "gcpAccessTokenProviderConfig");
        try {
            UserGroupInformation ugiCurrentUser = UserGroupInformation.getCurrentUser();
            config.loggedInUserName = ugiCurrentUser.getShortUserName();
            config.loggedInUserGroups = Sets.newHashSet(ugiCurrentUser.getGroupNames());
        }
        catch (IOException e) {
            throw new BigQueryConnectorException("Failed to get the UserGroupInformation current user", e);
        }
        config.impersonationServiceAccount = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, IMPERSONATION_GLOBAL);
        config.impersonationServiceAccountsForUsers = BigQueryConfigurationUtil.removePrefixFromMapKeys(BigQueryConfigurationUtil.getAnyOptionsWithPrefix(globalOptions, options, IMPERSONATION_FOR_USER_PREFIX.toLowerCase()), IMPERSONATION_FOR_USER_PREFIX.toLowerCase());
        config.impersonationServiceAccountsForGroups = BigQueryConfigurationUtil.removePrefixFromMapKeys(BigQueryConfigurationUtil.getAnyOptionsWithPrefix(globalOptions, options, IMPERSONATION_FOR_GROUP_PREFIX.toLowerCase()), IMPERSONATION_FOR_GROUP_PREFIX.toLowerCase());
        config.accessToken = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "gcpAccessToken");
        config.credentialsKey = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "credentials");
        config.credentialsFile = BigQueryConfigurationUtil.fromJavaUtil(BigQueryUtil.firstPresent(BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "credentialsFile").toJavaUtil(), Optional.fromNullable(hadoopConfiguration.get(GCS_CONFIG_CREDENTIALS_FILE_PROPERTY)).toJavaUtil()));
        config.credentialsScopes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "credentialsScopes").transform(SparkBigQueryConfig::splitOnComma);
        config.filter = BigQueryConfigurationUtil.getOption(options, "filter");
        config.schema = BigQueryConfigurationUtil.fromJavaUtil(schema);
        config.maxParallelism = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, ImmutableList.of("maxParallelism", "parallelism")).transform(Integer::valueOf).orNull();
        config.preferredMinParallelism = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "preferredMinParallelism").transform(Integer::valueOf).orNull();
        config.defaultParallelism = defaultParallelism;
        config.temporaryGcsBucket = SparkBigQueryConfig.stripPrefix(BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "temporaryGcsBucket")).or(Optional.fromNullable(hadoopConfiguration.get(DATAPROC_SYSTEM_BUCKET_CONFIGURATION)));
        config.persistentGcsBucket = SparkBigQueryConfig.stripPrefix(BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "persistentGcsBucket"));
        config.persistentGcsPath = BigQueryConfigurationUtil.getOption(options, "persistentGcsPath");
        WriteMethod writeMethodDefault = java.util.Optional.ofNullable(customDefaults.get(WRITE_METHOD_PARAM)).map(WriteMethod::from).orElse(DEFAULT_WRITE_METHOD);
        config.writeMethod = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, WRITE_METHOD_PARAM).transform(WriteMethod::from).or(writeMethodDefault);
        config.writeAtLeastOnce = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, WRITE_AT_LEAST_ONCE_OPTION, false);
        boolean validateSparkAvro = config.writeMethod == WriteMethod.INDIRECT && Boolean.valueOf(BigQueryConfigurationUtil.getRequiredOption(options, VALIDATE_SPARK_AVRO_PARAM, () -> "true")) != false;
        boolean enableListInferenceForParquetMode = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, ENABLE_LIST_INFERENCE, false);
        String intermediateFormatOption = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, INTERMEDIATE_FORMAT_OPTION).transform(String::toLowerCase).or(DEFAULT_INTERMEDIATE_FORMAT.getDataSource());
        config.intermediateFormat = IntermediateFormat.from(intermediateFormatOption, sparkVersion, sqlConf, validateSparkAvro, enableListInferenceForParquetMode);
        String readDataFormatParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, READ_DATA_FORMAT_OPTION).transform(String::toUpperCase).or(DEFAULT_READ_DATA_FORMAT.toString());
        if (!PERMITTED_READ_DATA_FORMATS.contains(readDataFormatParam)) {
            throw new IllegalArgumentException(String.format("Data read format '%s' is not supported. Supported formats are '%s'", readDataFormatParam, String.join((CharSequence)",", PERMITTED_READ_DATA_FORMATS)));
        }
        config.useAvroLogicalTypes = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, USE_AVRO_LOGICAL_TYPES_OPTION, false);
        config.readDataFormat = DataFormat.valueOf(readDataFormatParam);
        config.combinePushedDownFilters = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "combinePushedDownFilters", true);
        config.partitionField = BigQueryConfigurationUtil.getOption(options, "partitionField");
        config.partitionExpirationMs = (Long)BigQueryConfigurationUtil.getOption(options, "partitionExpirationMs").transform(Long::valueOf).orNull();
        config.partitionRequireFilter = BigQueryConfigurationUtil.getOption(options, "partitionRequireFilter").transform(Boolean::valueOf);
        config.clusteredFields = BigQueryConfigurationUtil.getOption(options, "clusteredFields").transform(SparkBigQueryConfig::splitOnComma);
        config.createDisposition = BigQueryConfigurationUtil.getOption(options, "createDisposition").transform(String::toUpperCase).transform(JobInfo.CreateDisposition::valueOf);
        config.optimizedEmptyProjection = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "optimizedEmptyProjection", true);
        boolean allowFieldAddition = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "allowFieldAddition", false);
        boolean allowFieldRelaxation = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "allowFieldRelaxation", false);
        ImmutableList.Builder loadSchemaUpdateOptions = ImmutableList.builder();
        if (allowFieldAddition) {
            loadSchemaUpdateOptions.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        }
        if (allowFieldRelaxation) {
            loadSchemaUpdateOptions.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
        }
        config.loadSchemaUpdateOptions = Collections.unmodifiableList(loadSchemaUpdateOptions.build());
        config.decimalTargetTypes = BigQueryConfigurationUtil.getOption(options, "decimalTargetTypes").transform(SparkBigQueryConfig::splitOnComma).or(ImmutableList.of());
        config.bigQueryStorageGrpcEndpoint = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bigQueryStorageGrpcEndpoint");
        config.bigQueryHttpEndpoint = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bigQueryHttpEndpoint");
        config.encodedCreateReadSessionRequest = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqEncodedCreateReadSessionRequest");
        config.numBackgroundThreadsPerStream = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqBackgroundThreadsPerStream").transform(Integer::parseInt).or(0);
        config.pushAllFilters = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "pushAllFilters", true);
        config.enableModeCheckForSchemaFields = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "enableModeCheckForSchemaFields", true);
        config.numPrebufferReadRowsResponses = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqPrebufferResponsesPerStream").transform(Integer::parseInt).or(1);
        config.flowControlWindowBytes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqFlowControlWindowBytes").transform(Integer::parseInt);
        config.numStreamsPerPartition = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqNumStreamsPerPartition").transform(Integer::parseInt).or(1);
        int sparkExecutorCores = Integer.parseInt(globalOptions.getOrDefault("spark.executor.cores", "1"));
        int defaultChannelPoolSize = sparkExecutorCores * config.numStreamsPerPartition;
        config.channelPoolSize = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "bqChannelPoolSize").transform(Integer::parseInt).or(defaultChannelPoolSize);
        config.enableReadSessionCaching = BigQueryConfigurationUtil.getAnyBooleanOption(globalOptions, options, "enableReadSessionCaching", true);
        config.readSessionCacheDurationMins = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "readSessionCacheDurationMins").transform(Long::parseLong).or(5L);
        if (config.readSessionCacheDurationMins <= 0L || config.readSessionCacheDurationMins > 300L) {
            throw new IllegalArgumentException("readSessionCacheDurationMins should be > 0 and <= 300");
        }
        String arrowCompressionCodecParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, ARROW_COMPRESSION_CODEC_OPTION).transform(String::toUpperCase).or(DEFAULT_ARROW_COMPRESSION_CODEC.toString());
        try {
            config.arrowCompressionCodec = ArrowSerializationOptions.CompressionCodec.valueOf(arrowCompressionCodecParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Compression codec '%s' for Arrow is not supported. Supported formats are %s", arrowCompressionCodecParam, Arrays.toString(ArrowSerializationOptions.CompressionCodec.values())));
        }
        String responseCompressionCodecParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, RESPONSE_COMPRESSION_CODEC_OPTION).transform(String::toUpperCase).or(DEFAULT_RESPONSE_COMPRESSION_CODEC.toString());
        try {
            config.responseCompressionCodec = ReadSession.TableReadOptions.ResponseCompressionCodec.valueOf(responseCompressionCodecParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Response compression codec '%s' is not supported. Supported formats are %s", responseCompressionCodecParam, Arrays.toString(ReadSession.TableReadOptions.ResponseCompressionCodec.values())));
        }
        config.cacheExpirationTimeInMinutes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "cacheExpirationTimeInMinutes").transform(Integer::parseInt).or(15);
        if (config.cacheExpirationTimeInMinutes < 0) {
            throw new IllegalArgumentException("cacheExpirationTimeInMinutes must have a positive value, the configured value is " + config.cacheExpirationTimeInMinutes);
        }
        Optional<String> traceApplicationNameParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "traceApplicationName").or(Optional.fromNullable("traceApplicationName"));
        config.traceId = traceApplicationNameParam.transform(traceApplicationName -> {
            String traceJobIdParam = BigQueryConfigurationUtil.getAnyOption(globalOptions, (Map<String, String>)options, "traceJobId").or(SparkBigQueryUtil.getJobId(sqlConf));
            String traceIdParam = "Spark:" + traceApplicationName + ":" + traceJobIdParam;
            if (traceIdParam.length() > 256) {
                throw new IllegalArgumentException(String.format("trace ID cannot longer than %d. Provided value was [%s]", 256, traceIdParam));
            }
            return traceIdParam;
        });
        config.bigQueryJobLabels = SparkBigQueryConfig.parseBigQueryLabels(globalOptions, options, BIGQUERY_JOB_LABEL_PREFIX);
        config.bigQueryTableLabels = SparkBigQueryConfig.parseBigQueryLabels(globalOptions, options, BIGQUERY_TABLE_LABEL_PREFIX);
        config.createReadSessionTimeoutInSeconds = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "createReadSessionTimeoutInSeconds").transform(Long::parseLong);
        config.queryJobPriority = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "queryJobPriority").transform(String::toUpperCase).transform(QueryJobConfiguration.Priority::valueOf).or(DEFAULT_JOB_PRIORITY);
        config.destinationTableKmsKeyName = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "destinationTableKmsKeyName");
        config.allowMapTypeConversion = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, ALLOW_MAP_TYPE_CONVERSION).transform(Boolean::valueOf).or(ALLOW_MAP_TYPE_CONVERSION_DEFAULT);
        config.partitionOverwriteModeValue = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, partitionOverwriteModeProperty).transform(String::toUpperCase).transform(PartitionOverwriteMode::valueOf).or(PartitionOverwriteMode.STATIC);
        config.bigQueryJobTimeoutInMinutes = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, BIGQUERY_JOB_TIMEOUT_IN_MINUTES).transform(Long::valueOf).or(360L);
        config.gpn = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, GPN_ATTRIBUTION);
        config.snapshotTimeMillis = (Long)BigQueryConfigurationUtil.getOption(options, "snapshotTimeMillis").transform(Long::valueOf).orNull();
        config.bigNumericDefaultPrecision = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, BIG_NUMERIC_DEFAULT_PRECISION).transform(Integer::parseInt).or(76);
        config.bigNumericDefaultScale = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, BIG_NUMERIC_DEFAULT_SCALE).transform(Integer::parseInt).or(38);
        config.queryParameterHelper = BigQueryUtil.parseQueryParameters(options);
        return config;
    }

    private static ImmutableList<String> splitOnComma(String value) {
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToStream(value).collect(ImmutableList.toImmutableList());
    }

    private static Optional<String> stripPrefix(Optional<String> bucket) {
        return bucket.transform(path -> {
            if (path.startsWith("gs://")) {
                return path.substring(5);
            }
            return path;
        });
    }

    @VisibleForTesting
    static Map<String, String> parseBigQueryLabels(ImmutableMap<String, String> globalOptions, ImmutableMap<String, String> options, String labelPrefix) {
        String lowerCasePrefix = labelPrefix.toLowerCase(Locale.ROOT);
        ImmutableMap<String, String> allOptions = ImmutableMap.builder().putAll(globalOptions).putAll(options).buildKeepingLast();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : allOptions.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase(Locale.ROOT).startsWith(lowerCasePrefix)) continue;
            result.put(((String)entry.getKey()).substring(labelPrefix.length()), entry.getValue());
        }
        return Collections.unmodifiableMap(result.build());
    }

    private static ImmutableMap<String, String> toLowerCaseKeysMap(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
        }
        return ImmutableMap.copyOf(result);
    }

    @VisibleForTesting
    static boolean isQuery(String tableParamStr) {
        if (tableParamStr == null || tableParamStr.trim().isEmpty()) {
            return false;
        }
        String potentialQuery = tableParamStr.trim();
        if (potentialQuery.startsWith("`") && potentialQuery.endsWith("`")) {
            return false;
        }
        if (QUICK_LOWERCASE_QUERY_PATTERN.matcher(potentialQuery).matches()) {
            return true;
        }
        return HAS_WHITESPACE_PATTERN.matcher(potentialQuery).find() && SQL_KEYWORD_PATTERN.matcher(potentialQuery).find();
    }

    private static void validateDateFormat(String date, TimePartitioning.Type partitionType, String optionName) {
        try {
            ImmutableMap<TimePartitioning.Type, DateTimeFormatter> formatterMap = ImmutableMap.of(TimePartitioning.Type.HOUR, DateTimeFormatter.ofPattern("yyyyMMddHH"), TimePartitioning.Type.DAY, DateTimeFormatter.BASIC_ISO_DATE, TimePartitioning.Type.MONTH, DateTimeFormatter.ofPattern("yyyyMM"), TimePartitioning.Type.YEAR, DateTimeFormatter.ofPattern("yyyy"));
            DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)formatterMap.get((Object)partitionType);
            dateTimeFormatter.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Invalid argument for option %s, format is YYYYMMDD", optionName));
        }
    }

    static ImmutableMap<String, String> normalizeConf(Map<String, String> conf) {
        Map<String, String> normalizeConf = conf.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONF_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(CONF_PREFIX.length()), e -> (String)e.getValue()));
        HashMap<String, String> result = new HashMap<String, String>(conf);
        result.putAll(normalizeConf);
        return ImmutableMap.copyOf(result);
    }

    public Credentials createCredentials() {
        return new BigQueryCredentialsSupplier(this.accessTokenProviderFQCN.toJavaUtil(), this.accessTokenProviderConfig.toJavaUtil(), this.accessToken.toJavaUtil(), this.credentialsKey.toJavaUtil(), this.credentialsFile.toJavaUtil(), this.loggedInUserName, this.loggedInUserGroups, this.impersonationServiceAccountsForUsers.toJavaUtil(), this.impersonationServiceAccountsForGroups.toJavaUtil(), this.impersonationServiceAccount.toJavaUtil(), this.credentialsScopes.toJavaUtil(), this.sparkBigQueryProxyAndHttpConfig.getProxyUri(), this.sparkBigQueryProxyAndHttpConfig.getProxyUsername(), this.sparkBigQueryProxyAndHttpConfig.getProxyPassword()).getCredentials();
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    public TableId getTableIdWithExplicitProject() {
        if (this.tableId.getProject() != null) {
            return this.tableId;
        }
        return TableId.of(ServiceOptions.getDefaultProjectId(), this.tableId.getDataset(), this.tableId.getTable());
    }

    public TableId getTableIdWithoutThePartition() {
        String tableAndPartition = this.tableId.getTable();
        if (!tableAndPartition.contains("$")) {
            return this.tableId;
        }
        String table = tableAndPartition.substring(0, tableAndPartition.indexOf(36));
        return this.tableId.getProject() != null ? TableId.of(this.tableId.getProject(), this.tableId.getDataset(), table) : TableId.of(this.tableId.getDataset(), table);
    }

    public java.util.Optional<String> getQuery() {
        return this.query.toJavaUtil();
    }

    public QueryParameterHelper getQueryParameterHelper() {
        return this.queryParameterHelper;
    }

    @Override
    public String getParentProjectId() {
        return this.parentProjectId;
    }

    @Override
    public boolean useParentProjectForMetadataOperations() {
        return this.useParentProjectForMetadataOperations;
    }

    @Override
    public java.util.Optional<String> getAccessTokenProviderFQCN() {
        return this.accessTokenProviderFQCN.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getAccessTokenProviderConfig() {
        return this.accessTokenProviderConfig.toJavaUtil();
    }

    @Override
    public String getLoggedInUserName() {
        return this.loggedInUserName;
    }

    @Override
    public Set<String> getLoggedInUserGroups() {
        return this.loggedInUserGroups;
    }

    @Override
    public java.util.Optional<Map<String, String>> getImpersonationServiceAccountsForUsers() {
        return this.impersonationServiceAccountsForUsers.toJavaUtil();
    }

    @Override
    public java.util.Optional<Map<String, String>> getImpersonationServiceAccountsForGroups() {
        return this.impersonationServiceAccountsForGroups.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getImpersonationServiceAccount() {
        return this.impersonationServiceAccount.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getCredentialsKey() {
        return this.credentialsKey.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getCredentialsFile() {
        return this.credentialsFile.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getAccessToken() {
        return this.accessToken.toJavaUtil();
    }

    @Override
    public java.util.Optional<ImmutableList<String>> getCredentialsScopes() {
        return this.credentialsScopes.toJavaUtil();
    }

    public java.util.Optional<String> getFilter() {
        return this.filter.toJavaUtil();
    }

    public java.util.Optional<StructType> getSchema() {
        return this.schema.toJavaUtil();
    }

    public OptionalInt getMaxParallelism() {
        return this.maxParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.maxParallelism);
    }

    public OptionalInt getPreferredMinParallelism() {
        return this.preferredMinParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.preferredMinParallelism);
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public java.util.Optional<String> getTemporaryGcsBucket() {
        return this.temporaryGcsBucket.toJavaUtil();
    }

    public java.util.Optional<String> getPersistentGcsBucket() {
        return this.persistentGcsBucket.toJavaUtil();
    }

    public java.util.Optional<String> getPersistentGcsPath() {
        return this.persistentGcsPath.toJavaUtil();
    }

    public IntermediateFormat getIntermediateFormat() {
        return this.intermediateFormat;
    }

    public DataFormat getReadDataFormat() {
        return this.readDataFormat;
    }

    public ArrowSerializationOptions.CompressionCodec getArrowCompressionCodec() {
        return this.arrowCompressionCodec;
    }

    public ReadSession.TableReadOptions.ResponseCompressionCodec getResponseCompressionCodec() {
        return this.responseCompressionCodec;
    }

    public boolean isCombinePushedDownFilters() {
        return this.combinePushedDownFilters;
    }

    @Override
    public boolean isUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    public ImmutableList<String> getDecimalTargetTypes() {
        return ImmutableList.copyOf(this.decimalTargetTypes);
    }

    @Override
    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Override
    public java.util.Optional<String> getMaterializationProject() {
        return this.materializationProject.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getMaterializationDataset() {
        return this.materializationDataset.toJavaUtil();
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }

    @Override
    public java.util.Optional<String> getPartitionField() {
        return this.partitionField.toJavaUtil();
    }

    @Override
    public OptionalLong getPartitionExpirationMs() {
        return this.partitionExpirationMs == null ? OptionalLong.empty() : OptionalLong.of(this.partitionExpirationMs);
    }

    @Override
    public java.util.Optional<Boolean> getPartitionRequireFilter() {
        return this.partitionRequireFilter.toJavaUtil();
    }

    @Override
    public java.util.Optional<TimePartitioning.Type> getPartitionType() {
        return this.partitionType.toJavaUtil();
    }

    @Override
    public java.util.Optional<RangePartitioning.Range> getPartitionRange() {
        if (this.partitionRangeStart.isPresent() && this.partitionRangeEnd.isPresent() && this.partitionRangeInterval.isPresent()) {
            return java.util.Optional.of(RangePartitioning.Range.newBuilder().setStart(this.partitionRangeStart.get()).setEnd(this.partitionRangeEnd.get()).setInterval(this.partitionRangeInterval.get()).build());
        }
        return java.util.Optional.empty();
    }

    @Override
    public TimePartitioning.Type getPartitionTypeOrDefault() {
        return this.partitionType.or(TimePartitioning.Type.DAY);
    }

    @Override
    public java.util.Optional<ImmutableList<String>> getClusteredFields() {
        return this.clusteredFields.transform(fields -> ImmutableList.copyOf(fields)).toJavaUtil();
    }

    @Override
    public java.util.Optional<JobInfo.CreateDisposition> getCreateDisposition() {
        return this.createDisposition.toJavaUtil();
    }

    public boolean isOptimizedEmptyProjection() {
        return this.optimizedEmptyProjection;
    }

    public ImmutableList<JobInfo.SchemaUpdateOption> getLoadSchemaUpdateOptions() {
        return ImmutableList.copyOf(this.loadSchemaUpdateOptions);
    }

    public int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    public boolean getPushAllFilters() {
        return this.pushAllFilters;
    }

    @Override
    public boolean getEnableModeCheckForSchemaFields() {
        return this.enableModeCheckForSchemaFields;
    }

    @Override
    public int getBigQueryClientConnectTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpConnectTimeout().orElse(60000);
    }

    @Override
    public int getBigQueryClientReadTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpReadTimeout().orElse(60000);
    }

    @Override
    public BigQueryProxyConfig getBigQueryProxyConfig() {
        return this.sparkBigQueryProxyAndHttpConfig;
    }

    @Override
    public java.util.Optional<String> getBigQueryStorageGrpcEndpoint() {
        return this.bigQueryStorageGrpcEndpoint.toJavaUtil();
    }

    @Override
    public java.util.Optional<String> getBigQueryHttpEndpoint() {
        return this.bigQueryHttpEndpoint.toJavaUtil();
    }

    @Override
    public int getCacheExpirationTimeInMinutes() {
        return this.cacheExpirationTimeInMinutes;
    }

    @Override
    public java.util.Optional<Long> getCreateReadSessionTimeoutInSeconds() {
        return this.createReadSessionTimeoutInSeconds.toJavaUtil();
    }

    public PartitionOverwriteMode getPartitionOverwriteModeValue() {
        return this.partitionOverwriteModeValue;
    }

    @Override
    public int getChannelPoolSize() {
        return this.channelPoolSize;
    }

    @Override
    public java.util.Optional<Integer> getFlowControlWindowBytes() {
        return this.flowControlWindowBytes.toJavaUtil();
    }

    @Override
    public QueryJobConfiguration.Priority getQueryJobPriority() {
        return this.queryJobPriority;
    }

    @Override
    public java.util.Optional<String> getKmsKeyName() {
        return this.destinationTableKmsKeyName.toJavaUtil();
    }

    @Override
    public RetrySettings getBigQueryClientRetrySettings() {
        int maxAttempts = this.sparkBigQueryProxyAndHttpConfig.getHttpMaxRetry().orElse(10);
        return SparkBigQueryConfig.getRetrySettings(maxAttempts);
    }

    private static RetrySettings getRetrySettings(int maxAttempts) {
        return RetrySettings.newBuilder().setMaxAttempts(maxAttempts).setTotalTimeout(Duration.ofMinutes(10L)).setInitialRpcTimeout(Duration.ofSeconds(60L)).setMaxRpcTimeout(Duration.ofMinutes(5L)).setRpcTimeoutMultiplier(1.6).setRetryDelayMultiplier(1.6).setInitialRetryDelay(Duration.ofMillis(1250L)).setMaxRetryDelay(Duration.ofSeconds(5L)).build();
    }

    public RetrySettings getBigqueryDataWriteHelperRetrySettings() {
        return SparkBigQueryConfig.getRetrySettings(5);
    }

    public WriteMethod getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isWriteAtLeastOnce() {
        return this.writeAtLeastOnce;
    }

    public java.util.Optional<String> getTraceId() {
        return this.traceId.toJavaUtil();
    }

    @Override
    public ImmutableMap<String, String> getBigQueryJobLabels() {
        return ImmutableMap.copyOf(this.bigQueryJobLabels);
    }

    public boolean getAllowMapTypeConversion() {
        return this.allowMapTypeConversion;
    }

    @Override
    public long getBigQueryJobTimeoutInMinutes() {
        return this.bigQueryJobTimeoutInMinutes;
    }

    public ImmutableMap<String, String> getBigQueryTableLabels() {
        return ImmutableMap.copyOf(this.bigQueryTableLabels);
    }

    public java.util.Optional<String> getGpn() {
        return this.gpn.toJavaUtil();
    }

    public OptionalLong getSnapshotTimeMillis() {
        return this.snapshotTimeMillis == null ? OptionalLong.empty() : OptionalLong.of(this.snapshotTimeMillis);
    }

    public int getBigNumericDefaultPrecision() {
        return this.bigNumericDefaultPrecision;
    }

    public int getBigNumericDefaultScale() {
        return this.bigNumericDefaultScale;
    }

    public ReadSessionCreatorConfig toReadSessionCreatorConfig() {
        return new ReadSessionCreatorConfigBuilder().setViewsEnabled(this.viewsEnabled).setMaterializationProject(this.materializationProject.toJavaUtil()).setMaterializationDataset(this.materializationDataset.toJavaUtil()).setMaterializationExpirationTimeInMinutes(this.materializationExpirationTimeInMinutes).setReadDataFormat(this.readDataFormat).setMaxReadRowsRetries(this.maxReadRowsRetries).setViewEnabledParamName(VIEWS_ENABLED_OPTION).setDefaultParallelism(this.defaultParallelism).setMaxParallelism(this.getMaxParallelism()).setPreferredMinParallelism(this.getPreferredMinParallelism()).setRequestEncodedBase(this.encodedCreateReadSessionRequest.toJavaUtil()).setBigQueryStorageGrpcEndpoint(this.bigQueryStorageGrpcEndpoint.toJavaUtil()).setBigQueryHttpEndpoint(this.bigQueryHttpEndpoint.toJavaUtil()).setBackgroundParsingThreads(this.numBackgroundThreadsPerStream).setPushAllFilters(this.pushAllFilters).setPrebufferReadRowsResponses(this.numPrebufferReadRowsResponses).setStreamsPerPartition(this.numStreamsPerPartition).setArrowCompressionCodec(this.arrowCompressionCodec).setResponseCompressionCodec(this.responseCompressionCodec).setTraceId(this.traceId.toJavaUtil()).setEnableReadSessionCaching(this.enableReadSessionCaching).setReadSessionCacheDurationMins(this.readSessionCacheDurationMins).setSnapshotTimeMillis(this.getSnapshotTimeMillis()).build();
    }

    public BigQueryClient.ReadTableOptions toReadTableOptions() {
        return new BigQueryClient.ReadTableOptions(){

            @Override
            public TableId tableId() {
                return SparkBigQueryConfig.this.getTableId();
            }

            @Override
            public java.util.Optional<String> query() {
                return SparkBigQueryConfig.this.getQuery();
            }

            @Override
            public boolean viewsEnabled() {
                return SparkBigQueryConfig.this.isViewsEnabled();
            }

            @Override
            public String viewEnabledParamName() {
                return SparkBigQueryConfig.VIEWS_ENABLED_OPTION;
            }

            @Override
            public QueryParameterHelper getQueryParameterHelper() {
                return SparkBigQueryConfig.this.getQueryParameterHelper();
            }

            @Override
            public int expirationTimeInMinutes() {
                return SparkBigQueryConfig.this.getMaterializationExpirationTimeInMinutes();
            }
        };
    }

    public static enum IntermediateFormat {
        AVRO("avro", FormatOptions.avro()),
        AVRO_2_3("com.databricks.spark.avro", FormatOptions.avro()),
        ORC("orc", FormatOptions.orc()),
        PARQUET("parquet", FormatOptions.parquet()),
        PARQUET_LIST_INFERENCE_ENABLED("parquet", ParquetOptions.newBuilder().setEnableListInference(true).build());

        private static Set<String> PERMITTED_DATA_SOURCES;
        private final String dataSource;
        private final FormatOptions formatOptions;

        private IntermediateFormat(String dataSource, FormatOptions formatOptions) {
            this.dataSource = dataSource;
            this.formatOptions = formatOptions;
        }

        public static IntermediateFormat from(String format, String sparkVersion, SQLConf sqlConf, boolean validateSparkAvro, boolean enableListInferenceForParquetMode) {
            Preconditions.checkArgument(PERMITTED_DATA_SOURCES.contains(format.toLowerCase()), "Data write format '%s' is not supported. Supported formats are %s", (Object)format, PERMITTED_DATA_SOURCES);
            if (validateSparkAvro && format.equalsIgnoreCase("avro")) {
                IntermediateFormat intermediateFormat2 = IntermediateFormat.isSpark24OrAbove(sparkVersion) ? AVRO : AVRO_2_3;
                try {
                    DataSource.lookupDataSource((String)intermediateFormat2.getDataSource(), (SQLConf)sqlConf);
                }
                catch (Exception ae) {
                    throw IntermediateFormat.missingAvroException(sparkVersion, ae);
                }
                return intermediateFormat2;
            }
            if (enableListInferenceForParquetMode && format.equalsIgnoreCase("parquet")) {
                return PARQUET_LIST_INFERENCE_ENABLED;
            }
            return Stream.of(IntermediateFormat.values()).filter(intermediateFormat -> intermediateFormat.getDataSource().equalsIgnoreCase(format)).findFirst().get();
        }

        static boolean isSpark24OrAbove(String sparkVersion) {
            return sparkVersion.compareTo("2.4") > 0;
        }

        @VisibleForTesting
        static IllegalStateException missingAvroException(String sparkVersion, Exception cause) {
            String avroPackage;
            if (IntermediateFormat.isSpark24OrAbove(sparkVersion)) {
                String scalaVersion = Properties.versionNumberString();
                String scalaShortVersion = scalaVersion.substring(0, scalaVersion.lastIndexOf(46));
                avroPackage = String.format("org.apache.spark:spark-avro_%s:%s", scalaShortVersion, sparkVersion);
            } else {
                avroPackage = "com.databricks:spark-avro_2.11:4.0.0";
            }
            String message = String.format("Avro writing is not supported, as the spark-avro has not been found. Please re-run spark with the --packages %s parameter", avroPackage);
            return new IllegalStateException(message, cause);
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public FormatOptions getFormatOptions() {
            return this.formatOptions;
        }

        public String getFileSuffix() {
            return this.getFormatOptions().getType().toLowerCase();
        }

        static {
            PERMITTED_DATA_SOURCES = Stream.of(IntermediateFormat.values()).map(IntermediateFormat::getDataSource).filter(dataSource -> !dataSource.contains(".")).collect(Collectors.toSet());
        }
    }

    public static enum WriteMethod {
        DIRECT,
        INDIRECT;


        public static WriteMethod from(@Nullable String writeMethod) {
            try {
                return WriteMethod.valueOf(writeMethod.toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("WriteMethod can be only " + Arrays.toString((Object[])WriteMethod.values()));
            }
        }
    }
}

