/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.apache;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.LowLevelHttpRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.LowLevelHttpResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.apache.ApacheHttpResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.apache.ContentEntity;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.HttpEntityEnclosingRequest;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.client.HttpClient;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.client.methods.HttpRequestBase;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.conn.params.ConnManagerParams;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.params.HttpParams;
import java.io.IOException;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        HttpParams params = this.request.getParams();
        ConnManagerParams.setTimeout(params, connectTimeout);
        HttpConnectionParams.setConnectionTimeout(params, connectTimeout);
        HttpConnectionParams.setSoTimeout(params, readTimeout);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkState(this.request instanceof HttpEntityEnclosingRequest, "Apache HTTP client does not support %s requests with content.", this.request.getRequestLine().getMethod());
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            if (this.getContentLength() == -1L) {
                entity.setChunked(true);
            }
            ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        }
        return new ApacheHttpResponse(this.request, this.httpClient.execute(this.request));
    }
}

