/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetryingFuture;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.AttemptCallable;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.RequestMutator;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;

class RetryingCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiCallContext callContextPrototype;
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RetryingExecutorWithContext<ResponseT> executor;
    private final RequestMutator<RequestT> requestMutator;

    RetryingCallable(ApiCallContext callContextPrototype, UnaryCallable<RequestT, ResponseT> callable, RetryingExecutorWithContext<ResponseT> executor) {
        this(callContextPrototype, callable, executor, null);
    }

    RetryingCallable(ApiCallContext callContextPrototype, UnaryCallable<RequestT, ResponseT> callable, RetryingExecutorWithContext<ResponseT> executor, RequestMutator<RequestT> requestMutator) {
        this.callContextPrototype = Preconditions.checkNotNull(callContextPrototype);
        this.callable = Preconditions.checkNotNull(callable);
        this.executor = Preconditions.checkNotNull(executor);
        this.requestMutator = requestMutator;
    }

    @Override
    public RetryingFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        ApiCallContext context = this.callContextPrototype.nullToSelf(inputContext);
        RequestT modifiedRequest = request;
        if (this.requestMutator != null) {
            modifiedRequest = this.requestMutator.apply(request);
        }
        AttemptCallable<RequestT, ResponseT> retryCallable = new AttemptCallable<RequestT, ResponseT>(this.callable, modifiedRequest, context);
        RetryingFuture<ResponseT> retryingFuture = this.executor.createFuture(retryCallable, inputContext);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

