/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2;

import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.AwsSecurityCredentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

class AwsRequestSignature {
    private AwsSecurityCredentials awsSecurityCredentials;
    private Map<String, String> canonicalHeaders;
    private String signature;
    private String credentialScope;
    private String url;
    private String httpMethod;
    private String date;
    private String region;
    private String authorizationHeader;

    private AwsRequestSignature(AwsSecurityCredentials awsSecurityCredentials, Map<String, String> canonicalHeaders, String signature, String credentialScope, String url, String httpMethod, String date, String region, String authorizationHeader) {
        this.awsSecurityCredentials = awsSecurityCredentials;
        this.canonicalHeaders = canonicalHeaders;
        this.signature = signature;
        this.credentialScope = credentialScope;
        this.url = url;
        this.httpMethod = httpMethod;
        this.date = date;
        this.region = region;
        this.authorizationHeader = authorizationHeader;
    }

    String getSignature() {
        return this.signature;
    }

    String getCredentialScope() {
        return this.credentialScope;
    }

    AwsSecurityCredentials getSecurityCredentials() {
        return this.awsSecurityCredentials;
    }

    String getUrl() {
        return this.url;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    Map<String, String> getCanonicalHeaders() {
        return new HashMap<String, String>(this.canonicalHeaders);
    }

    String getDate() {
        return this.date;
    }

    String getRegion() {
        return this.region;
    }

    String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    static class Builder {
        private AwsSecurityCredentials awsSecurityCredentials;
        private Map<String, String> canonicalHeaders;
        private String signature;
        private String credentialScope;
        private String url;
        private String httpMethod;
        private String date;
        private String region;
        private String authorizationHeader;

        Builder() {
        }

        @CanIgnoreReturnValue
        Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setCredentialScope(String credentialScope) {
            this.credentialScope = credentialScope;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setSecurityCredentials(AwsSecurityCredentials awsSecurityCredentials) {
            this.awsSecurityCredentials = awsSecurityCredentials;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setCanonicalHeaders(Map<String, String> canonicalHeaders) {
            this.canonicalHeaders = new HashMap<String, String>(canonicalHeaders);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setDate(String date) {
            this.date = date;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setAuthorizationHeader(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
            return this;
        }

        AwsRequestSignature build() {
            return new AwsRequestSignature(this.awsSecurityCredentials, this.canonicalHeaders, this.signature, this.credentialScope, this.url, this.httpMethod, this.date, this.region, this.authorizationHeader);
        }
    }
}

