/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.toprettystring.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreElements;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.service.AutoService;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.toprettystring.processor.ToPrettyStringMethods;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.toprettystring.ToPrettyString"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public final class ToPrettyStringValidator
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        Types types = this.processingEnv.getTypeUtils();
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement toPrettyString = elements.getTypeElement("com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.toprettystring.ToPrettyString");
        Set<ExecutableElement> annotatedMethods = ElementFilter.methodsIn(roundEnvironment.getElementsAnnotatedWith(toPrettyString));
        for (ExecutableElement method : annotatedMethods) {
            this.validateMethod(method, elements);
        }
        this.validateSingleToPrettyStringMethod(annotatedMethods, types, elements);
        return false;
    }

    private void validateMethod(ExecutableElement method, Elements elements) {
        ErrorReporter errorReporter = new ErrorReporter(method, this.processingEnv.getMessager());
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            errorReporter.reportError("@ToPrettyString methods must be instance methods");
        }
        TypeMirror stringType = elements.getTypeElement("java.lang.String").asType();
        if (!MoreTypes.equivalence().equivalent(method.getReturnType(), stringType)) {
            errorReporter.reportError("@ToPrettyString methods must return String");
        }
        if (!method.getParameters().isEmpty()) {
            errorReporter.reportError("@ToPrettyString methods cannot have parameters");
        }
    }

    private void validateSingleToPrettyStringMethod(Set<ExecutableElement> annotatedMethods, Types types, Elements elements) {
        Set enclosingTypes = annotatedMethods.stream().map(Element::getEnclosingElement).map(MoreElements::asType).collect(Collectors.toCollection(LinkedHashSet::new));
        for (TypeElement enclosingType : enclosingTypes) {
            ImmutableList<ExecutableElement> methods = ToPrettyStringMethods.toPrettyStringMethods(enclosingType, types, elements);
            if (methods.size() <= 1) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s has multiple @ToPrettyString methods:%s", enclosingType.getQualifiedName(), this.formatMethodList(methods)), enclosingType);
        }
    }

    private String formatMethodList(ImmutableList<ExecutableElement> methods) {
        return methods.stream().map(this::formatMethodInList).collect(Collectors.joining());
    }

    private String formatMethodInList(ExecutableElement method) {
        return String.format("\n  - %s.%s()", MoreElements.asType(method.getEnclosingElement()).getQualifiedName(), method.getSimpleName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private static final class ErrorReporter {
        private final ExecutableElement method;
        private final Messager messager;

        ErrorReporter(ExecutableElement method, Messager messager) {
            this.method = method;
            this.messager = messager;
        }

        void reportError(String error) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.method);
        }
    }
}

