/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.BaseServiceException;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.RetryHelper;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQueryRetryHelper;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.http.BaseHttpServiceException;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public final class BigQueryException
extends BaseHttpServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of(new BaseServiceException.Error(500, null), new BaseServiceException.Error(502, null), new BaseServiceException.Error(503, null), new BaseServiceException.Error(504, null));
    private static final long serialVersionUID = -5006625989225438209L;
    private final List<BigQueryError> errors;

    public BigQueryException(int code, String message) {
        this(code, message, (Throwable)null);
    }

    public BigQueryException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
        this.errors = null;
    }

    public BigQueryException(int code, String message, BigQueryError error) {
        super(code, message, error != null ? error.getReason() : null, true, RETRYABLE_ERRORS);
        this.errors = Arrays.asList(error);
    }

    public BigQueryException(List<BigQueryError> errors) {
        super(0, errors != null ? errors.get(0).getMessage() : null, errors != null ? errors.get(0).getReason() : null, true, RETRYABLE_ERRORS);
        this.errors = errors;
    }

    public BigQueryException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
        List<BigQueryError> errors = null;
        if (this.getReason() != null) {
            errors = Arrays.asList(new BigQueryError(this.getReason(), this.getLocation(), this.getMessage(), this.getDebugInfo()));
        }
        this.errors = errors;
    }

    public BigQueryError getError() {
        return this.errors == null || this.errors.isEmpty() || this.errors.size() == 0 ? null : this.errors.get(0);
    }

    public List<BigQueryError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BigQueryException)) {
            return false;
        }
        BigQueryException other = (BigQueryException)obj;
        return super.equals(other) && Objects.equals(this.errors, other.errors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errors);
    }

    static BaseServiceException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate(ex);
        throw new BigQueryException(0, ex.getMessage(), ex.getCause());
    }

    static BaseServiceException translateAndThrow(BigQueryRetryHelper.BigQueryRetryHelperException ex) {
        if (ex.getCause() instanceof BaseServiceException) {
            throw (BaseServiceException)ex.getCause();
        }
        throw new BigQueryException(0, ex.getMessage(), ex.getCause());
    }

    static BaseServiceException translateAndThrow(ExecutionException ex) {
        BaseServiceException.translate(ex);
        throw new BigQueryException(0, ex.getMessage(), ex.getCause());
    }

    static BaseServiceException translateAndThrow(Exception ex) {
        throw new BigQueryException(0, ex.getMessage(), ex.getCause());
    }

    static BaseServiceException translateAndThrowBigQuerySQLException(BigQueryException e) throws BigQuerySQLException {
        throw new BigQuerySQLException(e.getMessage(), e, e.getErrors());
    }
}

