/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Data;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Field;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FieldList;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Range;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.io.BaseEncoding;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.PeriodDuration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldValue
implements Serializable {
    private static final int MICROSECONDS = 1000000;
    private static final long serialVersionUID = 469098630191710062L;
    private final Attribute attribute;
    private final Object value;
    private final Boolean useInt64Timestamps;

    private FieldValue(Attribute attribute, Object value) {
        this(attribute, value, false);
    }

    private FieldValue(Attribute attribute, Object value, Boolean useInt64Timestamps) {
        this.attribute = Preconditions.checkNotNull(attribute);
        this.value = value;
        this.useInt64Timestamps = useInt64Timestamps;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public Boolean getUseInt64Timestamps() {
        return this.useInt64Timestamps;
    }

    public String getStringValue() {
        Preconditions.checkNotNull(this.value);
        return (String)this.value;
    }

    public String getStringValueOrDefault(String defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        return this.getStringValue();
    }

    public byte[] getBytesValue() {
        try {
            return BaseEncoding.base64().decode(this.getStringValue());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public long getLongValue() {
        return Long.parseLong(this.getStringValue());
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getStringValue());
    }

    public boolean getBooleanValue() {
        String stringValue = this.getStringValue();
        Preconditions.checkState(stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false"), "Field value is not of boolean type");
        return Boolean.parseBoolean(stringValue);
    }

    public long getTimestampValue() {
        if (this.useInt64Timestamps.booleanValue()) {
            return new BigInteger(this.getStringValue()).longValue();
        }
        BigDecimal secondsWithMicro = new BigDecimal(this.getStringValue());
        BigDecimal scaled = secondsWithMicro.scaleByPowerOfTen(6).setScale(0, RoundingMode.HALF_UP);
        return scaled.longValue();
    }

    public Instant getTimestampInstant() {
        Preconditions.checkNotNull(this.value);
        return Instant.EPOCH.plus(this.getTimestampValue(), ChronoUnit.MICROS);
    }

    public BigDecimal getNumericValue() {
        return new BigDecimal(this.getStringValue());
    }

    public Range getRangeValue() {
        if (this.attribute == Attribute.RANGE) {
            return (Range)this.value;
        }
        return Range.of(this.getStringValue());
    }

    public List<FieldValue> getRepeatedValue() {
        Preconditions.checkNotNull(this.value);
        return (List)this.value;
    }

    public PeriodDuration getPeriodDuration() {
        Preconditions.checkNotNull(this.value);
        try {
            return PeriodDuration.parse(this.getStringValue());
        }
        catch (DateTimeParseException dateTimeParseException) {
            return FieldValue.parseCanonicalInterval(this.getStringValue());
        }
    }

    public FieldValueList getRecordValue() {
        Preconditions.checkNotNull(this.value);
        return (FieldValueList)this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("attribute", (Object)this.attribute).add("value", this.value).add("useInt64Timestamps", this.useInt64Timestamps).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.value, this.useInt64Timestamps});
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(FieldValue.class)) {
            return false;
        }
        FieldValue other = (FieldValue)obj;
        return this.attribute == other.attribute && Objects.equals(this.value, other.value) && Objects.equals(this.useInt64Timestamps, other.useInt64Timestamps);
    }

    @BetaApi
    public static FieldValue of(Attribute attribute, Object value) {
        return FieldValue.of(attribute, value, false);
    }

    @BetaApi
    public static FieldValue of(Attribute attribute, Object value, Boolean useInt64Timestamps) {
        return new FieldValue(attribute, value, useInt64Timestamps);
    }

    static FieldValue fromPb(Object cellPb) {
        return FieldValue.fromPb(cellPb, null, false);
    }

    static FieldValue fromPb(Object cellPb, Field recordSchema, Boolean useInt64Timestamps) {
        if (Data.isNull(cellPb)) {
            return FieldValue.of(Attribute.PRIMITIVE, null, useInt64Timestamps);
        }
        if (cellPb instanceof String) {
            if (recordSchema != null && recordSchema.getType() == LegacySQLTypeName.RANGE && recordSchema.getRangeElementType() != null) {
                return FieldValue.of(Attribute.RANGE, Range.of((String)cellPb, recordSchema.getRangeElementType()), useInt64Timestamps);
            }
            return FieldValue.of(Attribute.PRIMITIVE, cellPb, useInt64Timestamps);
        }
        if (cellPb instanceof List) {
            return FieldValue.of(Attribute.REPEATED, FieldValueList.fromPb((List)cellPb, null, useInt64Timestamps));
        }
        if (cellPb instanceof Map) {
            Map cellMapPb = (Map)cellPb;
            if (cellMapPb.containsKey("f")) {
                FieldList subFieldsSchema = recordSchema != null ? recordSchema.getSubFields() : null;
                return FieldValue.of(Attribute.RECORD, FieldValueList.fromPb((List)cellMapPb.get("f"), subFieldsSchema, useInt64Timestamps));
            }
            if (cellMapPb.containsKey("v")) {
                return FieldValue.fromPb(cellMapPb.get("v"), recordSchema, useInt64Timestamps);
            }
        }
        throw new IllegalArgumentException("Unexpected table cell format");
    }

    static PeriodDuration parseCanonicalInterval(String interval) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile("(?<sign1>[+-])?(?<year>\\d+)-(?<month>\\d+) (?<sign2>[-|+])?(?<day>\\d+) (?<sign3>[-|+])?(?<hours>\\d+):(?<minutes>\\d+):(?<seconds>\\d+)(\\.(?<fraction>\\d+))?");
        Matcher matcher = pattern.matcher(interval);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        String sign1 = matcher.group("sign1");
        String year = matcher.group("year");
        String month = matcher.group("month");
        String sign2 = matcher.group("sign2");
        String day = matcher.group("day");
        String sign3 = matcher.group("sign3");
        String hours = matcher.group("hours");
        String minutes = matcher.group("minutes");
        String seconds = matcher.group("seconds");
        String fraction = matcher.group("fraction");
        int yearInt = Integer.parseInt(year);
        int monthInt = Integer.parseInt(month);
        if (Objects.equals(sign1, "-")) {
            yearInt *= -1;
            monthInt *= -1;
        }
        int dayInt = Integer.parseInt(day);
        if (Objects.equals(sign2, "-")) {
            dayInt *= -1;
        }
        if (sign3 == null) {
            sign3 = "";
        }
        String durationString = sign3 + "PT" + hours + "H" + minutes + "M" + seconds + (fraction == null ? "" : "." + fraction) + "S";
        return PeriodDuration.of(Period.of(yearInt, monthInt, dayInt), Duration.parse(durationString));
    }

    public static enum Attribute {
        PRIMITIVE,
        REPEATED,
        RECORD,
        RANGE;

    }
}

