/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Model;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.TrainingRun;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Annotations;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ModelId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Function;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Lists;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelInfo
implements Serializable {
    static final Function<Model, ModelInfo> FROM_PB_FUNCTION = new Function<Model, ModelInfo>(){

        @Override
        public ModelInfo apply(Model pb) {
            return ModelInfo.fromPb(pb);
        }
    };
    static final Function<ModelInfo, Model> TO_PB_FUNCTION = new Function<ModelInfo, Model>(){

        @Override
        public Model apply(ModelInfo ModelInfo2) {
            return ModelInfo2.toPb();
        }
    };
    private static final long serialVersionUID = 609769793337719407L;
    private final String etag;
    private final ModelId modelId;
    private final String description;
    private final String modelType;
    private final String friendlyName;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final Long expirationTime;
    private final Annotations labels;
    private final String location;
    private final ImmutableList<TrainingRun> trainingRunList;
    private final ImmutableList<StandardSQLField> featureColumnList;
    private final ImmutableList<StandardSQLField> labelColumnList;
    private final EncryptionConfiguration encryptionConfiguration;

    ModelInfo(BuilderImpl builder) {
        this.modelId = Preconditions.checkNotNull(builder.modelId);
        this.etag = builder.etag;
        this.modelType = builder.modelType;
        this.description = builder.description;
        this.friendlyName = builder.friendlyName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.expirationTime = builder.expirationTime;
        this.labels = builder.labels;
        this.location = builder.location;
        this.trainingRunList = ImmutableList.copyOf(builder.trainingRunList);
        this.labelColumnList = ImmutableList.copyOf(builder.labelColumnList);
        this.featureColumnList = ImmutableList.copyOf(builder.featureColumnList);
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public String getEtag() {
        return this.etag;
    }

    public ModelId getModelId() {
        return this.modelId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public Map<String, String> getLabels() {
        return this.labels.userMap();
    }

    public String getLocation() {
        return this.location;
    }

    @BetaApi
    public ImmutableList<TrainingRun> getTrainingRuns() {
        return this.trainingRunList;
    }

    @BetaApi
    public ImmutableList<StandardSQLField> getLabelColumns() {
        return this.labelColumnList;
    }

    @BetaApi
    public ImmutableList<StandardSQLField> getFeatureColumns() {
        return this.featureColumnList;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("modelId", this.modelId).add("etag", this.etag).add("modelType", this.modelType).add("description", this.description).add("friendlyName", this.friendlyName).add("creationTime", this.creationTime).add("lastModifiedTime", this.lastModifiedTime).add("expirationTime", this.expirationTime).add("labels", this.labels).add("location", this.location).add("trainingRuns", this.trainingRunList).add("labelColumns", this.labelColumnList).add("featureColumns", this.featureColumnList).add("encryptionConfiguration", this.encryptionConfiguration).toString();
    }

    public int hashCode() {
        return Objects.hash(this.modelId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ModelInfo.class) && Objects.equals(this.toPb(), ((ModelInfo)obj).toPb());
    }

    public static Builder newBuilder(ModelId modelId) {
        return new BuilderImpl().setModelId(modelId);
    }

    public static ModelInfo of(ModelId modelId) {
        return ModelInfo.newBuilder(modelId).build();
    }

    ModelInfo setProjectId(String projectId) {
        if (Strings.isNullOrEmpty(this.getModelId().getProject())) {
            return this.toBuilder().setModelId(this.getModelId().setProjectId(projectId)).build();
        }
        return this;
    }

    Model toPb() {
        Model modelPb = new Model();
        modelPb.setModelReference(this.modelId.toPb());
        modelPb.setEtag(this.etag);
        modelPb.setModelType(this.modelType);
        modelPb.setDescription(this.description);
        modelPb.setFriendlyName(this.friendlyName);
        modelPb.setCreationTime(this.creationTime);
        modelPb.setLastModifiedTime(this.lastModifiedTime);
        modelPb.setExpirationTime(this.expirationTime);
        modelPb.setLabels(this.labels.toPb());
        modelPb.setLocation(this.location);
        modelPb.setTrainingRuns(this.trainingRunList);
        if (this.labelColumnList != null) {
            modelPb.setLabelColumns(Lists.transform(this.labelColumnList, StandardSQLField.TO_PB_FUNCTION));
        }
        if (this.featureColumnList != null) {
            modelPb.setFeatureColumns(Lists.transform(this.featureColumnList, StandardSQLField.TO_PB_FUNCTION));
        }
        if (this.encryptionConfiguration != null) {
            modelPb.setEncryptionConfiguration(this.encryptionConfiguration.toPb());
        }
        return modelPb;
    }

    static ModelInfo fromPb(Model modelPb) {
        return new BuilderImpl(modelPb).build();
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().putAll(this.getModelId().getOtelAttributes()).put("bq.model.type", ModelInfo.getFieldAsString(this.getModelType())).put("bq.model.creation_time", ModelInfo.getFieldAsString(this.getCreationTime())).put("bq.model.last_modified_time", ModelInfo.getFieldAsString(this.getLastModifiedTime())).put("bq.model.expiration_time", ModelInfo.getFieldAsString(this.getExpirationTime())).put("bq.model.location", ModelInfo.getFieldAsString(this.getLocation())).build();
    }

    static class BuilderImpl
    extends Builder {
        private String etag;
        private ModelId modelId;
        private String description;
        private String modelType;
        private String friendlyName;
        private Long creationTime;
        private Long lastModifiedTime;
        private Long expirationTime;
        private Annotations labels = Annotations.ZERO;
        private String location;
        private List<TrainingRun> trainingRunList = Collections.emptyList();
        private List<StandardSQLField> labelColumnList = Collections.emptyList();
        private List<StandardSQLField> featureColumnList = Collections.emptyList();
        private EncryptionConfiguration encryptionConfiguration;

        BuilderImpl() {
        }

        BuilderImpl(ModelInfo modelInfo) {
            this.etag = modelInfo.etag;
            this.modelId = modelInfo.modelId;
            this.description = modelInfo.description;
            this.friendlyName = modelInfo.friendlyName;
            this.modelType = modelInfo.modelType;
            this.creationTime = modelInfo.creationTime;
            this.lastModifiedTime = modelInfo.lastModifiedTime;
            this.expirationTime = modelInfo.expirationTime;
            this.trainingRunList = modelInfo.trainingRunList;
            this.labelColumnList = modelInfo.labelColumnList;
            this.featureColumnList = modelInfo.featureColumnList;
            this.encryptionConfiguration = modelInfo.encryptionConfiguration;
            this.location = modelInfo.location;
        }

        BuilderImpl(Model modelPb) {
            this.modelId = ModelId.fromPb(modelPb.getModelReference());
            if (modelPb.getLastModifiedTime() != null) {
                this.setLastModifiedTime((long)modelPb.getLastModifiedTime());
            }
            this.etag = modelPb.getEtag();
            this.description = modelPb.getDescription();
            this.friendlyName = modelPb.getFriendlyName();
            this.modelType = modelPb.getModelType();
            this.creationTime = modelPb.getCreationTime();
            this.lastModifiedTime = modelPb.getLastModifiedTime();
            this.expirationTime = modelPb.getExpirationTime();
            this.labels = Annotations.fromPb(modelPb.getLabels());
            this.location = modelPb.getLocation();
            if (modelPb.getTrainingRuns() != null) {
                this.trainingRunList = modelPb.getTrainingRuns();
            }
            if (modelPb.getLabelColumns() != null) {
                this.labelColumnList = Lists.transform(modelPb.getLabelColumns(), StandardSQLField.FROM_PB_FUNCTION);
            }
            if (modelPb.getFeatureColumns() != null) {
                this.featureColumnList = Lists.transform(modelPb.getFeatureColumns(), StandardSQLField.FROM_PB_FUNCTION);
            }
            if (modelPb.getEncryptionConfiguration() != null) {
                this.encryptionConfiguration = new EncryptionConfiguration.Builder(modelPb.getEncryptionConfiguration()).build();
            }
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @Override
        Builder setModelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public Builder setExpirationTime(Long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Override
        public Builder setModelId(ModelId modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Annotations.fromUser(labels);
            return this;
        }

        @Override
        Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        Builder setTrainingRuns(List<TrainingRun> trainingRunList) {
            this.trainingRunList = Preconditions.checkNotNull(trainingRunList);
            return this;
        }

        @Override
        Builder setLabelColumns(List<StandardSQLField> labelColumnList) {
            this.labelColumnList = Preconditions.checkNotNull(labelColumnList);
            return this;
        }

        @Override
        Builder setFeatureColumns(List<StandardSQLField> featureColumnList) {
            this.featureColumnList = Preconditions.checkNotNull(featureColumnList);
            return this;
        }

        @Override
        public Builder setEncryptionConfiguration(EncryptionConfiguration configuration) {
            this.encryptionConfiguration = configuration;
            return this;
        }

        @Override
        public ModelInfo build() {
            return new ModelInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setDescription(String var1);

        public abstract Builder setFriendlyName(String var1);

        public abstract Builder setExpirationTime(Long var1);

        public abstract Builder setLabels(Map<String, String> var1);

        abstract Builder setLocation(String var1);

        public abstract Builder setModelId(ModelId var1);

        abstract Builder setEtag(String var1);

        abstract Builder setModelType(String var1);

        abstract Builder setCreationTime(Long var1);

        abstract Builder setLastModifiedTime(Long var1);

        abstract Builder setTrainingRuns(List<TrainingRun> var1);

        abstract Builder setLabelColumns(List<StandardSQLField> var1);

        abstract Builder setFeatureColumns(List<StandardSQLField> var1);

        public abstract Builder setEncryptionConfiguration(EncryptionConfiguration var1);

        public abstract ModelInfo build();
    }
}

