/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ToProtoConverter;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.primitives.Doubles;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.primitives.Ints;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.primitives.Longs;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.Descriptors;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.DynamicMessage;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.cloud.spark.bigquery.repackaged.org.json.JSONArray;
import com.google.cloud.spark.bigquery.repackaged.org.json.JSONException;
import com.google.cloud.spark.bigquery.repackaged.org.json.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JsonToProtoMessage
implements ToProtoConverter<Object> {
    public static final JsonToProtoMessage INSTANCE = new JsonToProtoMessage();
    private static final int NUMERIC_SCALE = 9;
    private static final ImmutableMap<Descriptors.FieldDescriptor.Type, String> FIELD_TYPE_TO_DEBUG_MESSAGE = new ImmutableMap.Builder<Descriptors.FieldDescriptor.Type, String>().put(Descriptors.FieldDescriptor.Type.BOOL, "boolean").put(Descriptors.FieldDescriptor.Type.BYTES, "bytes").put(Descriptors.FieldDescriptor.Type.INT32, "int32").put(Descriptors.FieldDescriptor.Type.DOUBLE, "double").put(Descriptors.FieldDescriptor.Type.INT64, "int64").put(Descriptors.FieldDescriptor.Type.STRING, "string").put(Descriptors.FieldDescriptor.Type.MESSAGE, "object").build();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ofPattern("yyyy[/][-]MM[/][-]dd")).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 3, 6, true).optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 9, true).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalStart().appendZoneText(TextStyle.SHORT).optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().optionalStart().parseCaseInsensitive().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json, boolean ignoreUnknownFields) {
        return INSTANCE.convertToProtoMessage(protoSchema, tableSchema, json, ignoreUnknownFields);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) {
        return INSTANCE.convertToProtoMessage(protoSchema, json);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json) {
        return INSTANCE.convertToProtoMessage(protoSchema, tableSchema, json);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, Object json, boolean ignoreUnknownFields) {
        return this.convertToProtoMessage(protoSchema, tableSchema, (JSONObject)json, ignoreUnknownFields);
    }

    @Override
    public List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, Iterable<Object> jsonArray, boolean ignoreUnknownFields) {
        return this.convertToProtoMessage(protoSchema, tableSchema, (JSONArray)jsonArray, ignoreUnknownFields);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull(json, "JSONObject is null.");
        Preconditions.checkNotNull(protoSchema, "Protobuf descriptor is null.");
        Preconditions.checkState(json.length() != 0, "JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, null, json, "root", false);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull(json, "JSONObject is null.");
        Preconditions.checkNotNull(protoSchema, "Protobuf descriptor is null.");
        Preconditions.checkNotNull(tableSchema, "TableSchema is null.");
        Preconditions.checkState(json.length() != 0, "JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, tableSchema.getFieldsList(), json, "root", false);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull(json, "JSONObject is null.");
        Preconditions.checkNotNull(protoSchema, "Protobuf descriptor is null.");
        Preconditions.checkNotNull(tableSchema, "TableSchema is null.");
        Preconditions.checkState(json.length() != 0, "JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, tableSchema.getFieldsList(), json, "root", ignoreUnknownFields);
    }

    public List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONArray jsonArray, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull(jsonArray, "jsonArray is null.");
        Preconditions.checkNotNull(protoSchema, "Protobuf descriptor is null.");
        Preconditions.checkNotNull(tableSchema, "tableSchema is null.");
        Preconditions.checkState(jsonArray.length() != 0, "jsonArray is empty.");
        return this.convertToProtoMessage(protoSchema, tableSchema.getFieldsList(), jsonArray, "root", ignoreUnknownFields);
    }

    private DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableSchema, JSONObject jsonObject, String jsonScope, boolean ignoreUnknownFields) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put(jsonObject);
        return this.convertToProtoMessage(protoSchema, tableSchema, jsonArray, jsonScope, ignoreUnknownFields).get(0);
    }

    private List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableSchema, JSONArray jsonArray, String jsonScope, boolean ignoreUnknownFields) throws Exceptions.RowIndexToErrorException {
        ArrayList<DynamicMessage> messageList = new ArrayList<DynamicMessage>();
        HashMap<String, FieldDescriptorAndFieldTableSchema> jsonNameToMetadata = new HashMap<String, FieldDescriptorAndFieldTableSchema>();
        HashMap<Integer, String> rowIndexToErrorMessage = new HashMap<Integer, String>();
        boolean hasDataUnknownError = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                DynamicMessage msg;
                DynamicMessage.Builder protoMsg = DynamicMessage.newBuilder(protoSchema);
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String[] jsonNames = JSONObject.getNames(jsonObject);
                if (jsonNames == null) {
                    messageList.add(protoMsg.build());
                    continue;
                }
                for (String jsonName : jsonNames) {
                    String currentScope = jsonScope + "." + jsonName;
                    FieldDescriptorAndFieldTableSchema fieldDescriptorAndFieldTableSchema = jsonNameToMetadata.computeIfAbsent(currentScope, k -> this.computeDescriptorAndSchema(currentScope, ignoreUnknownFields, jsonName, protoSchema, tableSchema));
                    if (fieldDescriptorAndFieldTableSchema == null) continue;
                    Descriptors.FieldDescriptor field = fieldDescriptorAndFieldTableSchema.fieldDescriptor;
                    TableFieldSchema tableFieldSchema = fieldDescriptorAndFieldTableSchema.tableFieldSchema;
                    try {
                        if (!field.isRepeated()) {
                            this.fillField(protoMsg, field, tableFieldSchema, jsonObject, jsonName, currentScope, ignoreUnknownFields);
                            continue;
                        }
                        this.fillRepeatedField(protoMsg, field, tableFieldSchema, jsonObject, jsonName, currentScope, ignoreUnknownFields);
                    }
                    catch (Exceptions.FieldParseError ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new Exceptions.FieldParseError(currentScope, tableFieldSchema != null ? tableFieldSchema.getType().name() : field.getType().name(), ex);
                    }
                }
                try {
                    msg = protoMsg.build();
                }
                catch (UninitializedMessageException e) {
                    String errorMsg = e.getMessage();
                    int idxOfColon = errorMsg.indexOf(":");
                    String missingFieldName = errorMsg.substring(idxOfColon + 2);
                    throw new IllegalArgumentException(String.format("JSONObject does not have the required field %s.%s.", jsonScope, missingFieldName));
                }
                messageList.add(msg);
                continue;
            }
            catch (IllegalArgumentException exception) {
                if (exception instanceof Exceptions.DataHasUnknownFieldException) {
                    hasDataUnknownError = true;
                }
                if (exception instanceof Exceptions.FieldParseError) {
                    Exceptions.FieldParseError ex = (Exceptions.FieldParseError)exception;
                    rowIndexToErrorMessage.put(i, "Field " + ex.getFieldName() + " failed to convert to " + ex.getBqType() + ". Error: " + ex.getCause().getMessage());
                    continue;
                }
                rowIndexToErrorMessage.put(i, exception.getMessage());
            }
        }
        if (!rowIndexToErrorMessage.isEmpty()) {
            throw new Exceptions.RowIndexToErrorException(rowIndexToErrorMessage, hasDataUnknownError);
        }
        return messageList;
    }

    private FieldDescriptorAndFieldTableSchema computeDescriptorAndSchema(String currentScope, boolean ignoreUnknownFields, String jsonName, Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableFieldSchemaList) {
        Descriptors.FieldDescriptor field;
        String jsonFieldLocator = jsonName.toLowerCase();
        if (!BigQuerySchemaUtil.isProtoCompatible(jsonFieldLocator)) {
            jsonFieldLocator = BigQuerySchemaUtil.generatePlaceholderFieldName(jsonFieldLocator);
        }
        if ((field = protoSchema.findFieldByName(jsonFieldLocator)) == null && !ignoreUnknownFields) {
            throw new Exceptions.DataHasUnknownFieldException(currentScope);
        }
        if (field == null) {
            return null;
        }
        TableFieldSchema fieldSchema = null;
        if (tableFieldSchemaList != null) {
            fieldSchema = tableFieldSchemaList.get(field.getIndex());
            if (fieldSchema.getType() == TableFieldSchema.Type.RANGE) {
                switch (fieldSchema.getRangeElementType().getType()) {
                    case DATE: 
                    case DATETIME: 
                    case TIMESTAMP: {
                        fieldSchema = fieldSchema.toBuilder().addFields(TableFieldSchema.newBuilder().setName("start").setType(fieldSchema.getRangeElementType().getType()).build()).addFields(TableFieldSchema.newBuilder().setName("end").setType(fieldSchema.getRangeElementType().getType()).build()).build();
                        break;
                    }
                    default: {
                        throw new ValidationException("Field at index " + field.getIndex() + " with name (" + fieldSchema.getName() + ") with type (RANGE) has an unsupported range element type (" + fieldSchema.getRangeElementType() + ")", new Object[0]);
                    }
                }
            }
            if (!fieldSchema.getName().toLowerCase().equals(BigQuerySchemaUtil.getFieldName(field))) {
                throw new ValidationException("Field at index " + field.getIndex() + " has mismatch names (" + fieldSchema.getName() + ") (" + field.getName() + ")", new Object[0]);
            }
        }
        FieldDescriptorAndFieldTableSchema fieldDescriptorAndFieldTableSchema = new FieldDescriptorAndFieldTableSchema();
        fieldDescriptorAndFieldTableSchema.fieldDescriptor = field;
        fieldDescriptorAndFieldTableSchema.tableFieldSchema = fieldSchema;
        return fieldDescriptorAndFieldTableSchema;
    }

    private void fillField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Object val = json.get(exactJsonKeyName);
        if (val == JSONObject.NULL) {
            return;
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (val instanceof Boolean) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof String) || !"true".equalsIgnoreCase((String)val) && !"false".equalsIgnoreCase((String)val)) break;
                protoMsg.setField(fieldDescriptor, Boolean.parseBoolean((String)val));
                return;
            }
            case BYTES: {
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(9, RoundingMode.HALF_UP);
                            }
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            return;
                        }
                    }
                }
                if (val instanceof ByteString) {
                    protoMsg.setField(fieldDescriptor, ((ByteString)val).toByteArray());
                    return;
                }
                if (!(val instanceof JSONArray)) break;
                byte[] bytes = new byte[((JSONArray)val).length()];
                for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                    bytes[j] = (byte)((JSONArray)val).getInt(j);
                    if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                    throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + j + "] could not be converted to byte[].", new Object[0]));
                }
                protoMsg.setField(fieldDescriptor, bytes);
                return;
            }
            case INT64: {
                Long parsed;
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime(LocalDateTime.parse((String)val, DATETIME_FORMATTER)));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, val);
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, CivilTimeEncoder.encodePacked64TimeMicrosLocalTime(LocalTime.parse((String)val)));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, val);
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        if (val instanceof String) {
                            Double parsed2 = Doubles.tryParse((String)val);
                            if (parsed2 != null) {
                                protoMsg.setField(fieldDescriptor, parsed2.longValue());
                                return;
                            }
                            TemporalAccessor parsedTime = TIMESTAMP_FORMATTER.parse((String)val);
                            protoMsg.setField(fieldDescriptor, parsedTime.getLong(ChronoField.INSTANT_SECONDS) * 1000000L + parsedTime.getLong(ChronoField.MICRO_OF_SECOND));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, val);
                            return;
                        }
                        if (val instanceof Integer) {
                            protoMsg.setField(fieldDescriptor, (Integer)val);
                            return;
                        }
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, (Integer)val);
                    return;
                }
                if (val instanceof Long) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (val instanceof Byte) {
                    protoMsg.setField(fieldDescriptor, (Byte)val);
                    return;
                }
                if (val instanceof Short) {
                    protoMsg.setField(fieldDescriptor, (Short)val);
                    return;
                }
                if (!(val instanceof String) || (parsed = Longs.tryParse((String)val)) == null) break;
                protoMsg.setField(fieldDescriptor, parsed);
                return;
            }
            case INT32: {
                Integer parsed;
                if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                    if (val instanceof String) {
                        protoMsg.setField(fieldDescriptor, (int)LocalDate.parse((String)val).toEpochDay());
                        return;
                    }
                    if (val instanceof Integer || val instanceof Long) {
                        protoMsg.setField(fieldDescriptor, ((Number)val).intValue());
                        return;
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof String) || (parsed = Ints.tryParse((String)val)) == null) break;
                protoMsg.setField(fieldDescriptor, parsed);
                return;
            }
            case STRING: {
                if (val instanceof String) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof Short) && !(val instanceof Integer) && !(val instanceof Long) && !(val instanceof Boolean)) break;
                protoMsg.setField(fieldDescriptor, String.valueOf(val));
                return;
            }
            case DOUBLE: {
                Double parsed;
                if (val instanceof Number) {
                    protoMsg.setField(fieldDescriptor, ((Number)val).doubleValue());
                    return;
                }
                if (!(val instanceof String) || (parsed = Doubles.tryParse((String)val)) == null) break;
                protoMsg.setField(fieldDescriptor, parsed);
                return;
            }
            case MESSAGE: {
                if (!(val instanceof JSONObject)) break;
                protoMsg.setField(fieldDescriptor, this.convertToProtoMessage(fieldDescriptor.getMessageType(), fieldSchema == null ? null : fieldSchema.getFieldsList(), json.getJSONObject(exactJsonKeyName), currentScope, ignoreUnknownFields));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s.", FIELD_TYPE_TO_DEBUG_MESSAGE.get((Object)fieldDescriptor.getType()), currentScope));
    }

    private void fillRepeatedField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        JSONArray jsonArray;
        try {
            jsonArray = json.getJSONArray(exactJsonKeyName);
        }
        catch (JSONException e) {
            Object val = json.get(exactJsonKeyName);
            if (val == JSONObject.NULL) {
                return;
            }
            throw new IllegalArgumentException("JSONObject does not have a array field at " + currentScope + ".");
        }
        block13: for (int i = 0; i < jsonArray.length(); ++i) {
            Object val = jsonArray.get(i);
            int index = i;
            switch (fieldDescriptor.getType()) {
                case BOOL: {
                    if (val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof String && ("true".equalsIgnoreCase((String)val) || "false".equalsIgnoreCase((String)val))) {
                        protoMsg.addRepeatedField(fieldDescriptor, Boolean.parseBoolean((String)val));
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case BYTES: {
                    boolean added = false;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(9, RoundingMode.HALF_UP);
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    } else if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    }
                    if (added) continue block13;
                    if (val instanceof ByteString) {
                        protoMsg.addRepeatedField(fieldDescriptor, ((ByteString)val).toByteArray());
                        continue block13;
                    }
                    if (val instanceof byte[]) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof JSONArray) {
                        try {
                            byte[] bytes = new byte[((JSONArray)val).length()];
                            for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                                bytes[j] = (byte)((JSONArray)val).getInt(j);
                                if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                                throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, bytes);
                            continue block13;
                        }
                        catch (JSONException e) {
                            throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                        }
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case INT64: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime(LocalDateTime.parse((String)val, DATETIME_FORMATTER)));
                            continue block13;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, val);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, CivilTimeEncoder.encodePacked64TimeMicrosLocalTime(LocalTime.parse((String)val)));
                            continue block13;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, val);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        if (val instanceof String) {
                            parsed = Doubles.tryParse((String)val);
                            if (parsed != null) {
                                protoMsg.addRepeatedField(fieldDescriptor, ((Double)parsed).longValue());
                                continue block13;
                            }
                            TemporalAccessor parsedTime = TIMESTAMP_FORMATTER.parse((String)val);
                            protoMsg.addRepeatedField(fieldDescriptor, parsedTime.getLong(ChronoField.INSTANT_SECONDS) * 1000000L + parsedTime.getLong(ChronoField.MICRO_OF_SECOND));
                            continue block13;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, val);
                            continue block13;
                        }
                        if (val instanceof Integer) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Integer)val);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Integer)val);
                        continue block13;
                    }
                    if (val instanceof Long) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof Byte) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Byte)val);
                        continue block13;
                    }
                    if (val instanceof Short) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Short)val);
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Longs.tryParse((String)val);
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case INT32: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (int)LocalDate.parse((String)val).toEpochDay());
                            continue block13;
                        }
                        if (val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, ((Number)val).intValue());
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Ints.tryParse((String)val);
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case STRING: {
                    if (val instanceof String) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, String.valueOf(val));
                        return;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case DOUBLE: {
                    Number parsed;
                    if (val instanceof Number) {
                        protoMsg.addRepeatedField(fieldDescriptor, ((Number)val).doubleValue());
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Doubles.tryParse((String)val);
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case MESSAGE: {
                    if (val instanceof JSONObject) {
                        protoMsg.addRepeatedField(fieldDescriptor, this.convertToProtoMessage(fieldDescriptor.getMessageType(), fieldSchema == null ? null : fieldSchema.getFieldsList(), jsonArray.getJSONObject(i), currentScope, ignoreUnknownFields));
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                }
            }
        }
    }

    private static void throwWrongFieldType(Descriptors.FieldDescriptor fieldDescriptor, String currentScope, int index) {
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s[%d].", FIELD_TYPE_TO_DEBUG_MESSAGE.get((Object)fieldDescriptor.getType()), currentScope, index));
    }

    private static final class FieldDescriptorAndFieldTableSchema {
        TableFieldSchema tableFieldSchema;
        Descriptors.FieldDescriptor fieldDescriptor;

        private FieldDescriptorAndFieldTableSchema() {
        }
    }
}

