/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.opencensus.contrib.http;

import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.contrib.http.AbstractHttpHandler;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.contrib.http.HttpExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.contrib.http.HttpRequestContext;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.contrib.http.util.HttpMeasureConstants;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.stats.Stats;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.tags.TagContext;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.tags.TagValue;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.tags.Tagger;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.tags.Tags;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.Link;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.Span;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.SpanBuilder;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.SpanContext;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.Tracer;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.propagation.SpanContextParseException;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.trace.propagation.TextFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class HttpServerHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Getter<C> getter;
    private final TextFormat textFormat;
    private final Tracer tracer;
    private final Boolean publicEndpoint;
    private final StatsRecorder statsRecorder;
    private final Tagger tagger;

    public HttpServerHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Getter<C> getter, Boolean publicEndpoint) {
        super(extractor);
        Preconditions.checkNotNull(tracer, "tracer");
        Preconditions.checkNotNull(textFormat, "textFormat");
        Preconditions.checkNotNull(getter, "getter");
        Preconditions.checkNotNull(publicEndpoint, "publicEndpoint");
        this.tracer = tracer;
        this.textFormat = textFormat;
        this.getter = getter;
        this.publicEndpoint = publicEndpoint;
        this.statsRecorder = Stats.getStatsRecorder();
        this.tagger = Tags.getTagger();
    }

    public HttpRequestContext handleStart(C carrier, Q request) {
        Preconditions.checkNotNull(carrier, "carrier");
        Preconditions.checkNotNull(request, "request");
        SpanBuilder spanBuilder = null;
        String spanName = this.getSpanName(request, this.extractor);
        SpanContext spanContext = null;
        try {
            spanContext = this.textFormat.extract(carrier, this.getter);
        }
        catch (SpanContextParseException spanContextParseException) {
            // empty catch block
        }
        spanBuilder = spanContext == null || this.publicEndpoint != false ? this.tracer.spanBuilder(spanName) : this.tracer.spanBuilderWithRemoteParent(spanName, spanContext);
        Span span = spanBuilder.setSpanKind(Span.Kind.SERVER).startSpan();
        if (this.publicEndpoint.booleanValue() && spanContext != null) {
            span.addLink(Link.fromSpanContext(spanContext, Link.Type.PARENT_LINKED_SPAN));
        }
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            this.addSpanRequestAttributes(span, request, this.extractor);
        }
        return this.getNewContext(span, this.tagger.getCurrentTagContext());
    }

    public void handleEnd(HttpRequestContext context, Q request, @Nullable P response, @Nullable Throwable error) {
        Preconditions.checkNotNull(context, "context");
        Preconditions.checkNotNull(request, "request");
        int httpCode = this.extractor.getStatusCode(response);
        this.recordStats(context, request, httpCode);
        this.spanEnd(context.span, httpCode, error);
    }

    private void recordStats(HttpRequestContext context, Q request, int httpCode) {
        double requestLatency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.requestStartTime);
        String methodStr = this.extractor.getMethod(request);
        String routeStr = this.extractor.getRoute(request);
        TagContext startCtx = this.tagger.toBuilder(context.tagContext).put(HttpMeasureConstants.HTTP_SERVER_METHOD, TagValue.create(methodStr == null ? "" : methodStr), HttpRequestContext.METADATA_NO_PROPAGATION).put(HttpMeasureConstants.HTTP_SERVER_ROUTE, TagValue.create(routeStr == null ? "" : routeStr), HttpRequestContext.METADATA_NO_PROPAGATION).put(HttpMeasureConstants.HTTP_SERVER_STATUS, TagValue.create(httpCode == 0 ? "error" : Integer.toString(httpCode)), HttpRequestContext.METADATA_NO_PROPAGATION).build();
        this.statsRecorder.newMeasureMap().put(HttpMeasureConstants.HTTP_SERVER_LATENCY, requestLatency).put(HttpMeasureConstants.HTTP_SERVER_RECEIVED_BYTES, context.receiveMessageSize.get()).put(HttpMeasureConstants.HTTP_SERVER_SENT_BYTES, context.sentMessageSize.get()).record(startCtx);
    }
}

