/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc;

import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class JdbcLocation {
    @NonNull
    private String scheme;
    private Optional<String> authority;
    private Optional<String> instance;
    private Optional<String> database;

    public String toNamespace() {
        String result = this.scheme.toLowerCase(Locale.ROOT) + ":";
        if (this.authority.isPresent()) {
            result = String.format("%s//%s", result, this.authority.get().toLowerCase(Locale.ROOT));
        }
        if (this.instance.isPresent()) {
            result = String.format("%s/%s", result, StringUtils.stripStart(this.instance.get(), "/"));
        }
        return result;
    }

    public String toName(List<String> parts) {
        if (this.database.isPresent()) {
            parts.add(0, this.database.get());
        }
        return String.join((CharSequence)".", parts);
    }

    @Generated
    public JdbcLocation(@NonNull String scheme, Optional<String> authority, Optional<String> instance, Optional<String> database) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
        this.authority = authority;
        this.instance = instance;
        this.database = database;
    }

    @NonNull
    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public void setScheme(@NonNull String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
    }

    @Generated
    public Optional<String> getAuthority() {
        return this.authority;
    }

    @Generated
    public void setAuthority(Optional<String> authority) {
        this.authority = authority;
    }

    @Generated
    public Optional<String> getInstance() {
        return this.instance;
    }

    @Generated
    public void setInstance(Optional<String> instance) {
        this.instance = instance;
    }

    @Generated
    public Optional<String> getDatabase() {
        return this.database;
    }

    @Generated
    public void setDatabase(Optional<String> database) {
        this.database = database;
    }
}

