/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.ser;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.SerializableString;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.PropertyName;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.ser.SerializerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final SerializableString _fastName;
    protected final BeanPropertyWriter fallbackWriter;
    protected boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter src, JsonSerializer<Object> ser) {
        super(src);
        this.fallbackWriter = this.unwrapFallbackWriter(src);
        this._serializer = ser != null ? ser : src.getSerializer();
        this._fastName = src.getSerializedName();
    }

    protected OptimizedBeanPropertyWriter(OptimizedBeanPropertyWriter<?> base, PropertyName name) {
        super(base, name);
        this.fallbackWriter = base.fallbackWriter;
        this._serializer = base._serializer;
        this._fastName = this.getSerializedName();
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter srcIn) {
        while (srcIn instanceof OptimizedBeanPropertyWriter) {
            srcIn = ((OptimizedBeanPropertyWriter)srcIn).fallbackWriter;
        }
        return srcIn;
    }

    @Override
    protected abstract BeanPropertyWriter _new(PropertyName var1);

    @Override
    public void assignTypeSerializer(TypeSerializer typeSer) {
        super.assignTypeSerializer(typeSer);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignTypeSerializer(typeSer);
        }
    }

    @Override
    public void assignSerializer(JsonSerializer<Object> ser) {
        super.assignSerializer(ser);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignSerializer(ser);
        }
        if (!SerializerUtil.isDefaultSerializer(ser)) {
            this.broken = true;
        }
    }

    @Override
    public void assignNullSerializer(JsonSerializer<Object> nullSer) {
        super.assignNullSerializer(nullSer);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignNullSerializer(nullSer);
        }
    }

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    @Override
    public abstract void serializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    @Override
    public abstract void serializeAsElement(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    protected synchronized void _handleProblem(Object bean, JsonGenerator gen, SerializerProvider prov, Throwable t2, boolean element) throws Exception {
        if (t2 instanceof IllegalAccessError || t2 instanceof SecurityException) {
            this._reportProblem(bean, t2);
            if (element) {
                this.fallbackWriter.serializeAsElement(bean, gen, prov);
            } else {
                this.fallbackWriter.serializeAsField(bean, gen, prov);
            }
            return;
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        throw (Exception)t2;
    }

    protected void _reportProblem(Object bean, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Blackbird serialization for %s (field %s; mutator %s), due to access error (type %s, message=%s)%n", bean.getClass(), this._name, this.getClass().getName(), e.getClass().getName(), e.getMessage());
        Logger.getLogger(OptimizedBeanPropertyWriter.class.getName()).log(Level.WARNING, msg, e);
    }
}

