/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono;

import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.AbstractNileDate;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.EthiopicChronology;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.EthiopicEra;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;

public final class EthiopicDate
extends AbstractNileDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -268768729L;
    private static final int EPOCH_DAY_DIFFERENCE = 716367;
    private final int prolepticYear;
    private final short month;
    private final short day;

    public static EthiopicDate now() {
        return EthiopicDate.now(Clock.systemDefaultZone());
    }

    public static EthiopicDate now(ZoneId zone) {
        return EthiopicDate.now(Clock.system(zone));
    }

    public static EthiopicDate now(Clock clock) {
        LocalDate now = LocalDate.now(clock);
        return EthiopicDate.ofEpochDay(now.toEpochDay());
    }

    public static EthiopicDate of(int prolepticYear, int month, int dayOfMonth) {
        return EthiopicDate.create(prolepticYear, month, dayOfMonth);
    }

    public static EthiopicDate from(TemporalAccessor temporal) {
        if (temporal instanceof EthiopicDate) {
            return (EthiopicDate)temporal;
        }
        return EthiopicDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    static EthiopicDate ofYearDay(int prolepticYear, int dayOfYear) {
        EthiopicChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        ChronoField.DAY_OF_YEAR.range().checkValidValue(dayOfYear, ChronoField.DAY_OF_YEAR);
        if (dayOfYear == 366 && !EthiopicChronology.INSTANCE.isLeapYear(prolepticYear)) {
            throw new DateTimeException("Invalid date 'Pagumen 6' as '" + prolepticYear + "' is not a leap year");
        }
        return new EthiopicDate(prolepticYear, (dayOfYear - 1) / 30 + 1, (dayOfYear - 1) % 30 + 1);
    }

    static EthiopicDate ofEpochDay(long epochDay) {
        ChronoField.EPOCH_DAY.range().checkValidValue(epochDay, ChronoField.EPOCH_DAY);
        long ethiopicED = epochDay + 716367L;
        int adjustment = 0;
        if (ethiopicED < 0L) {
            ethiopicED += 365250000L;
            adjustment = -1000000;
        }
        int prolepticYear = (int)((ethiopicED * 4L + 1463L) / 1461L);
        int startYearEpochDay = (prolepticYear - 1) * 365 + prolepticYear / 4;
        int doy0 = (int)(ethiopicED - (long)startYearEpochDay);
        int month = doy0 / 30 + 1;
        int dom = doy0 % 30 + 1;
        return new EthiopicDate(prolepticYear + adjustment, month, dom);
    }

    private static EthiopicDate resolvePreviousValid(int prolepticYear, int month, int day) {
        if (month == 13 && day > 5) {
            day = EthiopicChronology.INSTANCE.isLeapYear(prolepticYear) ? 6 : 5;
        }
        return new EthiopicDate(prolepticYear, month, day);
    }

    static EthiopicDate create(int prolepticYear, int month, int dayOfMonth) {
        EthiopicChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        EthiopicChronology.MOY_RANGE.checkValidValue(month, ChronoField.MONTH_OF_YEAR);
        EthiopicChronology.DOM_RANGE.checkValidValue(dayOfMonth, ChronoField.DAY_OF_MONTH);
        if (month == 13 && dayOfMonth > 5) {
            if (EthiopicChronology.INSTANCE.isLeapYear(prolepticYear)) {
                if (dayOfMonth > 6) {
                    throw new DateTimeException("Invalid date 'Pagumen " + dayOfMonth + "', valid range from 1 to 5, or 1 to 6 in a leap year");
                }
            } else {
                if (dayOfMonth == 6) {
                    throw new DateTimeException("Invalid date 'Pagumen 6' as '" + prolepticYear + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date 'Pagumen " + dayOfMonth + "', valid range from 1 to 5, or 1 to 6 in a leap year");
            }
        }
        return new EthiopicDate(prolepticYear, month, dayOfMonth);
    }

    private EthiopicDate(int prolepticYear, int month, int dayOfMonth) {
        this.prolepticYear = prolepticYear;
        this.month = (short)month;
        this.day = (short)dayOfMonth;
    }

    private Object readResolve() {
        return EthiopicDate.create(this.prolepticYear, this.month, this.day);
    }

    @Override
    int getEpochDayDifference() {
        return 716367;
    }

    @Override
    int getProlepticYear() {
        return this.prolepticYear;
    }

    @Override
    int getMonth() {
        return this.month;
    }

    @Override
    int getDayOfMonth() {
        return this.day;
    }

    @Override
    EthiopicDate resolvePrevious(int newYear, int newMonth, int dayOfMonth) {
        return EthiopicDate.resolvePreviousValid(newYear, newMonth, dayOfMonth);
    }

    @Override
    public EthiopicChronology getChronology() {
        return EthiopicChronology.INSTANCE;
    }

    @Override
    public EthiopicEra getEra() {
        return this.prolepticYear >= 1 ? EthiopicEra.INCARNATION : EthiopicEra.BEFORE_INCARNATION;
    }

    @Override
    public EthiopicDate with(TemporalAdjuster adjuster) {
        return (EthiopicDate)adjuster.adjustInto(this);
    }

    @Override
    public EthiopicDate with(TemporalField field, long newValue) {
        return (EthiopicDate)super.with(field, newValue);
    }

    @Override
    public EthiopicDate plus(TemporalAmount amount) {
        return (EthiopicDate)amount.addTo(this);
    }

    @Override
    public EthiopicDate plus(long amountToAdd, TemporalUnit unit) {
        return (EthiopicDate)super.plus(amountToAdd, unit);
    }

    @Override
    public EthiopicDate minus(TemporalAmount amount) {
        return (EthiopicDate)amount.subtractFrom(this);
    }

    @Override
    public EthiopicDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<EthiopicDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return super.until(EthiopicDate.from(endExclusive), unit);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        return super.doUntil(EthiopicDate.from(endDateExclusive));
    }
}

