/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.customMetrics;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.util.Utils;

class MetricUtils {
    private static final String METRIC_FORMAT = "total (min, med, max)\n%s (%s, %s, %s)";
    private static final NumberFormat NUMBER_FORMAT_US = NumberFormat.getIntegerInstance(Locale.US);

    MetricUtils() {
    }

    static String formatTimeMetrics(long[] taskMetrics) {
        if (taskMetrics.length == 0) {
            return Utils.msDurationToString((long)0L);
        }
        if (taskMetrics.length == 1) {
            return Utils.msDurationToString((long)taskMetrics[0]);
        }
        Arrays.sort(taskMetrics);
        String sum = Utils.msDurationToString((long)Arrays.stream(taskMetrics).sum());
        String min2 = Utils.msDurationToString((long)taskMetrics[0]);
        String med = Utils.msDurationToString((long)taskMetrics[taskMetrics.length / 2]);
        String max = Utils.msDurationToString((long)taskMetrics[taskMetrics.length - 1]);
        return String.format(METRIC_FORMAT, sum, min2, med, max);
    }

    static String formatSizeMetrics(long[] taskMetrics) {
        return Utils.bytesToString((long)Arrays.stream(taskMetrics).sum());
    }

    static String formatSumMetrics(long[] taskMetrics) {
        return NUMBER_FORMAT_US.format(Arrays.stream(taskMetrics).sum());
    }
}

