/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.ArrowReaderIterator;
import com.google.cloud.bigquery.connector.common.ArrowUtil;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.spark.bigquery.ArrowSchemaConverter;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ArrowBinaryIterator
implements Iterator<InternalRow> {
    private static long maxAllocation = Long.MAX_VALUE;
    private final Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer;
    ArrowReaderIterator arrowReaderIterator;
    Iterator<InternalRow> currentIterator;
    List<String> columnsInOrder;
    Map<String, StructField> userProvidedFieldMap;

    public ArrowBinaryIterator(List<String> columnsInOrder, ByteString schema, ByteString rowsInBytes, Optional<StructType> userProvidedSchema, Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer) {
        BufferAllocator allocator = ArrowUtil.newRootAllocator((long)maxAllocation).newChildAllocator("ArrowBinaryIterator", 0L, maxAllocation);
        SequenceInputStream bytesWithSchemaStream = new SequenceInputStream(new ByteArrayInputStream(schema.toByteArray()), new ByteArrayInputStream(rowsInBytes.toByteArray()));
        ArrowStreamReader arrowStreamReader = new ArrowStreamReader((InputStream)bytesWithSchemaStream, allocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
        this.arrowReaderIterator = new ArrowReaderIterator((ArrowReader)arrowStreamReader);
        this.currentIterator = ImmutableList.of().iterator();
        this.columnsInOrder = columnsInOrder;
        List userProvidedFieldList = Arrays.stream(userProvidedSchema.orElse(new StructType()).fields()).collect(Collectors.toList());
        this.userProvidedFieldMap = userProvidedFieldList.stream().collect(Collectors.toMap(StructField::name, Function.identity()));
        this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
    }

    @Override
    public boolean hasNext() {
        while (!this.currentIterator.hasNext()) {
            if (!this.arrowReaderIterator.hasNext()) {
                return false;
            }
            this.currentIterator = this.toArrowRows(this.arrowReaderIterator.next(), this.columnsInOrder);
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public InternalRow next() {
        return this.currentIterator.next();
    }

    private Iterator<InternalRow> toArrowRows(VectorSchemaRoot root, List<String> namesInOrder) {
        ColumnVector[] columns = namesInOrder.stream().map(name -> root.getVector(name)).map(vector -> ArrowSchemaConverter.newArrowSchemaConverter((ValueVector)vector, this.userProvidedFieldMap.get(vector.getName()))).collect(Collectors.toList()).toArray(new ColumnVector[0]);
        ColumnarBatch batch = new ColumnarBatch(columns);
        batch.setNumRows(root.getRowCount());
        this.bigQueryStorageReadRowsTracer.ifPresent(tracer -> tracer.rowsParseFinished((long)root.getRowCount()));
        return batch.rowIterator();
    }
}

