/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.apache.hadoop.fs.RemoteIterator;

public class HdfsUtils {
    public static <T> Iterator<T> toJavaUtilIterator(final RemoteIterator<T> remoteIterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return remoteIterator.hasNext();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public T next() {
                try {
                    return remoteIterator.next();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    public static <T> Iterable<T> toJavaUtilIterable(RemoteIterator<T> remoteIterator) {
        return () -> HdfsUtils.toJavaUtilIterator(remoteIterator);
    }
}

