/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryDirectDataWriterHelper;
import com.google.cloud.bigquery.connector.common.WriteStreamStatistics;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.spark.bigquery.ProtobufUtils;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectWriterCommitMessageContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContext;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import com.google.common.base.Optional;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDirectDataWriterContext
implements DataWriterContext<InternalRow> {
    final Logger logger = LoggerFactory.getLogger(BigQueryDirectDataWriterContext.class);
    private final int partitionId;
    private final long taskId;
    private final long epochId;
    private final String tablePath;
    private final StructType sparkSchema;
    private final Descriptors.Descriptor schemaDescriptor;
    private BigQueryDirectDataWriterHelper writerHelper;

    public BigQueryDirectDataWriterContext(int partitionId, long taskId, long epochId, BigQueryClientFactory writeClientFactory, String tablePath, StructType sparkSchema, ProtoSchema protoSchema, RetrySettings bigqueryDataWriterHelperRetrySettings, Optional<String> traceId, boolean writeAtLeastOnce) {
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.epochId = epochId;
        this.tablePath = tablePath;
        this.sparkSchema = sparkSchema;
        try {
            this.schemaDescriptor = ProtobufUtils.toDescriptor(sparkSchema);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new BigQueryConnectorException.InvalidSchemaException("Could not convert spark-schema to descriptor object", (Throwable)e);
        }
        this.writerHelper = new BigQueryDirectDataWriterHelper(writeClientFactory, tablePath, protoSchema, bigqueryDataWriterHelperRetrySettings, traceId, partitionId, writeAtLeastOnce);
    }

    @Override
    public void write(InternalRow record) throws IOException {
        ByteString message = ProtobufUtils.buildSingleRowMessage(this.sparkSchema, this.schemaDescriptor, record).toByteString();
        this.writerHelper.addRow(message);
    }

    @Override
    public WriterCommitMessageContext commit() throws IOException {
        this.logger.debug("Data Writer {} finalizeStream()", (Object)this.partitionId);
        WriteStreamStatistics stats = this.writerHelper.finalizeStream();
        String writeStreamName = this.writerHelper.getWriteStreamName();
        this.logger.debug("Data Writer {}'s write-stream has finalized with row count: {}", (Object)this.partitionId, (Object)stats.getRowCount());
        return new BigQueryDirectWriterCommitMessageContext(writeStreamName, this.partitionId, this.taskId, this.epochId, this.tablePath, stats.getRowCount(), stats.getBytesWritten());
    }

    @Override
    public void abort() throws IOException {
        this.logger.debug("Data Writer {} abort()", (Object)this.partitionId);
        this.writerHelper.abort();
    }

    @Override
    public void close() throws IOException {
    }
}

