/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.ArrowBinaryIterator;
import com.google.cloud.spark.bigquery.AvroBinaryIterator;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public interface ReadRowsResponseToInternalRowIteratorConverter {
    public static ReadRowsResponseToInternalRowIteratorConverter avro(Schema bqSchema, List<String> columnsInOrder, String rawAvroSchema, Optional<StructType> userProvidedSchema, Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer, SchemaConvertersConfiguration schemaConvertersConfiguration, ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec) {
        return new Avro(bqSchema, columnsInOrder, rawAvroSchema, (com.google.common.base.Optional<StructType>)com.google.common.base.Optional.fromJavaUtil(userProvidedSchema), (com.google.common.base.Optional<BigQueryStorageReadRowsTracer>)com.google.common.base.Optional.fromJavaUtil(bigQueryStorageReadRowsTracer), schemaConvertersConfiguration, responseCompressionCodec);
    }

    public static ReadRowsResponseToInternalRowIteratorConverter arrow(List<String> columnsInOrder, ByteString arrowSchema, Optional<StructType> userProvidedSchema, Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer, ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec) {
        return new Arrow(columnsInOrder, arrowSchema, (com.google.common.base.Optional<StructType>)com.google.common.base.Optional.fromJavaUtil(userProvidedSchema), (com.google.common.base.Optional<BigQueryStorageReadRowsTracer>)com.google.common.base.Optional.fromJavaUtil(bigQueryStorageReadRowsTracer), responseCompressionCodec);
    }

    public Iterator<InternalRow> convert(ReadRowsResponse var1);

    public int getBatchSizeInBytes(ReadRowsResponse var1);

    public static class Arrow
    implements ReadRowsResponseToInternalRowIteratorConverter,
    Serializable {
        private final List<String> columnsInOrder;
        private final ByteString arrowSchema;
        private final com.google.common.base.Optional<StructType> userProvidedSchema;
        private final com.google.common.base.Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer;
        private final ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec;

        public Arrow(List<String> columnsInOrder, ByteString arrowSchema, com.google.common.base.Optional<StructType> userProvidedSchema, com.google.common.base.Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer, ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec) {
            this.columnsInOrder = columnsInOrder;
            this.arrowSchema = arrowSchema;
            this.userProvidedSchema = userProvidedSchema;
            this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
            this.responseCompressionCodec = responseCompressionCodec;
        }

        @Override
        public Iterator<InternalRow> convert(ReadRowsResponse response) {
            return new ArrowBinaryIterator(this.columnsInOrder, this.arrowSchema, response, this.userProvidedSchema.toJavaUtil(), this.bigQueryStorageReadRowsTracer.toJavaUtil(), this.responseCompressionCodec);
        }

        @Override
        public int getBatchSizeInBytes(ReadRowsResponse response) {
            if (response.getUncompressedByteSize() > 0L) {
                return (int)response.getUncompressedByteSize();
            }
            return response.getArrowRecordBatch().getSerializedRecordBatch().size();
        }
    }

    public static class Avro
    implements ReadRowsResponseToInternalRowIteratorConverter,
    Serializable {
        private final Schema bqSchema;
        private final List<String> columnsInOrder;
        private final String rawAvroSchema;
        private final com.google.common.base.Optional<StructType> userProvidedSchema;
        private final com.google.common.base.Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer;
        private final SchemaConvertersConfiguration schemaConvertersConfiguration;
        private final ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec;

        public Avro(Schema bqSchema, List<String> columnsInOrder, String rawAvroSchema, com.google.common.base.Optional<StructType> userProvidedSchema, com.google.common.base.Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer, SchemaConvertersConfiguration schemaConvertersConfiguration, ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec) {
            this.bqSchema = bqSchema;
            this.columnsInOrder = columnsInOrder;
            this.rawAvroSchema = rawAvroSchema;
            this.userProvidedSchema = userProvidedSchema;
            this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
            this.schemaConvertersConfiguration = schemaConvertersConfiguration;
            this.responseCompressionCodec = responseCompressionCodec;
        }

        @Override
        public Iterator<InternalRow> convert(ReadRowsResponse response) {
            return new AvroBinaryIterator(this.bqSchema, this.columnsInOrder, new Schema.Parser().parse(this.rawAvroSchema), response, this.userProvidedSchema.toJavaUtil(), this.bigQueryStorageReadRowsTracer.toJavaUtil(), this.schemaConvertersConfiguration, this.responseCompressionCodec);
        }

        @Override
        public int getBatchSizeInBytes(ReadRowsResponse response) {
            if (response.getUncompressedByteSize() > 0L) {
                return (int)response.getUncompressedByteSize();
            }
            return response.getAvroRows().getSerializedBinaryRows().size();
        }
    }
}

