/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.context;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.LazyInitializationSupplier;
import com.google.cloud.bigquery.connector.common.ReadSessionCreator;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SparkFilterUtils;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDFactory;
import com.google.cloud.spark.bigquery.metrics.DataOrigin;
import com.google.cloud.spark.bigquery.metrics.SparkBigQueryReadSessionMetrics;
import com.google.cloud.spark.bigquery.v2.context.ArrowInputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.BigQueryInputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.EmptyProjectionInputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.StatisticsContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDataSourceReaderContext {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryDataSourceReaderContext.class);
    private static StatisticsContext UNKNOWN_STATISTICS = new StatisticsContext(){

        @Override
        public OptionalLong sizeInBytes() {
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong numRows() {
            return OptionalLong.empty();
        }
    };
    private final TableInfo table;
    private final TableId tableId;
    private final ReadSessionCreatorConfig readSessionCreatorConfig;
    private final BigQueryClient bigQueryClient;
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory bigQueryTracerFactory;
    private final ReadSessionCreator readSessionCreator;
    private final SparkBigQueryConfig options;
    private final SQLContext sqlContext;
    private final SparkSession sparkSession;
    private final BigQueryRDDFactory bigQueryRDDFactory;
    private final Optional<String> globalFilter;
    private final String applicationId;
    private Optional<StructType> schema;
    private Optional<StructType> userProvidedSchema;
    private final Set<Filter> pushedFilters = new HashSet<Filter>();
    private Filter[] allFilters = new Filter[0];
    private Map<String, StructField> fields;
    private ImmutableList<String> selectedFields;
    private List<ArrowInputPartitionContext> plannedInputPartitionContexts;
    private LazyInitializationSupplier<ReadSessionResponse> readSessionResponse;
    private final ExecutorService asyncReadSessionExecutor = Executors.newSingleThreadExecutor();
    private boolean isBuilt = false;
    private final BigQueryClient.ReadTableOptions readTableOptions;

    public BigQueryDataSourceReaderContext(TableInfo table, BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryReadClientFactory, BigQueryTracerFactory tracerFactory, ReadSessionCreatorConfig readSessionCreatorConfig, Optional<String> globalFilter, Optional<StructType> schema, String applicationId, SparkBigQueryConfig options, SQLContext sqlContext, SparkSession sparkSession, BigQueryClient.ReadTableOptions readTableOptions) {
        this.table = table;
        this.tableId = table.getTableId();
        this.readSessionCreatorConfig = readSessionCreatorConfig;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.bigQueryTracerFactory = tracerFactory;
        this.sparkSession = sparkSession;
        this.readTableOptions = readTableOptions;
        this.readSessionCreator = new ReadSessionCreator(readSessionCreatorConfig, bigQueryClient, bigQueryReadClientFactory);
        this.globalFilter = globalFilter;
        SchemaConverters sc = SchemaConverters.from((SchemaConvertersConfiguration)SchemaConvertersConfiguration.from((SparkBigQueryConfig)options));
        StructType convertedSchema = sc.toSpark(sc.getSchemaWithPseudoColumns(table));
        if (schema.isPresent()) {
            this.schema = schema;
            this.userProvidedSchema = schema;
        } else {
            this.schema = Optional.of(convertedSchema);
            this.userProvidedSchema = Optional.empty();
        }
        this.fields = new LinkedHashMap<String, StructField>();
        for (StructField field : convertedSchema.fields()) {
            this.fields.put(field.name(), field);
        }
        this.applicationId = applicationId;
        this.options = options;
        this.sqlContext = sqlContext;
        this.bigQueryRDDFactory = new BigQueryRDDFactory(bigQueryClient, bigQueryReadClientFactory, this.bigQueryTracerFactory, options, sqlContext);
        this.resetReadSessionResponse();
    }

    private void resetReadSessionResponse() {
        this.readSessionResponse = new LazyInitializationSupplier(this::createReadSession);
    }

    public StructType readSchema() {
        return this.schema.orElseGet(() -> {
            SchemaConverters sc = SchemaConverters.from((SchemaConvertersConfiguration)SchemaConvertersConfiguration.from((SparkBigQueryConfig)this.options));
            return sc.toSpark(sc.getSchemaWithPseudoColumns(this.table));
        });
    }

    public boolean enableBatchRead() {
        return this.readSessionCreatorConfig.getReadDataFormat() == DataFormat.ARROW && !this.isEmptySchema();
    }

    public Stream<InputPartitionContext<InternalRow>> planInputPartitionContexts() {
        if (this.isEmptySchema()) {
            return this.createEmptyProjectionPartitions();
        }
        ReadSession readSession = ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession();
        return readSession.getStreamsList().stream().map(stream -> new BigQueryInputPartitionContext(this.bigQueryReadClientFactory, stream.getName(), this.readSessionCreatorConfig.toReadRowsHelperOptions(), this.createConverter(this.selectedFields, (ReadSessionResponse)this.readSessionResponse.get(), this.userProvidedSchema)));
    }

    public Optional<String> getCombinedFilter() {
        return BigQueryUtil.emptyIfNeeded((String)SparkFilterUtils.getCompiledFilter((boolean)this.readSessionCreatorConfig.getPushAllFilters(), (DataFormat)this.readSessionCreatorConfig.getReadDataFormat(), this.globalFilter, (Filter[])this.pushedFilters.toArray(new Filter[0])));
    }

    public DataOrigin getDataOrigin() {
        if (this.readTableOptions.query().isPresent()) {
            return DataOrigin.QUERY;
        }
        if (BigQueryUtil.isBigLakeManagedTable((TableInfo)this.table) || this.table.getDefinition().getType() == TableDefinition.Type.EXTERNAL) {
            return DataOrigin.BIGLAKE;
        }
        if (this.table.getDefinition().getType() == TableDefinition.Type.MATERIALIZED_VIEW) {
            return DataOrigin.VIEW;
        }
        return DataOrigin.TABLE;
    }

    public Stream<InputPartitionContext<ColumnarBatch>> planBatchInputPartitionContexts() {
        if (!this.enableBatchRead()) {
            throw new IllegalStateException("Batch reads should not be enabled");
        }
        ReadSession readSession = ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession();
        long currentTimeMillis = System.currentTimeMillis();
        SparkBigQueryReadSessionMetrics sparkBigQueryReadSessionMetrics = SparkBigQueryReadSessionMetrics.from((SparkSession)this.sparkSession, (ReadSession)readSession, (long)currentTimeMillis, (DataFormat)this.readSessionCreatorConfig.getReadDataFormat(), (DataOrigin)this.getDataOrigin(), (long)readSession.getStreamsCount());
        this.sparkSession.sparkContext().addSparkListener((SparkListenerInterface)sparkBigQueryReadSessionMetrics);
        ImmutableList tempSelectedFields = this.selectedFields;
        if (tempSelectedFields.isEmpty()) {
            Schema tableSchema = SchemaConverters.from((SchemaConvertersConfiguration)SchemaConvertersConfiguration.from((SparkBigQueryConfig)this.options)).getSchemaWithPseudoColumns(((ReadSessionResponse)this.readSessionResponse.get()).getReadTableInfo());
            tempSelectedFields = (ImmutableList)tableSchema.getFields().stream().map(Field::getName).collect(ImmutableList.toImmutableList());
        }
        ImmutableList partitionSelectedFields = tempSelectedFields;
        Optional<StructType> arrowSchema = Optional.of(this.userProvidedSchema.orElse(this.readSchema()));
        this.plannedInputPartitionContexts = Streams.stream((Iterable)Iterables.partition((Iterable)readSession.getStreamsList(), (int)this.readSessionCreatorConfig.streamsPerPartition())).map(streams -> new ArrowInputPartitionContext(this.bigQueryReadClientFactory, this.bigQueryTracerFactory, streams.stream().map(ReadStream::getName).collect(Collectors.toCollection(ArrayList::new)), this.readSessionCreatorConfig.toReadRowsHelperOptions(), (ImmutableList<String>)partitionSelectedFields, (ReadSessionResponse)this.readSessionResponse.get(), arrowSchema, sparkBigQueryReadSessionMetrics, this.readSessionCreatorConfig.getResponseCompressionCodec())).collect(Collectors.toList());
        return this.plannedInputPartitionContexts.stream().map(ctx -> ctx);
    }

    private boolean isEmptySchema() {
        return this.schema.map(StructType::isEmpty).orElse(false);
    }

    private ReadRowsResponseToInternalRowIteratorConverter createConverter(ImmutableList<String> selectedFields, ReadSessionResponse readSessionResponse, Optional<StructType> userProvidedSchema) {
        DataFormat format = this.readSessionCreatorConfig.getReadDataFormat();
        if (format == DataFormat.AVRO) {
            Schema schema = SchemaConverters.from((SchemaConvertersConfiguration)SchemaConvertersConfiguration.from((SparkBigQueryConfig)this.options)).getSchemaWithPseudoColumns(readSessionResponse.getReadTableInfo());
            if (selectedFields.isEmpty()) {
                selectedFields = (ImmutableList)schema.getFields().stream().map(Field::getName).collect(ImmutableList.toImmutableList());
            } else {
                ImmutableSet requiredColumnSet = ImmutableSet.copyOf(selectedFields);
                schema = Schema.of((Iterable)schema.getFields().stream().filter(arg_0 -> BigQueryDataSourceReaderContext.lambda$createConverter$4((Set)requiredColumnSet, arg_0)).collect(Collectors.toList()));
            }
            return ReadRowsResponseToInternalRowIteratorConverter.avro((Schema)schema, (List)selectedFields, (String)readSessionResponse.getReadSession().getAvroSchema().getSchema(), userProvidedSchema, Optional.empty(), (SchemaConvertersConfiguration)SchemaConvertersConfiguration.from((SparkBigQueryConfig)this.options), (ReadSession.TableReadOptions.ResponseCompressionCodec)this.readSessionCreatorConfig.getResponseCompressionCodec());
        }
        throw new IllegalArgumentException("No known converted for " + this.readSessionCreatorConfig.getReadDataFormat());
    }

    private ReadSessionResponse createReadSession() {
        this.selectedFields = this.schema.map(requiredSchema -> ImmutableList.copyOf((Object[])requiredSchema.fieldNames())).orElse(ImmutableList.copyOf(this.fields.keySet()));
        Optional<String> filter = this.getCombinedFilter();
        ReadSessionResponse response = this.readSessionCreator.create(this.tableId, this.selectedFields, filter);
        logger.info("Got read session for {}: {} for application id: {}", new Object[]{this.tableId.toString(), response.getReadSession().getName(), this.applicationId});
        return response;
    }

    Stream<InputPartitionContext<InternalRow>> createEmptyProjectionPartitions() {
        Optional<String> filter = this.getCombinedFilter();
        long rowCount = this.bigQueryClient.calculateTableSize(this.tableId, filter);
        logger.info("Used optimized BQ count(*) path. Count: " + rowCount);
        int partitionsCount = this.readSessionCreatorConfig.getDefaultParallelism();
        int partitionSize = (int)(rowCount / (long)partitionsCount);
        InputPartitionContext[] partitions = (InputPartitionContext[])IntStream.range(0, partitionsCount).mapToObj(ignored -> new EmptyProjectionInputPartitionContext(partitionSize)).toArray(EmptyProjectionInputPartitionContext[]::new);
        int firstPartitionSize = partitionSize + (int)(rowCount % (long)partitionsCount);
        partitions[0] = new EmptyProjectionInputPartitionContext(firstPartitionSize);
        return Stream.of(partitions);
    }

    public Filter[] pushFilters(Filter[] filters) {
        ArrayList<Filter> handledFilters = new ArrayList<Filter>();
        ArrayList<Filter> unhandledFilters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (SparkFilterUtils.isTopLevelFieldHandled((boolean)this.readSessionCreatorConfig.getPushAllFilters(), (Filter)filter, (DataFormat)this.readSessionCreatorConfig.getReadDataFormat(), this.fields)) {
                handledFilters.add(filter);
                continue;
            }
            unhandledFilters.add(filter);
        }
        this.allFilters = filters;
        this.pushedFilters.addAll(handledFilters);
        return (Filter[])unhandledFilters.stream().toArray(Filter[]::new);
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters.toArray(new Filter[0]);
    }

    public Filter[] getAllFilters() {
        return this.allFilters;
    }

    public Optional<List<ArrowInputPartitionContext>> filter(Filter[] filters) {
        logger.info(String.format("Use Dynamic Partition Pruning runtime filters: %s", filters));
        if (this.plannedInputPartitionContexts == null) {
            logger.error("Should have planned partitions.");
            return Optional.empty();
        }
        ImmutableList newFilters = SparkBigQueryUtil.extractPartitionAndClusteringFilters((TableInfo)this.table, (ImmutableList)ImmutableList.copyOf((Object[])filters));
        if (newFilters.isEmpty()) {
            logger.info("Could not find filters for partition of clustering field for table {}, aborting DPP filter", (Object)BigQueryUtil.friendlyTableName((TableId)this.tableId));
            return Optional.empty();
        }
        this.pushedFilters.addAll((Collection<Filter>)newFilters);
        Optional<String> combinedFilter = this.getCombinedFilter();
        if (!BigQueryUtil.filterLengthInLimit(combinedFilter)) {
            logger.warn("New filter for Dynamic Partition Pruning is too large, skipping partition pruning");
            return Optional.empty();
        }
        List<ArrowInputPartitionContext> previousInputPartitionContexts = this.plannedInputPartitionContexts;
        this.resetReadSessionResponse();
        this.planBatchInputPartitionContexts();
        if (this.plannedInputPartitionContexts.size() > previousInputPartitionContexts.size()) {
            logger.warn(String.format("New partitions should not be more than originally planned. Previously had %d streams, now has %d.", previousInputPartitionContexts.size(), this.plannedInputPartitionContexts.size()));
            return Optional.of(this.plannedInputPartitionContexts);
        }
        logger.info(String.format("Use Dynamic Partition Pruning, originally planned %d, adjust to %d partitions", previousInputPartitionContexts.size(), this.plannedInputPartitionContexts.size()));
        return Optional.of(this.plannedInputPartitionContexts);
    }

    public void pruneColumns(StructType requiredSchema) {
        this.schema = this.schema.map(prevSchema -> {
            ImmutableSet requiredCols = ImmutableSet.copyOf((Object[])requiredSchema.fieldNames());
            StructType prunedSchema = new StructType();
            for (StructField field : prevSchema.fields()) {
                if (!requiredCols.contains(field.name())) continue;
                prunedSchema = prunedSchema.add(field);
            }
            return prunedSchema;
        });
    }

    public StatisticsContext estimateStatistics() {
        final boolean isBigLakeManagedTable = BigQueryUtil.isBigLakeManagedTable((TableInfo)this.table);
        if (BigQueryUtil.isBigQueryNativeTable((TableInfo)this.table)) {
            long numRowsInTable;
            long tableSizeInBytes;
            if (this.isBuilt) {
                tableSizeInBytes = ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession().getEstimatedTotalBytesScanned();
                numRowsInTable = ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession().getEstimatedRowCount();
            } else {
                tableSizeInBytes = this.table.getNumBytes();
                numRowsInTable = this.table.getNumRows().longValue();
            }
            StatisticsContext tableStatisticsContext = new StatisticsContext(){

                @Override
                public OptionalLong sizeInBytes() {
                    return OptionalLong.of(tableSizeInBytes);
                }

                @Override
                public OptionalLong numRows() {
                    return OptionalLong.of(numRowsInTable);
                }
            };
            return tableStatisticsContext;
        }
        if (this.table.getDefinition().getType() == TableDefinition.Type.EXTERNAL || isBigLakeManagedTable) {
            ReadSession readSession = ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession();
            long tablePhysicalSizeInBytes = readSession.getEstimatedTotalPhysicalFileSize();
            final long tableRowCount = readSession.getEstimatedRowCount();
            long originalRowSize = this.getRowSize(this.fields.values());
            long projectedRowSize = this.schema.map(schema -> this.getRowSize(Arrays.asList(schema.fields()))).orElse(originalRowSize);
            long tableProjectedSizeInBytes = tablePhysicalSizeInBytes * projectedRowSize / originalRowSize;
            final OptionalLong sizeInBytes = tableProjectedSizeInBytes == 0L ? OptionalLong.empty() : OptionalLong.of(tableProjectedSizeInBytes);
            StatisticsContext tableStatisticsContext = new StatisticsContext(){

                @Override
                public OptionalLong sizeInBytes() {
                    return sizeInBytes;
                }

                @Override
                public OptionalLong numRows() {
                    return isBigLakeManagedTable ? OptionalLong.of(tableRowCount) : OptionalLong.empty();
                }
            };
            return tableStatisticsContext;
        }
        return UNKNOWN_STATISTICS;
    }

    public String getTableName() {
        return this.tableId.getTable();
    }

    public String getFullTableName() {
        return BigQueryUtil.friendlyTableName((TableId)this.tableId);
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public BigQueryRDDFactory getBigQueryRddFactory() {
        return this.bigQueryRDDFactory;
    }

    public TableInfo getTableInfo() {
        return this.table;
    }

    public void build() {
        this.asyncReadSessionExecutor.submit(() -> (ReadSessionResponse)this.readSessionResponse.get());
        this.asyncReadSessionExecutor.shutdown();
        this.isBuilt = true;
    }

    private long getRowSize(Collection<StructField> fields) {
        return 8L + fields.stream().map(structField -> structField.dataType().defaultSize()).reduce(0L, Long::sum);
    }

    public String getReadSessionId() {
        if (this.readSessionResponse.isInitialized()) {
            return ((ReadSessionResponse)this.readSessionResponse.get()).getReadSession().getName();
        }
        return "N/A";
    }

    private static /* synthetic */ boolean lambda$createConverter$4(Set requiredColumnSet, Field field) {
        return requiredColumnSet.contains(field.getName());
    }
}

