/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.context;

import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.v2.context.BigQueryDataSourceReaderContext;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Optional;
import org.apache.spark.sql.SparkSession;

public class BigQueryDataSourceReaderModule
implements Module {
    private Optional<SparkBigQueryConfig> tableScanConfig;

    public BigQueryDataSourceReaderModule() {
        this(Optional.empty());
    }

    public BigQueryDataSourceReaderModule(Optional<SparkBigQueryConfig> tableScanConfig) {
        this.tableScanConfig = tableScanConfig;
    }

    public void configure(Binder binder) {
    }

    @Singleton
    @Provides
    public BigQueryDataSourceReaderContext provideDataSourceReaderContext(BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryReadClientFactory, BigQueryTracerFactory tracerFactory, SparkBigQueryConfig globalConfig, SparkSession sparkSession) {
        SparkBigQueryConfig config = this.tableScanConfig.orElse(globalConfig);
        TableInfo tableInfo = bigQueryClient.getReadTable(config.toReadTableOptions());
        return new BigQueryDataSourceReaderContext(tableInfo, bigQueryClient, bigQueryReadClientFactory, tracerFactory, config.toReadSessionCreatorConfig(), config.getFilter(), config.getSchema(), sparkSession.sparkContext().applicationId(), config, sparkSession.sqlContext(), sparkSession, config.toReadTableOptions());
    }
}

