/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.context;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionReaderContext;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.spark.sql.catalyst.InternalRow;

class BigQueryInputPartitionReaderContext
implements InputPartitionReaderContext<InternalRow> {
    private Iterator<ReadRowsResponse> readRowsResponses;
    private ReadRowsResponseToInternalRowIteratorConverter converter;
    private ReadRowsHelper readRowsHelper;
    private Iterator<InternalRow> rows = ImmutableList.of().iterator();
    private InternalRow currentRow;

    BigQueryInputPartitionReaderContext(Iterator<ReadRowsResponse> readRowsResponses, ReadRowsResponseToInternalRowIteratorConverter converter, ReadRowsHelper readRowsHelper) {
        this.readRowsResponses = readRowsResponses;
        this.converter = converter;
        this.readRowsHelper = readRowsHelper;
    }

    @Override
    public boolean next() throws IOException {
        while (!this.rows.hasNext()) {
            if (!this.readRowsResponses.hasNext()) {
                return false;
            }
            ReadRowsResponse readRowsResponse = this.readRowsResponses.next();
            this.rows = this.converter.convert(readRowsResponse);
        }
        this.currentRow = this.rows.next();
        return true;
    }

    @Override
    public InternalRow get() {
        return this.currentRow;
    }

    @Override
    public Optional<BigQueryStorageReadRowsTracer> getBigQueryStorageReadRowsTracer() {
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        this.readRowsHelper.close();
    }
}

