/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSqlUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.collection.mutable.IndexedSeq;

public class AvroSchemaConverter {
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final Conversions.DecimalConversion DECIMAL_CONVERSIONS = new Conversions.DecimalConversion();

    public static Schema sparkSchemaToAvroSchema(StructType sparkSchema) {
        return AvroSchemaConverter.sparkTypeToRawAvroType((DataType)sparkSchema, Metadata.empty(), false, "root");
    }

    static Schema sparkTypeToRawAvroType(DataType dataType, Metadata metadata, boolean nullable, String recordName) {
        SchemaBuilder.TypeBuilder builder = SchemaBuilder.builder();
        Schema avroType = AvroSchemaConverter.sparkTypeToRawAvroType(dataType, metadata, recordName, (SchemaBuilder.TypeBuilder<Schema>)builder);
        if (nullable) {
            avroType = Schema.createUnion((Schema[])new Schema[]{avroType, NULL});
        }
        return avroType;
    }

    static Schema sparkTypeToRawAvroType(DataType dataType, Metadata metadata, String recordName, SchemaBuilder.TypeBuilder<Schema> builder) {
        if (dataType instanceof BinaryType) {
            return (Schema)builder.bytesType();
        }
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType) {
            return (Schema)builder.longType();
        }
        if (dataType instanceof BooleanType) {
            return (Schema)builder.booleanType();
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            return (Schema)builder.doubleType();
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            if (decimalType.precision() <= 38 && decimalType.scale() <= 38) {
                return LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale()).addToSchema((Schema)builder.bytesType());
            }
            throw new IllegalArgumentException("Decimal type is too wide to fit in BigQuery Numeric format");
        }
        if (dataType instanceof StringType) {
            if (SparkBigQueryUtil.isJson(metadata)) {
                return (Schema)((SchemaBuilder.StringBldr)builder.stringBuilder().prop("sqlType", "JSON")).endString();
            }
            return (Schema)builder.stringType();
        }
        if (dataType instanceof TimestampType) {
            return LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
        }
        if (dataType instanceof DateType) {
            return LogicalTypes.date().addToSchema((Schema)builder.intType());
        }
        if (dataType instanceof ArrayType) {
            return (Schema)builder.array().items(AvroSchemaConverter.sparkTypeToRawAvroType(((ArrayType)dataType).elementType(), metadata, ((ArrayType)dataType).containsNull(), recordName));
        }
        if (dataType instanceof StructType) {
            SchemaBuilder.FieldAssembler fieldsAssembler = builder.record(recordName).fields();
            for (StructField field : ((StructType)dataType).fields()) {
                Schema avroType = AvroSchemaConverter.sparkTypeToRawAvroType(field.dataType(), field.metadata(), field.nullable(), field.name());
                fieldsAssembler.name(field.name()).type(avroType).noDefault();
            }
            return (Schema)fieldsAssembler.endRecord();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return (Schema)builder.map().values(AvroSchemaConverter.sparkTypeToRawAvroType(mapType.valueType(), metadata, mapType.valueContainsNull(), "value"));
        }
        if (dataType instanceof UserDefinedType) {
            DataType userDefinedType = ((UserDefinedType)dataType).sqlType();
            return AvroSchemaConverter.sparkTypeToRawAvroType(userDefinedType, metadata, recordName, builder);
        }
        throw new IllegalArgumentException("Data type not supported: " + dataType.simpleString());
    }

    public static GenericData.Record sparkRowToAvroGenericData(InternalRow row, StructType sparkSchema, Schema avroSchema) {
        StructConverter structConverter = new StructConverter(sparkSchema, avroSchema);
        return structConverter.convert(row);
    }

    static Schema resolveNullableType(Schema avroType, boolean nullable) {
        if (nullable && avroType.getType() != Schema.Type.NULL) {
            List fields = avroType.getTypes();
            Preconditions.checkArgument(fields.size() == 2, "Avro nullable filed should be represented by a union of size 2");
            Optional<Schema> actualType = fields.stream().filter(field -> field.getType() != Schema.Type.NULL).findFirst();
            return actualType.orElseThrow(() -> new IllegalArgumentException("No actual type has been found in " + avroType));
        }
        return avroType;
    }

    static Converter createConverterFor(DataType sparkType, Schema avroType) {
        if (sparkType instanceof NullType && avroType.getType() == Schema.Type.NULL) {
            return (getter, ordinal) -> null;
        }
        if (sparkType instanceof BooleanType && avroType.getType() == Schema.Type.BOOLEAN) {
            return (getter, ordinal) -> getter.getBoolean(ordinal);
        }
        if (sparkType instanceof ByteType && avroType.getType() == Schema.Type.LONG) {
            return (getter, ordinal) -> (long)getter.getByte(ordinal);
        }
        if (sparkType instanceof ShortType && avroType.getType() == Schema.Type.LONG) {
            return (getter, ordinal) -> (long)getter.getShort(ordinal);
        }
        if (sparkType instanceof IntegerType && avroType.getType() == Schema.Type.LONG) {
            return (getter, ordinal) -> (long)getter.getInt(ordinal);
        }
        if (sparkType instanceof LongType && avroType.getType() == Schema.Type.LONG) {
            return (getter, ordinal) -> getter.getLong(ordinal);
        }
        if (sparkType instanceof FloatType && avroType.getType() == Schema.Type.DOUBLE) {
            return (getter, ordinal) -> (double)getter.getFloat(ordinal);
        }
        if (sparkType instanceof DoubleType && avroType.getType() == Schema.Type.DOUBLE) {
            return (getter, ordinal) -> getter.getDouble(ordinal);
        }
        if (sparkType instanceof DecimalType && avroType.getType() == Schema.Type.BYTES) {
            DecimalType decimalType = (DecimalType)sparkType;
            return (getter, ordinal) -> {
                BigDecimal bigDecimal = null;
                if (getter instanceof UnsafeRow || getter instanceof UnsafeArrayData) {
                    Decimal decimal = getter.getDecimal(ordinal, decimalType.precision(), decimalType.scale());
                    bigDecimal = decimal.toJavaBigDecimal();
                } else {
                    Object decimal = getter.get(ordinal, null);
                    bigDecimal = decimal instanceof Decimal ? ((Decimal)decimal).toJavaBigDecimal() : (BigDecimal)decimal;
                }
                return DECIMAL_CONVERSIONS.toBytes(bigDecimal, avroType, (LogicalType)LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale()));
            };
        }
        if (sparkType instanceof StringType && avroType.getType() == Schema.Type.STRING) {
            return (getter, ordinal) -> {
                String str = getter instanceof UnsafeRow || getter instanceof UnsafeArrayData ? getter.getUTF8String(ordinal).toString() : getter.get(ordinal, null).toString();
                return new Utf8(str);
            };
        }
        if (sparkType instanceof BinaryType && avroType.getType() == Schema.Type.FIXED) {
            int size = avroType.getFixedSize();
            return (getter, ordinal) -> {
                byte[] data = getter.getBinary(ordinal);
                if (data.length != size) {
                    throw new IllegalArgumentException(String.format("Cannot write %s bytes of binary data into FIXED Type with size of %s bytes", data.length, size));
                }
                return new GenericData.Fixed(avroType, data);
            };
        }
        if (sparkType instanceof BinaryType && avroType.getType() == Schema.Type.BYTES) {
            return (getter, ordinal) -> ByteBuffer.wrap(getter.getBinary(ordinal));
        }
        if (sparkType instanceof DateType && avroType.getType() == Schema.Type.INT) {
            return (getter, ordinal) -> {
                Integer sparkValue = getter instanceof UnsafeRow || getter instanceof UnsafeArrayData ? Integer.valueOf(getter.getInt(ordinal)) : getter.get(ordinal, null);
                return SparkBigQueryUtil.sparkDateToBigQuery(sparkValue);
            };
        }
        if (sparkType instanceof TimestampType && avroType.getType() == Schema.Type.LONG) {
            return (getter, ordinal) -> {
                Long sparkValue = getter instanceof UnsafeRow || getter instanceof UnsafeArrayData ? Long.valueOf(getter.getLong(ordinal)) : getter.get(ordinal, null);
                return SparkBigQueryUtil.sparkTimestampToBigQuery(sparkValue);
            };
        }
        if (sparkType instanceof ArrayType && avroType.getType() == Schema.Type.ARRAY) {
            DataType et = ((ArrayType)sparkType).elementType();
            boolean containsNull = ((ArrayType)sparkType).containsNull();
            Converter elementConverter = AvroSchemaConverter.createConverterFor(et, AvroSchemaConverter.resolveNullableType(avroType.getElementType(), containsNull));
            return (getter, ordinal) -> {
                Object array;
                ArrayData arrayData = null;
                arrayData = getter instanceof UnsafeRow || getter instanceof UnsafeArrayData ? getter.getArray(ordinal) : ((array = getter.get(ordinal, null)) instanceof IndexedSeq ? ArrayData.toArrayData((Object)array) : (ArrayData)array);
                int len = arrayData.numElements();
                Object[] result = new Object[len];
                for (int i = 0; i < len; ++i) {
                    result[i] = containsNull && arrayData.isNullAt(i) ? null : elementConverter.convert((SpecializedGetters)arrayData, i);
                }
                return Arrays.asList(result);
            };
        }
        if (sparkType instanceof StructType && avroType.getType() == Schema.Type.RECORD) {
            StructType sparkStruct = (StructType)sparkType;
            StructConverter structConverter = new StructConverter(sparkStruct, avroType);
            int numFields = sparkStruct.length();
            return (getter, ordinal) -> {
                Object obj;
                InternalRow internalRow = null;
                internalRow = getter instanceof UnsafeRow || getter instanceof UnsafeArrayData ? getter.getStruct(ordinal, numFields) : ((obj = getter.get(ordinal, null)) instanceof Row ? SparkSqlUtils.getInstance().rowToInternalRow((Row)obj) : (InternalRow)obj);
                return structConverter.convert(internalRow);
            };
        }
        if (sparkType instanceof MapType && avroType.getType() == Schema.Type.MAP) {
            MapType mapType = (MapType)sparkType;
            Converter keyConverter = AvroSchemaConverter.createConverterFor(mapType.keyType(), Schema.create((Schema.Type)Schema.Type.STRING));
            Schema valueType = avroType.getValueType();
            Schema nullableValueType = AvroSchemaConverter.resolveNullableType(valueType, mapType.valueContainsNull());
            Converter valueConverter = AvroSchemaConverter.createConverterFor(mapType.valueType(), nullableValueType);
            return (getter, ordinal) -> {
                HashMap<Utf8, Object> result = new HashMap<Utf8, Object>();
                MapData map = getter.getMap(ordinal);
                ArrayData keys = map.keyArray();
                ArrayData values = map.valueArray();
                for (int i = 0; i < map.numElements(); ++i) {
                    Utf8 key = (Utf8)keyConverter.convert((SpecializedGetters)keys, i);
                    Object value = valueConverter.convert((SpecializedGetters)values, i);
                    result.put(key, value);
                }
                return result;
            };
        }
        if (sparkType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)sparkType;
            return AvroSchemaConverter.createConverterFor(userDefinedType.sqlType(), avroType);
        }
        throw new IllegalArgumentException(String.format("Cannot convert Catalyst type %s to Avro type %s", sparkType, avroType));
    }

    static class StructConverter {
        private final StructType sparkStruct;
        private final Schema avroStruct;

        StructConverter(StructType sparkStruct, Schema avroStruct) {
            this.sparkStruct = sparkStruct;
            this.avroStruct = avroStruct;
            Preconditions.checkArgument(avroStruct.getType() == Schema.Type.RECORD && avroStruct.getFields().size() == sparkStruct.length(), "Cannot convert Catalyst type %s to Avro type %s.", (Object)sparkStruct, (Object)avroStruct);
        }

        GenericData.Record convert(InternalRow row) {
            int numFields = this.sparkStruct.length();
            Converter[] fieldConverters = new Converter[numFields];
            StructField[] sparkFields = this.sparkStruct.fields();
            Schema.Field[] avroFields = this.avroStruct.getFields().toArray(new Schema.Field[numFields]);
            GenericData.Record result = new GenericData.Record(this.avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(i, null);
                    continue;
                }
                Converter fieldConverter = AvroSchemaConverter.createConverterFor(sparkFields[i].dataType(), AvroSchemaConverter.resolveNullableType(avroFields[i].schema(), sparkFields[i].nullable()));
                result.put(i, fieldConverter.convert((SpecializedGetters)row, i));
            }
            return result;
        }
    }

    @FunctionalInterface
    static interface Converter {
        public Object convert(SpecializedGetters var1, int var2);
    }
}

