/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Data;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Dataset;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RoutineReference;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Acl;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Annotations;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.DatasetId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ExternalDatasetReference;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.RoutineId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Function;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Lists;
import com.google.cloud.spark.bigquery.repackaged.io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetInfo
implements Serializable {
    static final Function<Dataset, DatasetInfo> FROM_PB_FUNCTION = new Function<Dataset, DatasetInfo>(){

        @Override
        public DatasetInfo apply(Dataset pb) {
            return DatasetInfo.fromPb(pb);
        }
    };
    static final Function<DatasetInfo, Dataset> TO_PB_FUNCTION = new Function<DatasetInfo, Dataset>(){

        @Override
        public Dataset apply(DatasetInfo datasetInfo) {
            return datasetInfo.toPb();
        }
    };
    private static final long serialVersionUID = 8469473744160758489L;
    private final DatasetId datasetId;
    private final List<Acl> acl;
    private final Long creationTime;
    private final Long defaultTableLifetime;
    private final String description;
    private final String etag;
    private final String friendlyName;
    private final String generatedId;
    private final Long lastModified;
    private final String location;
    private final String selfLink;
    private final Annotations labels;
    private final EncryptionConfiguration defaultEncryptionConfiguration;
    private final Long defaultPartitionExpirationMs;
    private final String defaultCollation;
    private final ExternalDatasetReference externalDatasetReference;
    private final String storageBillingModel;
    private final Long maxTimeTravelHours;
    private final Annotations resourceTags;

    DatasetInfo(BuilderImpl builder) {
        this.datasetId = Preconditions.checkNotNull(builder.datasetId);
        this.acl = builder.acl;
        this.creationTime = builder.creationTime;
        this.defaultTableLifetime = builder.defaultTableLifetime;
        this.description = builder.description;
        this.etag = builder.etag;
        this.friendlyName = builder.friendlyName;
        this.generatedId = builder.generatedId;
        this.lastModified = builder.lastModified;
        this.location = builder.location;
        this.selfLink = builder.selfLink;
        this.labels = builder.labels;
        this.defaultEncryptionConfiguration = builder.defaultEncryptionConfiguration;
        this.defaultPartitionExpirationMs = builder.defaultPartitionExpirationMs;
        this.defaultCollation = builder.defaultCollation;
        this.externalDatasetReference = builder.externalDatasetReference;
        this.storageBillingModel = builder.storageBillingModel;
        this.maxTimeTravelHours = builder.maxTimeTravelHours;
        this.resourceTags = builder.resourceTags;
    }

    public DatasetId getDatasetId() {
        return this.datasetId;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getDefaultTableLifetime() {
        return this.defaultTableLifetime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Map<String, String> getLabels() {
        return this.labels.userMap();
    }

    public EncryptionConfiguration getDefaultEncryptionConfiguration() {
        return this.defaultEncryptionConfiguration;
    }

    public Long getDefaultPartitionExpirationMs() {
        return this.defaultPartitionExpirationMs;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public String getStorageBillingModel() {
        return this.storageBillingModel;
    }

    public Long getMaxTimeTravelHours() {
        return this.maxTimeTravelHours;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags.userMap();
    }

    public ExternalDatasetReference getExternalDatasetReference() {
        return this.externalDatasetReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("datasetId", this.datasetId).add("creationTime", this.creationTime).add("defaultTableLifetime", this.defaultTableLifetime).add("description", this.description).add("etag", this.etag).add("friendlyName", this.friendlyName).add("generatedId", this.generatedId).add("lastModified", this.lastModified).add("location", this.location).add("selfLink", this.selfLink).add("acl", this.acl).add("labels", this.labels).add("defaultEncryptionConfiguration", this.defaultEncryptionConfiguration).add("defaultPartitionExpirationMs", this.defaultPartitionExpirationMs).add("defaultCollation", this.defaultCollation).add("externalDatasetReference", this.externalDatasetReference).add("storageBillingModel", this.storageBillingModel).add("maxTimeTravelHours", this.maxTimeTravelHours).add("resourceTags", this.resourceTags).toString();
    }

    public int hashCode() {
        return Objects.hash(this.datasetId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(DatasetInfo.class) && Objects.equals(this.toPb(), ((DatasetInfo)obj).toPb());
    }

    DatasetInfo setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        builder.setDatasetId(this.getDatasetId().setProjectId(projectId));
        if (this.getAcl() != null) {
            ArrayList<Acl> acls = Lists.newArrayListWithCapacity(this.getAcl().size());
            for (Acl acl : this.getAcl()) {
                Dataset.Access accessPb;
                if (acl.getEntity().getType() == Acl.Entity.Type.VIEW) {
                    accessPb = acl.toPb();
                    TableReference viewReferencePb = accessPb.getView();
                    if (viewReferencePb.getProjectId() == null) {
                        viewReferencePb.setProjectId(projectId);
                    }
                    acls.add(Acl.of(new Acl.View(TableId.fromPb(viewReferencePb))));
                    continue;
                }
                if (acl.getEntity().getType() == Acl.Entity.Type.ROUTINE) {
                    accessPb = acl.toPb();
                    RoutineReference routineReferencePb = accessPb.getRoutine();
                    if (routineReferencePb.getProjectId() == null) {
                        routineReferencePb.setProjectId(projectId);
                    }
                    acls.add(Acl.of(new Acl.Routine(RoutineId.fromPb(routineReferencePb))));
                    continue;
                }
                acls.add(acl);
            }
            builder.setAcl(acls);
        }
        return builder.build();
    }

    Dataset toPb() {
        Dataset datasetPb = new Dataset();
        datasetPb.setDatasetReference(this.datasetId.toPb());
        datasetPb.setCreationTime(this.creationTime);
        datasetPb.setDefaultTableExpirationMs(this.defaultTableLifetime);
        datasetPb.setDescription(this.description);
        datasetPb.setEtag(this.etag);
        datasetPb.setFriendlyName(this.friendlyName);
        datasetPb.setId(this.generatedId);
        datasetPb.setLastModifiedTime(this.lastModified);
        datasetPb.setLocation(this.location);
        datasetPb.setSelfLink(this.selfLink);
        if (this.acl != null) {
            datasetPb.setAccess(Lists.transform(this.acl, new Function<Acl, Dataset.Access>(){

                @Override
                public Dataset.Access apply(Acl acl) {
                    return acl.toPb();
                }
            }));
        }
        datasetPb.setLabels(this.labels.toPb());
        if (this.defaultEncryptionConfiguration != null) {
            datasetPb.setDefaultEncryptionConfiguration(this.defaultEncryptionConfiguration.toPb());
        }
        if (this.defaultPartitionExpirationMs != null) {
            datasetPb.setDefaultPartitionExpirationMs(this.defaultPartitionExpirationMs);
        }
        if (this.defaultCollation != null) {
            datasetPb.setDefaultCollation(this.defaultCollation);
        }
        if (this.externalDatasetReference != null) {
            datasetPb.setExternalDatasetReference(this.externalDatasetReference.toPb());
        }
        if (this.storageBillingModel != null) {
            datasetPb.setStorageBillingModel(this.storageBillingModel);
        }
        if (this.maxTimeTravelHours != null) {
            datasetPb.setMaxTimeTravelHours(this.maxTimeTravelHours);
        }
        datasetPb.setResourceTags(this.resourceTags.toPb());
        return datasetPb;
    }

    public static Builder newBuilder(DatasetId datasetId) {
        return new BuilderImpl().setDatasetId(datasetId);
    }

    public static Builder newBuilder(String datasetId) {
        return DatasetInfo.newBuilder(DatasetId.of(datasetId));
    }

    public static Builder newBuilder(String projectId, String datasetId) {
        return DatasetInfo.newBuilder(DatasetId.of(projectId, datasetId));
    }

    public static DatasetInfo of(DatasetId datasetId) {
        return DatasetInfo.newBuilder(datasetId).build();
    }

    public static DatasetInfo of(String datasetId) {
        return DatasetInfo.newBuilder(datasetId).build();
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().putAll(this.getDatasetId().getOtelAttributes()).put("bq.dataset.last_modified", DatasetInfo.getFieldAsString(this.getLastModified())).put("bq.dataset.location", DatasetInfo.getFieldAsString(this.getLocation())).build();
    }

    static DatasetInfo fromPb(Dataset datasetPb) {
        return new BuilderImpl(datasetPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private DatasetId datasetId;
        private List<Acl> acl;
        private Long creationTime;
        private Long defaultTableLifetime;
        private String description;
        private String etag;
        private String friendlyName;
        private String generatedId;
        private Long lastModified;
        private String location;
        private String selfLink;
        private Annotations labels = Annotations.ZERO;
        private EncryptionConfiguration defaultEncryptionConfiguration;
        private Long defaultPartitionExpirationMs;
        private String defaultCollation;
        private ExternalDatasetReference externalDatasetReference;
        private String storageBillingModel;
        private Long maxTimeTravelHours;
        private Annotations resourceTags = Annotations.ZERO;

        BuilderImpl() {
        }

        BuilderImpl(DatasetInfo datasetInfo) {
            this.datasetId = datasetInfo.datasetId;
            this.acl = datasetInfo.acl;
            this.creationTime = datasetInfo.creationTime;
            this.defaultTableLifetime = datasetInfo.defaultTableLifetime;
            this.description = datasetInfo.description;
            this.etag = datasetInfo.etag;
            this.friendlyName = datasetInfo.friendlyName;
            this.generatedId = datasetInfo.generatedId;
            this.lastModified = datasetInfo.lastModified;
            this.location = datasetInfo.location;
            this.selfLink = datasetInfo.selfLink;
            this.labels = datasetInfo.labels;
            this.defaultEncryptionConfiguration = datasetInfo.defaultEncryptionConfiguration;
            this.defaultPartitionExpirationMs = datasetInfo.defaultPartitionExpirationMs;
            this.defaultCollation = datasetInfo.defaultCollation;
            this.externalDatasetReference = datasetInfo.externalDatasetReference;
            this.storageBillingModel = datasetInfo.storageBillingModel;
            this.maxTimeTravelHours = datasetInfo.maxTimeTravelHours;
            this.resourceTags = datasetInfo.resourceTags;
        }

        BuilderImpl(Dataset datasetPb) {
            if (datasetPb.getDatasetReference() != null) {
                this.datasetId = DatasetId.fromPb(datasetPb.getDatasetReference());
            }
            if (datasetPb.getAccess() != null) {
                this.acl = Lists.transform(datasetPb.getAccess(), new Function<Dataset.Access, Acl>(){

                    @Override
                    public Acl apply(Dataset.Access accessPb) {
                        return Acl.fromPb(accessPb);
                    }
                });
            }
            this.creationTime = datasetPb.getCreationTime();
            this.defaultTableLifetime = datasetPb.getDefaultTableExpirationMs();
            this.description = datasetPb.getDescription();
            this.etag = datasetPb.getEtag();
            this.friendlyName = datasetPb.getFriendlyName();
            this.generatedId = datasetPb.getId();
            this.lastModified = datasetPb.getLastModifiedTime();
            this.location = datasetPb.getLocation();
            this.selfLink = datasetPb.getSelfLink();
            this.labels = Annotations.fromPb(datasetPb.getLabels());
            if (datasetPb.getDefaultEncryptionConfiguration() != null) {
                this.defaultEncryptionConfiguration = new EncryptionConfiguration.Builder(datasetPb.getDefaultEncryptionConfiguration()).build();
            }
            this.defaultPartitionExpirationMs = datasetPb.getDefaultPartitionExpirationMs();
            this.defaultCollation = datasetPb.getDefaultCollation();
            if (datasetPb.getExternalDatasetReference() != null) {
                this.externalDatasetReference = ExternalDatasetReference.fromPb(datasetPb.getExternalDatasetReference());
            }
            this.storageBillingModel = datasetPb.getStorageBillingModel();
            this.maxTimeTravelHours = datasetPb.getMaxTimeTravelHours();
            this.resourceTags = Annotations.fromPb(datasetPb.getResourceTags());
        }

        @Override
        public Builder setDatasetId(DatasetId datasetId) {
            this.datasetId = Preconditions.checkNotNull(datasetId);
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Builder setDefaultTableLifetime(Long defaultTableLifetime) {
            this.defaultTableLifetime = MoreObjects.firstNonNull(defaultTableLifetime, Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = MoreObjects.firstNonNull(description, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = MoreObjects.firstNonNull(friendlyName, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setLastModified(Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.location = MoreObjects.firstNonNull(location, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Annotations.fromUser(labels);
            return this;
        }

        @Override
        public Builder setDefaultEncryptionConfiguration(EncryptionConfiguration defaultEncryptionConfiguration) {
            this.defaultEncryptionConfiguration = defaultEncryptionConfiguration;
            return this;
        }

        @Override
        public Builder setDefaultPartitionExpirationMs(Long defaultPartitionExpirationMs) {
            this.defaultPartitionExpirationMs = defaultPartitionExpirationMs;
            return this;
        }

        @Override
        public Builder setDefaultCollation(String defaultCollation) {
            this.defaultCollation = defaultCollation;
            return this;
        }

        @Override
        public Builder setExternalDatasetReference(ExternalDatasetReference externalDatasetReference) {
            this.externalDatasetReference = externalDatasetReference;
            return this;
        }

        @Override
        public Builder setStorageBillingModel(String storageBillingModel) {
            this.storageBillingModel = storageBillingModel;
            return this;
        }

        @Override
        public Builder setMaxTimeTravelHours(Long maxTimeTravelHours) {
            this.maxTimeTravelHours = maxTimeTravelHours;
            return this;
        }

        @Override
        public Builder setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = Annotations.fromUser(resourceTags);
            return this;
        }

        @Override
        public DatasetInfo build() {
            return new DatasetInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setDatasetId(DatasetId var1);

        public abstract Builder setAcl(List<Acl> var1);

        abstract Builder setCreationTime(Long var1);

        public abstract Builder setDefaultTableLifetime(Long var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setEtag(String var1);

        public abstract Builder setFriendlyName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setLastModified(Long var1);

        public abstract Builder setLocation(String var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setLabels(Map<String, String> var1);

        public abstract Builder setExternalDatasetReference(ExternalDatasetReference var1);

        public abstract Builder setStorageBillingModel(String var1);

        public abstract Builder setMaxTimeTravelHours(Long var1);

        public abstract Builder setDefaultEncryptionConfiguration(EncryptionConfiguration var1);

        public abstract Builder setDefaultPartitionExpirationMs(Long var1);

        public abstract Builder setDefaultCollation(String var1);

        public abstract Builder setResourceTags(Map<String, String> var1);

        public abstract DatasetInfo build();
    }
}

