/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.StreamCombiningIterator;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadRowsHelper
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ReadRowsHelper.class);
    private final Options options;
    private final Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer;
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final List<ReadRowsRequest.Builder> requests;
    private StreamCombiningIterator incomingStream;

    public ReadRowsHelper(BigQueryClientFactory bigQueryReadClientFactory, ReadRowsRequest.Builder request, Options options, Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer) {
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.requests = ImmutableList.of(Objects.requireNonNull(request, "request cannot be null"));
        this.options = options;
        this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
    }

    public ReadRowsHelper(BigQueryClientFactory bigQueryReadClientFactory, List<ReadRowsRequest.Builder> requests, Options options) {
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.requests = Objects.requireNonNull(requests, "request cannot be null");
        this.options = options;
        this.bigQueryStorageReadRowsTracer = Optional.empty();
    }

    public Iterator<ReadRowsResponse> readRows() {
        if (this.requests.isEmpty()) {
            return Collections.emptyIterator();
        }
        this.bigQueryStorageReadRowsTracer.ifPresent(tracer -> tracer.startStream());
        BigQueryReadClient client = this.bigQueryReadClientFactory.getBigQueryReadClient();
        this.incomingStream = new StreamCombiningIterator(client, this.requests, this.options.prebufferResponses, this.options.getMaxReadRowsRetries());
        return this.incomingStream;
    }

    public String toString() {
        return this.requests.toString();
    }

    @Override
    public void close() {
        if (this.incomingStream != null) {
            try {
                this.incomingStream.cancel();
            }
            catch (Exception e) {
                logger.debug("Error on cancel call", (Throwable)e);
            }
            this.incomingStream = null;
        }
    }

    public static final class Options
    implements Serializable {
        private final int maxReadRowsRetries;
        private final String nullableEndpoint;
        private final int backgroundParsingThreads;
        private final int prebufferResponses;

        public Options(int maxReadRowsRetries, Optional<String> endpoint, int backgroundParsingThreads, int prebufferResponses) {
            this.maxReadRowsRetries = maxReadRowsRetries;
            this.nullableEndpoint = endpoint.orElse(null);
            this.backgroundParsingThreads = backgroundParsingThreads;
            this.prebufferResponses = prebufferResponses;
        }

        public int getMaxReadRowsRetries() {
            return this.maxReadRowsRetries;
        }

        public Optional<String> getEndpoint() {
            return Optional.ofNullable(this.nullableEndpoint);
        }

        public int numBackgroundThreads() {
            return this.backgroundParsingThreads;
        }

        public int numPrebufferResponses() {
            return this.prebufferResponses;
        }
    }
}

