/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.LoggingBigQueryTracerFactory;
import com.google.cloud.spark.bigquery.BigQueryRelation;
import com.google.cloud.spark.bigquery.BigQueryStreamingSink;
import com.google.cloud.spark.bigquery.BigQueryUtilScala$;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.GuiceInjectorCreator;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.write.CreatableRelationProviderHelper;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\u0007\u000f\u0001eA\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u0006\u0003\u0002!\t\u0001\u0019\u0005\u0006\u000b\u0002!\t%\u0019\u0005\u0006Y\u0002!\t%\u001c\u0005\b\u0003+\u0001A\u0011CA\f\u0011%\tY\u0003AI\u0001\n#\ti\u0003\u0003\u0004F\u0001\u0011\u0005\u00131\t\u0005\b\u0003g\u0002A\u0011AA;\u0011%\t\u0019\tAI\u0001\n\u0003\ti\u0003C\u0004\u0002\u0006\u0002!\t%a\"\u00031\tKw-U;fef\u0014V\r\\1uS>t\u0007K]8wS\u0012,'O\u0003\u0002\u0010!\u0005A!-[4rk\u0016\u0014\u0018P\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0006G2|W\u000f\u001a\u0006\u0003+Y\taaZ8pO2,'\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u000f\u0001Q\u0002%\f\u00194mA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!I\u0016\u000e\u0003\tR!a\t\u0013\u0002\u000fM|WO]2fg*\u0011QEJ\u0001\u0004gFd'BA\t(\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\n\u00051\u0012#\u0001\u0005*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\tc&\u0003\u00020E\tI2I]3bi\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\t\u0013'\u0003\u00023E\t12k\u00195f[\u0006\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\"i%\u0011QG\t\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002\"o%\u0011\u0001H\t\u0002\u0013'R\u0014X-Y7TS:\\\u0007K]8wS\u0012,'/A\fhKR<U/[2f\u0013:TWm\u0019;pe\u000e\u0013X-\u0019;peB\u00191dO\u001f\n\u0005qb\"!\u0003$v]\u000e$\u0018n\u001c81!\tqt(D\u0001\u000f\u0013\t\u0001eB\u0001\u000bHk&\u001cW-\u00138kK\u000e$xN]\"sK\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r#\u0005C\u0001 \u0001\u0011\u0015I$\u00011\u0001;\u00039\u0019'/Z1uKJ+G.\u0019;j_:$2a\u0012&Q!\t\t\u0003*\u0003\u0002JE\ta!)Y:f%\u0016d\u0017\r^5p]\")1j\u0001a\u0001\u0019\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u00055sU\"\u0001\u0013\n\u0005=##AC*R\u0019\u000e{g\u000e^3yi\")\u0011k\u0001a\u0001%\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\tMSV,\u0018\b\u0003)b\u0003\"!\u0016\u000f\u000e\u0003YS!a\u0016\r\u0002\rq\u0012xn\u001c;?\u0013\tIF$\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u00131!T1q\u0015\tIF\u0004\u0005\u0002T=&\u0011q\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u0015\u0003\r#Ba\u00122dI\")1*\u0002a\u0001\u0019\")\u0011+\u0002a\u0001%\")Q-\u0002a\u0001M\u000611o\u00195f[\u0006\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u0013\u0002\u000bQL\b/Z:\n\u0005-D'AC*ueV\u001cG\u000fV=qK\u0006Q1M]3bi\u0016\u001c\u0016N\\6\u0015\r94x\u000f_A\u0004!\tyG/D\u0001q\u0015\t\t(/A\u0005tiJ,\u0017-\\5oO*\u00111\u000fJ\u0001\nKb,7-\u001e;j_:L!!\u001e9\u0003\tMKgn\u001b\u0005\u0006\u0017\u001a\u0001\r\u0001\u0014\u0005\u0006#\u001a\u0001\rA\u0015\u0005\u0006s\u001a\u0001\rA_\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u0004Ba_A\u0001;:\u0011AP \b\u0003+vL\u0011!H\u0005\u0003\u007fr\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0005\u0015!aA*fc*\u0011q\u0010\b\u0005\b\u0003\u00131\u0001\u0019AA\u0006\u0003)yW\u000f\u001e9vi6{G-\u001a\t\u0005\u0003\u001b\t\t\"\u0004\u0002\u0002\u0010)\u0011\u0011\u000fJ\u0005\u0005\u0003'\tyA\u0001\u0006PkR\u0004X\u000f^'pI\u0016\fac\u0019:fCR,'+\u001a7bi&|g.\u00138uKJt\u0017\r\u001c\u000b\t\u00033\ty\"!\t\u0002$A\u0019a(a\u0007\n\u0007\u0005uaB\u0001\tCS\u001e\fV/\u001a:z%\u0016d\u0017\r^5p]\")1j\u0002a\u0001\u0019\")\u0011k\u0002a\u0001%\"AQm\u0002I\u0001\u0002\u0004\t)\u0003\u0005\u0003\u001c\u0003O1\u0017bAA\u00159\t1q\n\u001d;j_:\f\u0001e\u0019:fCR,'+\u001a7bi&|g.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0006\u0016\u0005\u0003K\t\td\u000b\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C;oG\",7m[3e\u0015\r\ti\u0004H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA!\u0003o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)%9\u0015QIA$\u0003#\n\u0019\u0006C\u0003L\u0013\u0001\u0007A\nC\u0004\u0002J%\u0001\r!a\u0013\u0002\t5|G-\u001a\t\u0004\u001b\u00065\u0013bAA(I\tA1+\u0019<f\u001b>$W\rC\u0003R\u0013\u0001\u0007!\u000bC\u0004\u0002V%\u0001\r!a\u0016\u0002\t\u0011\fG/\u0019\t\u0005\u00033\niG\u0004\u0003\u0002\\\u0005-d\u0002BA/\u0003SrA!a\u0018\u0002h9!\u0011\u0011MA3\u001d\r)\u00161M\u0005\u0002U%\u0011\u0001&K\u0005\u0003#\u001dJ!!\n\u0014\n\u0005}$\u0013\u0002BA8\u0003c\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005}$\u0013!G2sK\u0006$Xm\u00159be.\u0014\u0015nZ)vKJL8i\u001c8gS\u001e$\u0002\"a\u001e\u0002~\u0005}\u0014\u0011\u0011\t\u0004}\u0005e\u0014bAA>\u001d\t\u00192\u000b]1sW\nKw-U;fef\u001cuN\u001c4jO\")1J\u0003a\u0001\u0019\")\u0011K\u0003a\u0001%\"AQM\u0003I\u0001\u0002\u0004\t)#A\u0012de\u0016\fG/Z*qCJ\\')[4Rk\u0016\u0014\u0018pQ8oM&<G\u0005Z3gCVdG\u000fJ\u001a\u0002\u0013MDwN\u001d;OC6,G#A/")
public class BigQueryRelationProvider
implements RelationProvider,
CreatableRelationProvider,
SchemaRelationProvider,
DataSourceRegister,
StreamSinkProvider {
    private final Function0<GuiceInjectorCreator> getGuiceInjectorCreator;

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelationInternal(sqlContext, parameters, this.createRelationInternal$default$3());
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        return this.createRelationInternal(sqlContext, parameters, (Option<StructType>)new Some((Object)schema));
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        GuiceInjectorCreator qual$1 = (GuiceInjectorCreator)this.getGuiceInjectorCreator.apply();
        SQLContext x$1 = sqlContext;
        Map<String, String> x$2 = parameters;
        Option<StructType> x$3 = qual$1.createGuiceInjector$default$3();
        Injector injector = qual$1.createGuiceInjector(x$1, x$2, x$3);
        SparkBigQueryConfig opts = injector.getInstance(SparkBigQueryConfig.class);
        BigQueryClient bigQueryClient = injector.getInstance(BigQueryClient.class);
        return new BigQueryStreamingSink(sqlContext, parameters, partitionColumns, outputMode, opts, bigQueryClient);
    }

    public BigQueryRelation createRelationInternal(SQLContext sqlContext, Map<String, String> parameters, Option<StructType> schema) {
        DirectBigQueryRelation directBigQueryRelation;
        boolean bl;
        Injector injector = ((GuiceInjectorCreator)this.getGuiceInjectorCreator.apply()).createGuiceInjector(sqlContext, parameters, schema);
        SparkBigQueryConfig opts = injector.getInstance(SparkBigQueryConfig.class);
        BigQueryClient bigQueryClient = injector.getInstance(BigQueryClient.class);
        TableInfo tableInfo = bigQueryClient.getReadTable(opts.toReadTableOptions());
        String tableName = BigQueryUtil.friendlyTableName(opts.getTableId());
        BigQueryClientFactory bigQueryReadClientFactory = injector.getInstance(BigQueryClientFactory.class);
        LoggingBigQueryTracerFactory bigQueryTracerFactory = injector.getInstance(LoggingBigQueryTracerFactory.class);
        TableInfo table = (TableInfo)Option$.MODULE$.apply((Object)tableInfo).getOrElse((Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(16).append("Table ").append(tableName).append(" not found").toString()));
        TableDefinition.Type type = ((TableDefinition)table.getDefinition()).getType();
        TableDefinition.Type type2 = TableDefinition.Type.TABLE;
        TableDefinition.Type type3 = type;
        if (!(type2 != null ? !((Object)type2).equals(type3) : type3 != null)) {
            bl = true;
        } else {
            TableDefinition.Type type4 = TableDefinition.Type.EXTERNAL;
            TableDefinition.Type type5 = type;
            if (!(type4 != null ? !((Object)type4).equals(type5) : type5 != null)) {
                bl = true;
            } else {
                TableDefinition.Type type6 = TableDefinition.Type.SNAPSHOT;
                TableDefinition.Type type7 = type;
                bl = !(type6 != null ? !((Object)type6).equals(type7) : type7 != null);
            }
        }
        if (bl) {
            directBigQueryRelation = new DirectBigQueryRelation(opts, table, bigQueryClient, bigQueryReadClientFactory, bigQueryTracerFactory, sqlContext);
        } else {
            boolean bl2;
            TableDefinition.Type type8 = TableDefinition.Type.VIEW;
            TableDefinition.Type type9 = type;
            if (!(type8 != null ? !((Object)type8).equals(type9) : type9 != null)) {
                bl2 = true;
            } else {
                TableDefinition.Type type10 = TableDefinition.Type.MATERIALIZED_VIEW;
                TableDefinition.Type type11 = type;
                bl2 = !(type10 != null ? !((Object)type10).equals(type11) : type11 != null);
            }
            if (bl2) {
                if (!opts.isViewsEnabled()) {
                    throw package$.MODULE$.error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Views were not enabled. You can enable views by setting\n             |'viewsEnabled' to true.\n             |Notice additional cost may occur.")).replace('\n', ' '));
                }
                directBigQueryRelation = new DirectBigQueryRelation(opts, table, bigQueryClient, bigQueryReadClientFactory, bigQueryTracerFactory, sqlContext);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(47).append("The type of table ").append(tableName).append(" is currently not supported: ").append(type).toString());
            }
        }
        return directBigQueryRelation;
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        ImmutableMap<String, String> customDefaults = ImmutableMap.of();
        return new CreatableRelationProviderHelper().createRelation(sqlContext, mode, parameters, data, customDefaults);
    }

    public Option<StructType> createRelationInternal$default$3() {
        return None$.MODULE$;
    }

    public SparkBigQueryConfig createSparkBigQueryConfig(SQLContext sqlContext, Map<String, String> parameters, Option<StructType> schema) {
        return SparkBigQueryUtil.createSparkBigQueryConfig(sqlContext, parameters, schema, DataSourceVersion.V1);
    }

    public Option<StructType> createSparkBigQueryConfig$default$3() {
        return None$.MODULE$;
    }

    public String shortName() {
        return "bigquery";
    }

    public BigQueryRelationProvider(Function0<GuiceInjectorCreator> getGuiceInjectorCreator) {
        this.getGuiceInjectorCreator = getGuiceInjectorCreator;
        BigQueryUtilScala$.MODULE$.validateScalaVersionCompatibility();
    }

    public BigQueryRelationProvider() {
        this((Function0<GuiceInjectorCreator>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final GuiceInjectorCreator apply() {
                return new GuiceInjectorCreator(null){

                    public Injector createGuiceInjector(SQLContext sqlContext, Map<String, String> parameters, Option<StructType> schema) {
                        return GuiceInjectorCreator.createGuiceInjector$(this, sqlContext, parameters, schema);
                    }

                    public Option<StructType> createGuiceInjector$default$3() {
                        return GuiceInjectorCreator.createGuiceInjector$default$3$(this);
                    }
                    {
                        GuiceInjectorCreator.$init$(this);
                    }
                };
            }
        });
    }
}

