/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonClientCallImpl;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private final Executor executor;
    private final boolean usingDefaultExecutor;
    private final String endpoint;
    private final HttpTransport httpTransport;
    private final ScheduledExecutorService deadlineScheduledExecutorService;
    private boolean isTransportShutdown;

    protected ManagedHttpJsonChannel() {
        this(null, true, null, null);
    }

    private ManagedHttpJsonChannel(Executor executor, boolean usingDefaultExecutor, String endpoint, @Nullable HttpTransport httpTransport) {
        this.executor = executor;
        this.usingDefaultExecutor = usingDefaultExecutor;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
        this.deadlineScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpJsonCallOptions callOptions) {
        return new HttpJsonClientCallImpl<RequestT, ResponseT>(methodDescriptor, this.endpoint, callOptions, this.httpTransport, this.executor, this.deadlineScheduledExecutorService);
    }

    @VisibleForTesting
    Executor getExecutor() {
        return this.executor;
    }

    @Override
    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            if (this.shouldManageExecutor()) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.deadlineScheduledExecutorService.shutdown();
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isShutdown() {
        boolean isShutdown;
        boolean bl = isShutdown = this.isTransportShutdown && this.deadlineScheduledExecutorService.isShutdown();
        if (this.shouldManageExecutor()) {
            isShutdown = isShutdown && ((ExecutorService)this.executor).isShutdown();
        }
        return isShutdown;
    }

    @Override
    public boolean isTerminated() {
        boolean isTerminated = this.deadlineScheduledExecutorService.isTerminated();
        if (this.shouldManageExecutor()) {
            isTerminated = isTerminated && ((ExecutorService)this.executor).isTerminated();
        }
        return isTerminated;
    }

    @Override
    public void shutdownNow() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            if (this.shouldManageExecutor()) {
                ((ExecutorService)this.executor).shutdownNow();
            }
            this.deadlineScheduledExecutorService.shutdownNow();
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        boolean terminated;
        long endTimeNanos = System.nanoTime() + unit.toNanos(duration);
        long awaitTimeNanos = endTimeNanos - System.nanoTime();
        if (awaitTimeNanos <= 0L) {
            return false;
        }
        if (this.usingDefaultExecutor && this.executor instanceof ExecutorService && !(terminated = ((ExecutorService)this.executor).awaitTermination(awaitTimeNanos, unit))) {
            return false;
        }
        awaitTimeNanos = endTimeNanos - System.nanoTime();
        return this.deadlineScheduledExecutorService.awaitTermination(awaitTimeNanos, unit);
    }

    private boolean shouldManageExecutor() {
        return this.usingDefaultExecutor && this.executor instanceof ExecutorService;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private HttpTransport httpTransport;
        private boolean usingDefaultExecutor = false;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull(this.endpoint);
            if (this.executor == null) {
                this.executor = InstantiatingExecutorProvider.newIOBuilder().build().getExecutor();
                this.usingDefaultExecutor = true;
            }
            return new ManagedHttpJsonChannel(this.executor, this.usingDefaultExecutor, this.endpoint, this.httpTransport == null ? new NetHttpTransport() : this.httpTransport);
        }
    }
}

