/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.AbstractJdbcResultSet;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQueryResultStats;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ConnectionImpl;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FieldList;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FieldValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Schema;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.JsonStringArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.Text;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BigQueryResultImpl<T>
implements BigQueryResult<T> {
    private static final String NULL_CURSOR_MSG = "Error occurred while reading the cursor. This could happen if getters are called after we are done reading all the records";
    private final Schema schema;
    private final long totalRows;
    private final BlockingQueue<T> buffer;
    private T cursor;
    private final BigQueryResultSet underlyingResultSet;
    private final BigQueryResultStats bigQueryResultStats;
    private final FieldList schemaFieldList;

    public BigQueryResultImpl(Schema schema, long totalRows, BlockingQueue<T> buffer, BigQueryResultStats bigQueryResultStats) {
        this.schema = schema;
        this.totalRows = totalRows;
        this.buffer = buffer;
        this.underlyingResultSet = new BigQueryResultSet();
        this.bigQueryResultStats = bigQueryResultStats;
        this.schemaFieldList = schema.getFields();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public long getTotalRows() {
        return this.totalRows;
    }

    @Override
    public ResultSet getResultSet() {
        return this.underlyingResultSet;
    }

    @Override
    public BigQueryResultStats getBigQueryResultStats() {
        return this.bigQueryResultStats;
    }

    private class BigQueryResultSet
    extends AbstractJdbcResultSet {
        private boolean hasReachedEnd = false;

        private BigQueryResultSet() {
        }

        @Override
        public boolean next() throws SQLException {
            if (BigQueryResultImpl.this.buffer == null) {
                return false;
            }
            if (this.hasReachedEnd) {
                return false;
            }
            try {
                BigQueryResultImpl.this.cursor = BigQueryResultImpl.this.buffer.take();
                if (this.isEndOfStream(BigQueryResultImpl.this.cursor)) {
                    BigQueryResultImpl.this.cursor = null;
                    this.hasReachedEnd = true;
                    return false;
                }
                if (BigQueryResultImpl.this.cursor instanceof Row) {
                    Row curTup = (Row)BigQueryResultImpl.this.cursor;
                    if (curTup.isLast()) {
                        BigQueryResultImpl.this.cursor = null;
                        this.hasReachedEnd = true;
                        return false;
                    }
                    return true;
                }
                if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                    return true;
                }
                throw new BigQuerySQLException("Could not process the current row");
            }
            catch (InterruptedException e) {
                throw new SQLException("Error occurred while advancing the cursor. This could happen when connection is closed while we call the next method");
            }
        }

        private boolean isEndOfStream(T cursor) {
            return cursor instanceof ConnectionImpl.EndOfFieldValueList;
        }

        @Override
        public Object getObject(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? null : fieldValue.getValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            return curRow.get(fieldName);
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : fieldValue.getValue();
            }
            return this.getObject(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public String getString(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    return null;
                }
                if (fieldValue.getAttribute().equals((Object)FieldValue.Attribute.REPEATED)) {
                    return fieldValue.getValue().toString();
                }
                return fieldValue.getStringValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object currentVal = curRow.get(fieldName);
            if (currentVal == null) {
                return null;
            }
            if (currentVal instanceof JsonStringArrayList) {
                JsonStringArrayList jsnAry = (JsonStringArrayList)currentVal;
                return jsnAry.toString();
            }
            if (currentVal instanceof LocalDateTime) {
                LocalDateTime dateTime = (LocalDateTime)currentVal;
                return dateTime.toString();
            }
            Text textVal = (Text)currentVal;
            return textVal.toString();
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : fieldValue.getStringValue();
            }
            return this.getString(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public int getInt(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return 0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? 0 : fieldValue.getNumericValue().intValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object curVal = curRow.get(fieldName);
            if (curVal == null) {
                return 0;
            }
            if (curVal instanceof Text) {
                return Integer.parseInt(((Text)curVal).toString());
            }
            if (curVal instanceof Long) {
                return ((Long)curVal).intValue();
            }
            return ((BigDecimal)curVal).intValue();
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? 0 : fieldValue.getNumericValue().intValue();
            }
            return this.getInt(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public long getLong(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? 0L : fieldValue.getNumericValue().longValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object curVal = curRow.get(fieldName);
            if (curVal == null) {
                return 0L;
            }
            return ((Number)curVal).longValue();
        }

        @Override
        public long getLong(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0L;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? 0L : fieldValue.getNumericValue().longValue();
            }
            return this.getInt(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public double getDouble(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? 0.0 : fieldValue.getNumericValue().doubleValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object curVal = curRow.get(fieldName);
            return curVal == null ? 0.0 : new BigDecimal(curVal.toString()).doubleValue();
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0.0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? 0.0 : fieldValue.getNumericValue().doubleValue();
            }
            return this.getDouble(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public BigDecimal getBigDecimal(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? null : BigDecimal.valueOf(fieldValue.getNumericValue().doubleValue());
            }
            return BigDecimal.valueOf(this.getDouble(fieldName));
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : BigDecimal.valueOf(fieldValue.getNumericValue().doubleValue());
            }
            return this.getBigDecimal(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public boolean getBoolean(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue.getValue() != null && fieldValue.getBooleanValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object curVal = curRow.get(fieldName);
            return curVal != null && (Boolean)curVal != false;
        }

        @Override
        public boolean getBoolean(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue.getValue() != null && fieldValue.getBooleanValue();
            }
            return this.getBoolean(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public byte[] getBytes(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? null : fieldValue.getBytesValue();
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object curVal = curRow.get(fieldName);
            return curVal == null ? null : (byte[])curVal;
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : fieldValue.getBytesValue();
            }
            return this.getBytes(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public Timestamp getTimestamp(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? null : new Timestamp(fieldValue.getTimestampValue() / 1000L);
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object timeStampVal = curRow.get(fieldName);
            return timeStampVal == null ? null : new Timestamp((Long)timeStampVal / 1000L);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : new Timestamp(fieldValue.getTimestampValue() / 1000L);
            }
            return this.getTimestamp(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public Time getTime(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return this.getTimeFromFieldVal(fieldValue);
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object timeStampObj = curRow.get(fieldName);
            return timeStampObj == null ? null : new Time((Long)timeStampObj / 1000L);
        }

        private int getTimeZoneOffset() {
            TimeZone timeZone = TimeZone.getTimeZone(ZoneId.systemDefault());
            return timeZone.getOffset(new java.util.Date().getTime());
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return this.getTimeFromFieldVal(fieldValue);
            }
            return this.getTime(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        private Time getTimeFromFieldVal(FieldValue fieldValue) throws SQLException {
            if (fieldValue.getValue() != null) {
                String strTime = fieldValue.getStringValue();
                String[] timeSplt = strTime.split(":");
                if (timeSplt.length != 3) {
                    throw new SQLException("Can not parse the value " + strTime + " to java.sql.Time");
                }
                int hr = Integer.parseInt(timeSplt[0]);
                int min2 = Integer.parseInt(timeSplt[1]);
                int sec = 0;
                int nanoSec = 0;
                if (timeSplt[2].contains(".")) {
                    String[] secSplt = timeSplt[2].split("\\.");
                    sec = Integer.parseInt(secSplt[0]);
                    nanoSec = Integer.parseInt(secSplt[1]);
                } else {
                    sec = Integer.parseInt(timeSplt[2]);
                }
                return Time.valueOf(LocalTime.of(hr, min2, sec, nanoSec));
            }
            return null;
        }

        @Override
        public Date getDate(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                return fieldValue == null || fieldValue.getValue() == null ? null : Date.valueOf(fieldValue.getStringValue());
            }
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            Object dateObj = curRow.get(fieldName);
            if (dateObj == null) {
                return null;
            }
            Integer dateInt = (Integer)dateObj;
            long dateInMillis = TimeUnit.DAYS.toMillis(dateInt.intValue());
            return new Date(dateInMillis);
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                return fieldValue == null || fieldValue.getValue() == null ? null : Date.valueOf(fieldValue.getStringValue());
            }
            return this.getDate(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }
    }

    static class Row {
        private Map<String, Object> value;
        private boolean isLast;

        public Row(Map<String, Object> value) {
            this.value = value;
        }

        public Row(Map<String, Object> value, boolean isLast) {
            this.value = value;
            this.isLast = isLast;
        }

        public Map<String, Object> getValue() {
            return this.value;
        }

        public boolean isLast() {
            return this.isLast;
        }

        public boolean hasField(String fieldName) {
            return this.value.containsKey(fieldName);
        }

        public Object get(String fieldName) {
            return this.value.get(fieldName);
        }
    }
}

