/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.alts;

import com.google.cloud.spark.bigquery.repackaged.io.grpc.Attributes;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ExperimentalApi;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ServerCall;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.AltsContext;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.internal.AltsInternalContext;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.internal.AltsProtocolNegotiator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7864")
public final class AltsContextUtil {
    private AltsContextUtil() {
    }

    public static AltsContext createFrom(ServerCall<?, ?> call) {
        Object authContext = call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        if (!(authContext instanceof AltsInternalContext)) {
            throw new IllegalArgumentException("No ALTS context information found");
        }
        return new AltsContext((AltsInternalContext)authContext);
    }

    public static boolean check(ServerCall<?, ?> call) {
        return AltsContextUtil.check(call.getAttributes());
    }

    public static boolean check(Attributes attributes) {
        Object authContext = attributes.get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        return authContext instanceof AltsInternalContext;
    }
}

