/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.alts;

import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ChannelCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CompositeChannelCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.FailingCallCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.InternalCheckGcpEnvironment;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.internal.SharedResourcePool;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLException;

public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create((InternalProtocolNegotiator.ClientFactory)ComputeEngineChannelCredentials.createClientFactory());
        CallCredentials callCredentials = InternalCheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from(ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

