/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.ConfigPathProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.DefaultConfigPathProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.Environment;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageClient;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageClientException;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageClientUtils;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageConfig;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.circuitBreaker.CircuitBreakerFactory;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.metrics.MicrometerProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.transports.NoopTransport;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.transports.Transport;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.transports.TransportFactory;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;

public final class Clients {
    private Clients() {
    }

    public static OpenLineageClient newClient() {
        return Clients.newClient(new DefaultConfigPathProvider());
    }

    public static OpenLineageClient newClient(ConfigPathProvider configPathProvider) {
        OpenLineageConfig openLineageConfig;
        if (Clients.isDisabled()) {
            return OpenLineageClient.builder().transport((Transport)new NoopTransport()).build();
        }
        try {
            openLineageConfig = OpenLineageClientUtils.loadOpenLineageConfigYaml(configPathProvider, new TypeReference<OpenLineageConfig>(){});
        }
        catch (OpenLineageClientException e) {
            openLineageConfig = OpenLineageClientUtils.loadOpenLineageConfigFromEnvVars(new TypeReference<OpenLineageConfig>(){});
        }
        return Clients.newClient(openLineageConfig);
    }

    public static OpenLineageClient newClient(OpenLineageConfig openLineageConfig) {
        if (Clients.isDisabled()) {
            return OpenLineageClient.builder().transport((Transport)new NoopTransport()).build();
        }
        TransportFactory factory = new TransportFactory(openLineageConfig.getTransportConfig());
        Transport transport = factory.build();
        OpenLineageClient.Builder builder = OpenLineageClient.builder();
        if (openLineageConfig.getFacetsConfig() != null) {
            builder.disableFacets(openLineageConfig.getFacetsConfig().getEffectiveDisabledFacets());
        }
        Optional.ofNullable(openLineageConfig.getCircuitBreaker()).map(CircuitBreakerFactory::new).ifPresent(f -> builder.circuitBreaker(f.build()));
        Optional.ofNullable(openLineageConfig.getMetricsConfig()).map(MicrometerProvider::addMeterRegistryFromConfig).ifPresent(f -> builder.meterRegistry((MeterRegistry)f));
        return builder.transport(transport).build();
    }

    private static boolean isDisabled() {
        String disabled = Environment.getEnvironmentVariable("OPENLINEAGE_DISABLED");
        return Boolean.parseBoolean(disabled);
    }
}

