/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OpenLineage {
    private final URI producer;

    public OpenLineage(URI producer) {
        this.producer = producer;
    }

    public SchemaDatasetFacetFields newSchemaDatasetFacetFields(String name, String type, String description, List<SchemaDatasetFacetFields> fields) {
        return new SchemaDatasetFacetFields(name, type, description, fields);
    }

    public SchemaDatasetFacetFieldsBuilder newSchemaDatasetFacetFieldsBuilder() {
        return new SchemaDatasetFacetFieldsBuilder();
    }

    public ParentRunFacet newParentRunFacet(ParentRunFacetRun run, ParentRunFacetJob job) {
        return new ParentRunFacet(this.producer, run, job);
    }

    public ParentRunFacetBuilder newParentRunFacetBuilder() {
        return new ParentRunFacetBuilder();
    }

    public OutputStatisticsOutputDatasetFacet newOutputStatisticsOutputDatasetFacet(Long rowCount, Long size, Long fileCount) {
        return new OutputStatisticsOutputDatasetFacet(this.producer, rowCount, size, fileCount);
    }

    public OutputStatisticsOutputDatasetFacetBuilder newOutputStatisticsOutputDatasetFacetBuilder() {
        return new OutputStatisticsOutputDatasetFacetBuilder();
    }

    public ExtractionErrorRunFacetErrors newExtractionErrorRunFacetErrors(String errorMessage, String stackTrace, String task, Long taskNumber) {
        return new ExtractionErrorRunFacetErrors(errorMessage, stackTrace, task, taskNumber);
    }

    public ExtractionErrorRunFacetErrorsBuilder newExtractionErrorRunFacetErrorsBuilder() {
        return new ExtractionErrorRunFacetErrorsBuilder();
    }

    public JobTypeJobFacet newJobTypeJobFacet(String processingType, String integration, String jobType) {
        return new JobTypeJobFacet(this.producer, processingType, integration, jobType);
    }

    public JobTypeJobFacetBuilder newJobTypeJobFacetBuilder() {
        return new JobTypeJobFacetBuilder();
    }

    public Run newRun(UUID runId, RunFacets facets) {
        return new Run(runId, facets);
    }

    public RunBuilder newRunBuilder() {
        return new RunBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder();
    }

    public ExternalQueryRunFacet newExternalQueryRunFacet(String externalQueryId, String source) {
        return new ExternalQueryRunFacet(this.producer, externalQueryId, source);
    }

    public ExternalQueryRunFacetBuilder newExternalQueryRunFacetBuilder() {
        return new ExternalQueryRunFacetBuilder();
    }

    public OutputDatasetOutputFacets newOutputDatasetOutputFacets(IcebergCommitReportOutputDatasetFacet iceberg_scan_report, OutputStatisticsOutputDatasetFacet outputStatistics) {
        return new OutputDatasetOutputFacets(iceberg_scan_report, outputStatistics);
    }

    public OutputDatasetOutputFacetsBuilder newOutputDatasetOutputFacetsBuilder() {
        return new OutputDatasetOutputFacetsBuilder();
    }

    public NominalTimeRunFacet newNominalTimeRunFacet(ZonedDateTime nominalStartTime, ZonedDateTime nominalEndTime) {
        return new NominalTimeRunFacet(this.producer, nominalStartTime, nominalEndTime);
    }

    public NominalTimeRunFacetBuilder newNominalTimeRunFacetBuilder() {
        return new NominalTimeRunFacetBuilder();
    }

    public InputDatasetFacet newInputDatasetFacet() {
        return new DefaultInputDatasetFacet(this.producer);
    }

    public ColumnLineageDatasetFacetFieldsAdditional newColumnLineageDatasetFacetFieldsAdditional(List<InputField> inputFields, String transformationDescription, String transformationType) {
        return new ColumnLineageDatasetFacetFieldsAdditional(inputFields, transformationDescription, transformationType);
    }

    public ColumnLineageDatasetFacetFieldsAdditionalBuilder newColumnLineageDatasetFacetFieldsAdditionalBuilder() {
        return new ColumnLineageDatasetFacetFieldsAdditionalBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional newDataQualityMetricsInputDatasetFacetColumnMetricsAdditional(Long nullCount, Long distinctCount, Double sum, Double count, Double min2, Double max, DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(nullCount, distinctCount, sum, count, min2, max, quantiles);
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder();
    }

    public DataQualityMetricsInputDatasetFacet newDataQualityMetricsInputDatasetFacet(Long rowCount, Long bytes, Long fileCount, DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
        return new DataQualityMetricsInputDatasetFacet(this.producer, rowCount, bytes, fileCount, columnMetrics);
    }

    public DataQualityMetricsInputDatasetFacetBuilder newDataQualityMetricsInputDatasetFacetBuilder() {
        return new DataQualityMetricsInputDatasetFacetBuilder();
    }

    public DocumentationJobFacet newDocumentationJobFacet(String description) {
        return new DocumentationJobFacet(this.producer, description);
    }

    public DocumentationJobFacetBuilder newDocumentationJobFacetBuilder() {
        return new DocumentationJobFacetBuilder();
    }

    public InputDatasetInputFacets newInputDatasetInputFacets(DataQualityAssertionsDatasetFacet dataQualityAssertions, InputStatisticsInputDatasetFacet inputStatistics, DataQualityMetricsInputDatasetFacet dataQualityMetrics, IcebergScanReportInputDatasetFacet iceberg_scan_report) {
        return new InputDatasetInputFacets(dataQualityAssertions, inputStatistics, dataQualityMetrics, iceberg_scan_report);
    }

    public InputDatasetInputFacetsBuilder newInputDatasetInputFacetsBuilder() {
        return new InputDatasetInputFacetsBuilder();
    }

    public SQLJobFacet newSQLJobFacet(String query) {
        return new SQLJobFacet(this.producer, query);
    }

    public SQLJobFacetBuilder newSQLJobFacetBuilder() {
        return new SQLJobFacetBuilder();
    }

    public OutputDataset newOutputDataset(String namespace, String name, DatasetFacets facets, OutputDatasetOutputFacets outputFacets) {
        return new OutputDataset(namespace, name, facets, outputFacets);
    }

    public OutputDatasetBuilder newOutputDatasetBuilder() {
        return new OutputDatasetBuilder();
    }

    public TagsDatasetFacetFields newTagsDatasetFacetFields(String key, String value, String source, String field) {
        return new TagsDatasetFacetFields(key, value, source, field);
    }

    public TagsDatasetFacetFieldsBuilder newTagsDatasetFacetFieldsBuilder() {
        return new TagsDatasetFacetFieldsBuilder();
    }

    public DocumentationDatasetFacet newDocumentationDatasetFacet(String description) {
        return new DocumentationDatasetFacet(this.producer, description);
    }

    public DocumentationDatasetFacetBuilder newDocumentationDatasetFacetBuilder() {
        return new DocumentationDatasetFacetBuilder();
    }

    public SourceCodeLocationJobFacet newSourceCodeLocationJobFacet(String type, URI url, String repoUrl, String path, String version, String tag, String branch) {
        return new SourceCodeLocationJobFacet(this.producer, type, url, repoUrl, path, version, tag, branch);
    }

    public SourceCodeLocationJobFacetBuilder newSourceCodeLocationJobFacetBuilder() {
        return new SourceCodeLocationJobFacetBuilder();
    }

    public IcebergScanReportInputDatasetFacet newIcebergScanReportInputDatasetFacet(Double snapshotId, String filter, Double schemaId, List<String> projectedFieldNames, IcebergScanReportInputDatasetFacetScanMetrics scanMetrics, IcebergScanReportInputDatasetFacetMetadata metadata) {
        return new IcebergScanReportInputDatasetFacet(this.producer, snapshotId, filter, schemaId, projectedFieldNames, scanMetrics, metadata);
    }

    public IcebergScanReportInputDatasetFacetBuilder newIcebergScanReportInputDatasetFacetBuilder() {
        return new IcebergScanReportInputDatasetFacetBuilder();
    }

    public DatasetTypeDatasetFacet newDatasetTypeDatasetFacet(String datasetType, String subType) {
        return new DatasetTypeDatasetFacet(this.producer, datasetType, subType);
    }

    public DatasetTypeDatasetFacetBuilder newDatasetTypeDatasetFacetBuilder() {
        return new DatasetTypeDatasetFacetBuilder();
    }

    public Job newJob(String namespace, String name, JobFacets facets) {
        return new Job(namespace, name, facets);
    }

    public JobBuilder newJobBuilder() {
        return new JobBuilder();
    }

    public DatasetVersionDatasetFacet newDatasetVersionDatasetFacet(String datasetVersion) {
        return new DatasetVersionDatasetFacet(this.producer, datasetVersion);
    }

    public DatasetVersionDatasetFacetBuilder newDatasetVersionDatasetFacetBuilder() {
        return new DatasetVersionDatasetFacetBuilder();
    }

    public SymlinksDatasetFacetIdentifiers newSymlinksDatasetFacetIdentifiers(String namespace, String name, String type) {
        return new SymlinksDatasetFacetIdentifiers(namespace, name, type);
    }

    public SymlinksDatasetFacetIdentifiersBuilder newSymlinksDatasetFacetIdentifiersBuilder() {
        return new SymlinksDatasetFacetIdentifiersBuilder();
    }

    public IcebergCommitReportOutputDatasetFacet newIcebergCommitReportOutputDatasetFacet(Double snapshotId, Double sequenceNumber, String operation, IcebergCommitReportOutputDatasetFacetCommitMetrics commitMetrics, IcebergCommitReportOutputDatasetFacetMetadata metadata) {
        return new IcebergCommitReportOutputDatasetFacet(this.producer, snapshotId, sequenceNumber, operation, commitMetrics, metadata);
    }

    public IcebergCommitReportOutputDatasetFacetBuilder newIcebergCommitReportOutputDatasetFacetBuilder() {
        return new IcebergCommitReportOutputDatasetFacetBuilder();
    }

    public TagsJobFacetFields newTagsJobFacetFields(String key, String value, String source) {
        return new TagsJobFacetFields(key, value, source);
    }

    public TagsJobFacetFieldsBuilder newTagsJobFacetFieldsBuilder() {
        return new TagsJobFacetFieldsBuilder();
    }

    public OutputDatasetFacet newOutputDatasetFacet() {
        return new DefaultOutputDatasetFacet(this.producer);
    }

    public StaticDataset newStaticDataset(String namespace, String name, DatasetFacets facets) {
        return new StaticDataset(namespace, name, facets);
    }

    public StaticDatasetBuilder newStaticDatasetBuilder() {
        return new StaticDatasetBuilder();
    }

    public TagsRunFacet newTagsRunFacet(List<TagsRunFacetFields> tags) {
        return new TagsRunFacet(this.producer, tags);
    }

    public TagsRunFacetBuilder newTagsRunFacetBuilder() {
        return new TagsRunFacetBuilder();
    }

    public LifecycleStateChangeDatasetFacet newLifecycleStateChangeDatasetFacet(LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange, LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
        return new LifecycleStateChangeDatasetFacet(this.producer, lifecycleStateChange, previousIdentifier);
    }

    public LifecycleStateChangeDatasetFacetBuilder newLifecycleStateChangeDatasetFacetBuilder() {
        return new LifecycleStateChangeDatasetFacetBuilder();
    }

    public RunEvent newRunEvent(ZonedDateTime eventTime, RunEvent.EventType eventType, Run run, Job job, List<InputDataset> inputs, List<OutputDataset> outputs) {
        return new RunEvent(eventTime, this.producer, eventType, run, job, inputs, outputs);
    }

    public RunEventBuilder newRunEventBuilder() {
        return new RunEventBuilder();
    }

    public IcebergCommitReportOutputDatasetFacetMetadata newIcebergCommitReportOutputDatasetFacetMetadata() {
        return new IcebergCommitReportOutputDatasetFacetMetadata();
    }

    public IcebergCommitReportOutputDatasetFacetMetadataBuilder newIcebergCommitReportOutputDatasetFacetMetadataBuilder() {
        return new IcebergCommitReportOutputDatasetFacetMetadataBuilder();
    }

    public TagsDatasetFacet newTagsDatasetFacet(List<TagsDatasetFacetFields> tags) {
        return new TagsDatasetFacet(this.producer, tags);
    }

    public TagsDatasetFacetBuilder newTagsDatasetFacetBuilder() {
        return new TagsDatasetFacetBuilder();
    }

    public RunFacet newRunFacet() {
        return new DefaultRunFacet(this.producer);
    }

    public OwnershipJobFacetOwners newOwnershipJobFacetOwners(String name, String type) {
        return new OwnershipJobFacetOwners(name, type);
    }

    public OwnershipJobFacetOwnersBuilder newOwnershipJobFacetOwnersBuilder() {
        return new OwnershipJobFacetOwnersBuilder();
    }

    public GcpLineageJobFacet newGcpLineageJobFacet(String displayName, GcpLineageJobFacetOrigin origin) {
        return new GcpLineageJobFacet(this.producer, displayName, origin);
    }

    public GcpLineageJobFacetBuilder newGcpLineageJobFacetBuilder() {
        return new GcpLineageJobFacetBuilder();
    }

    public JobEvent newJobEvent(ZonedDateTime eventTime, Job job, List<InputDataset> inputs, List<OutputDataset> outputs) {
        return new JobEvent(eventTime, this.producer, job, inputs, outputs);
    }

    public JobEventBuilder newJobEventBuilder() {
        return new JobEventBuilder();
    }

    public OwnershipDatasetFacetOwners newOwnershipDatasetFacetOwners(String name, String type) {
        return new OwnershipDatasetFacetOwners(name, type);
    }

    public OwnershipDatasetFacetOwnersBuilder newOwnershipDatasetFacetOwnersBuilder() {
        return new OwnershipDatasetFacetOwnersBuilder();
    }

    public ExtractionErrorRunFacet newExtractionErrorRunFacet(Long totalTasks, Long failedTasks, List<ExtractionErrorRunFacetErrors> errors) {
        return new ExtractionErrorRunFacet(this.producer, totalTasks, failedTasks, errors);
    }

    public ExtractionErrorRunFacetBuilder newExtractionErrorRunFacetBuilder() {
        return new ExtractionErrorRunFacetBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetrics newDataQualityMetricsInputDatasetFacetColumnMetrics() {
        return new DataQualityMetricsInputDatasetFacetColumnMetrics();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsBuilder();
    }

    public InputField newInputField(String namespace, String name, String field, List<InputFieldTransformations> transformations) {
        return new InputField(namespace, name, field, transformations);
    }

    public InputFieldBuilder newInputFieldBuilder() {
        return new InputFieldBuilder();
    }

    public InputStatisticsInputDatasetFacet newInputStatisticsInputDatasetFacet(Long rowCount, Long size, Long fileCount) {
        return new InputStatisticsInputDatasetFacet(this.producer, rowCount, size, fileCount);
    }

    public InputStatisticsInputDatasetFacetBuilder newInputStatisticsInputDatasetFacetBuilder() {
        return new InputStatisticsInputDatasetFacetBuilder();
    }

    public JobFacets newJobFacets(JobTypeJobFacet jobType, SourceCodeJobFacet sourceCode, GcpLineageJobFacet gcp_lineage, SQLJobFacet sql, OwnershipJobFacet ownership, SourceCodeLocationJobFacet sourceCodeLocation, TagsJobFacet tags, DocumentationJobFacet documentation) {
        return new JobFacets(jobType, sourceCode, gcp_lineage, sql, ownership, sourceCodeLocation, tags, documentation);
    }

    public JobFacetsBuilder newJobFacetsBuilder() {
        return new JobFacetsBuilder();
    }

    public IcebergCommitReportOutputDatasetFacetCommitMetrics newIcebergCommitReportOutputDatasetFacetCommitMetrics(Double totalDuration, Double attempts, Double addedDataFiles, Double removedDataFiles, Double totalDataFiles, Double addedDeleteFiles, Double addedEqualityDeleteFiles, Double addedPositionalDeleteFiles, Double addedDVs, Double removedDeleteFiles, Double removedEqualityDeleteFiles, Double removedPositionalDeleteFiles, Double removedDVs, Double totalDeleteFiles, Double addedRecords, Double removedRecords, Double totalRecords, Double addedFilesSizeInBytes, Double removedFilesSizeInBytes, Double totalFilesSizeInBytes, Double addedPositionalDeletes, Double removedPositionalDeletes, Double totalPositionalDeletes, Double addedEqualityDeletes, Double removedEqualityDeletes, Double totalEqualityDeletes) {
        return new IcebergCommitReportOutputDatasetFacetCommitMetrics(totalDuration, attempts, addedDataFiles, removedDataFiles, totalDataFiles, addedDeleteFiles, addedEqualityDeleteFiles, addedPositionalDeleteFiles, addedDVs, removedDeleteFiles, removedEqualityDeleteFiles, removedPositionalDeleteFiles, removedDVs, totalDeleteFiles, addedRecords, removedRecords, totalRecords, addedFilesSizeInBytes, removedFilesSizeInBytes, totalFilesSizeInBytes, addedPositionalDeletes, removedPositionalDeletes, totalPositionalDeletes, addedEqualityDeletes, removedEqualityDeletes, totalEqualityDeletes);
    }

    public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder newIcebergCommitReportOutputDatasetFacetCommitMetricsBuilder() {
        return new IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder();
    }

    public DatasetFacet newDatasetFacet() {
        return new DefaultDatasetFacet(this.producer, null);
    }

    public DatasetFacet newDeletedDatasetFacet() {
        return new DefaultDatasetFacet(this.producer, true);
    }

    public OwnershipDatasetFacet newOwnershipDatasetFacet(List<OwnershipDatasetFacetOwners> owners) {
        return new OwnershipDatasetFacet(this.producer, owners);
    }

    public OwnershipDatasetFacetBuilder newOwnershipDatasetFacetBuilder() {
        return new OwnershipDatasetFacetBuilder();
    }

    public EnvironmentVariablesRunFacet newEnvironmentVariablesRunFacet(List<EnvironmentVariable> environmentVariables) {
        return new EnvironmentVariablesRunFacet(this.producer, environmentVariables);
    }

    public EnvironmentVariablesRunFacetBuilder newEnvironmentVariablesRunFacetBuilder() {
        return new EnvironmentVariablesRunFacetBuilder();
    }

    public DatasetFacets newDatasetFacets(DatasourceDatasetFacet dataSource, DatasetVersionDatasetFacet version, DatasetTypeDatasetFacet datasetType, StorageDatasetFacet storage, ColumnLineageDatasetFacet columnLineage, LifecycleStateChangeDatasetFacet lifecycleStateChange, TagsDatasetFacet tags, DocumentationDatasetFacet documentation, SchemaDatasetFacet schema, OwnershipDatasetFacet ownership, SymlinksDatasetFacet symlinks) {
        return new DatasetFacets(dataSource, version, datasetType, storage, columnLineage, lifecycleStateChange, tags, documentation, schema, ownership, symlinks);
    }

    public DatasetFacetsBuilder newDatasetFacetsBuilder() {
        return new DatasetFacetsBuilder();
    }

    public OwnershipJobFacet newOwnershipJobFacet(List<OwnershipJobFacetOwners> owners) {
        return new OwnershipJobFacet(this.producer, owners);
    }

    public OwnershipJobFacetBuilder newOwnershipJobFacetBuilder() {
        return new OwnershipJobFacetBuilder();
    }

    public ParentRunFacetJob newParentRunFacetJob(String namespace, String name) {
        return new ParentRunFacetJob(namespace, name);
    }

    public ParentRunFacetJobBuilder newParentRunFacetJobBuilder() {
        return new ParentRunFacetJobBuilder();
    }

    public GcpLineageJobFacetOrigin newGcpLineageJobFacetOrigin(String sourceType, String name) {
        return new GcpLineageJobFacetOrigin(sourceType, name);
    }

    public GcpLineageJobFacetOriginBuilder newGcpLineageJobFacetOriginBuilder() {
        return new GcpLineageJobFacetOriginBuilder();
    }

    public ErrorMessageRunFacet newErrorMessageRunFacet(String message, String programmingLanguage, String stackTrace) {
        return new ErrorMessageRunFacet(this.producer, message, programmingLanguage, stackTrace);
    }

    public ErrorMessageRunFacetBuilder newErrorMessageRunFacetBuilder() {
        return new ErrorMessageRunFacetBuilder();
    }

    public JobFacet newJobFacet() {
        return new DefaultJobFacet(this.producer, null);
    }

    public JobFacet newDeletedJobFacet() {
        return new DefaultJobFacet(this.producer, true);
    }

    public RunFacets newRunFacets(ExternalQueryRunFacet externalQuery, GcpDataprocRunFacet gcp_dataproc, ExtractionErrorRunFacet extractionError, ParentRunFacet parent, NominalTimeRunFacet nominalTime, TagsRunFacet tags, ErrorMessageRunFacet errorMessage, EnvironmentVariablesRunFacet environmentVariables, ProcessingEngineRunFacet processing_engine) {
        return new RunFacets(externalQuery, gcp_dataproc, extractionError, parent, nominalTime, tags, errorMessage, environmentVariables, processing_engine);
    }

    public RunFacetsBuilder newRunFacetsBuilder() {
        return new RunFacetsBuilder();
    }

    public SchemaDatasetFacet newSchemaDatasetFacet(List<SchemaDatasetFacetFields> fields) {
        return new SchemaDatasetFacet(this.producer, fields);
    }

    public SchemaDatasetFacetBuilder newSchemaDatasetFacetBuilder() {
        return new SchemaDatasetFacetBuilder();
    }

    public SourceCodeJobFacet newSourceCodeJobFacet(String language, String sourceCode) {
        return new SourceCodeJobFacet(this.producer, language, sourceCode);
    }

    public SourceCodeJobFacetBuilder newSourceCodeJobFacetBuilder() {
        return new SourceCodeJobFacetBuilder();
    }

    public IcebergScanReportInputDatasetFacetMetadata newIcebergScanReportInputDatasetFacetMetadata() {
        return new IcebergScanReportInputDatasetFacetMetadata();
    }

    public IcebergScanReportInputDatasetFacetMetadataBuilder newIcebergScanReportInputDatasetFacetMetadataBuilder() {
        return new IcebergScanReportInputDatasetFacetMetadataBuilder();
    }

    public DataQualityAssertionsDatasetFacet newDataQualityAssertionsDatasetFacet(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
        return new DataQualityAssertionsDatasetFacet(this.producer, assertions);
    }

    public DataQualityAssertionsDatasetFacetBuilder newDataQualityAssertionsDatasetFacetBuilder() {
        return new DataQualityAssertionsDatasetFacetBuilder();
    }

    public ColumnLineageDatasetFacet newColumnLineageDatasetFacet(ColumnLineageDatasetFacetFields fields, List<InputField> dataset) {
        return new ColumnLineageDatasetFacet(this.producer, fields, dataset);
    }

    public ColumnLineageDatasetFacetBuilder newColumnLineageDatasetFacetBuilder() {
        return new ColumnLineageDatasetFacetBuilder();
    }

    public DatasetEvent newDatasetEvent(ZonedDateTime eventTime, StaticDataset dataset) {
        return new DatasetEvent(eventTime, this.producer, dataset);
    }

    public DatasetEventBuilder newDatasetEventBuilder() {
        return new DatasetEventBuilder();
    }

    public TagsJobFacet newTagsJobFacet(List<TagsJobFacetFields> tags) {
        return new TagsJobFacet(this.producer, tags);
    }

    public TagsJobFacetBuilder newTagsJobFacetBuilder() {
        return new TagsJobFacetBuilder();
    }

    public ProcessingEngineRunFacet newProcessingEngineRunFacet(String version, String name, String openlineageAdapterVersion) {
        return new ProcessingEngineRunFacet(this.producer, version, name, openlineageAdapterVersion);
    }

    public ProcessingEngineRunFacetBuilder newProcessingEngineRunFacetBuilder() {
        return new ProcessingEngineRunFacetBuilder();
    }

    public LifecycleStateChangeDatasetFacetPreviousIdentifier newLifecycleStateChangeDatasetFacetPreviousIdentifier(String name, String namespace) {
        return new LifecycleStateChangeDatasetFacetPreviousIdentifier(name, namespace);
    }

    public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder newLifecycleStateChangeDatasetFacetPreviousIdentifierBuilder() {
        return new LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder();
    }

    public InputFieldTransformations newInputFieldTransformations(String type, String subtype, String description, Boolean masking) {
        return new InputFieldTransformations(type, subtype, description, masking);
    }

    public InputFieldTransformationsBuilder newInputFieldTransformationsBuilder() {
        return new InputFieldTransformationsBuilder();
    }

    public EnvironmentVariable newEnvironmentVariable(String name, String value) {
        return new EnvironmentVariable(name, value);
    }

    public EnvironmentVariableBuilder newEnvironmentVariableBuilder() {
        return new EnvironmentVariableBuilder();
    }

    public IcebergScanReportInputDatasetFacetScanMetrics newIcebergScanReportInputDatasetFacetScanMetrics(Double totalPlanningDuration, Double resultDataFiles, Double resultDeleteFiles, Double totalDataManifests, Double totalDeleteManifests, Double scannedDataManifests, Double skippedDataManifests, Double totalFileSizeInBytes, Double totalDeleteFileSizeInBytes, Double skippedDataFiles, Double skippedDeleteFiles, Double scannedDeleteManifests, Double skippedDeleteManifests, Double indexedDeleteFiles, Double equalityDeleteFiles, Double positionalDeleteFiles) {
        return new IcebergScanReportInputDatasetFacetScanMetrics(totalPlanningDuration, resultDataFiles, resultDeleteFiles, totalDataManifests, totalDeleteManifests, scannedDataManifests, skippedDataManifests, totalFileSizeInBytes, totalDeleteFileSizeInBytes, skippedDataFiles, skippedDeleteFiles, scannedDeleteManifests, skippedDeleteManifests, indexedDeleteFiles, equalityDeleteFiles, positionalDeleteFiles);
    }

    public IcebergScanReportInputDatasetFacetScanMetricsBuilder newIcebergScanReportInputDatasetFacetScanMetricsBuilder() {
        return new IcebergScanReportInputDatasetFacetScanMetricsBuilder();
    }

    public TagsRunFacetFields newTagsRunFacetFields(String key, String value, String source) {
        return new TagsRunFacetFields(key, value, source);
    }

    public TagsRunFacetFieldsBuilder newTagsRunFacetFieldsBuilder() {
        return new TagsRunFacetFieldsBuilder();
    }

    public DataQualityAssertionsDatasetFacetAssertions newDataQualityAssertionsDatasetFacetAssertions(String assertion, Boolean success, String column) {
        return new DataQualityAssertionsDatasetFacetAssertions(assertion, success, column);
    }

    public DataQualityAssertionsDatasetFacetAssertionsBuilder newDataQualityAssertionsDatasetFacetAssertionsBuilder() {
        return new DataQualityAssertionsDatasetFacetAssertionsBuilder();
    }

    public ParentRunFacetRun newParentRunFacetRun(UUID runId) {
        return new ParentRunFacetRun(runId);
    }

    public ParentRunFacetRunBuilder newParentRunFacetRunBuilder() {
        return new ParentRunFacetRunBuilder();
    }

    public GcpDataprocRunFacet newGcpDataprocRunFacet(String appId, String appName, String batchId, String batchUuid, String clusterName, String clusterUuid, String jobId, String jobUuid, String projectId, String queryNodeName, String jobType, String sessionId, String sessionUuid) {
        return new GcpDataprocRunFacet(this.producer, appId, appName, batchId, batchUuid, clusterName, clusterUuid, jobId, jobUuid, projectId, queryNodeName, jobType, sessionId, sessionUuid);
    }

    public GcpDataprocRunFacetBuilder newGcpDataprocRunFacetBuilder() {
        return new GcpDataprocRunFacetBuilder();
    }

    public ColumnLineageDatasetFacetFields newColumnLineageDatasetFacetFields() {
        return new ColumnLineageDatasetFacetFields();
    }

    public ColumnLineageDatasetFacetFieldsBuilder newColumnLineageDatasetFacetFieldsBuilder() {
        return new ColumnLineageDatasetFacetFieldsBuilder();
    }

    public SymlinksDatasetFacet newSymlinksDatasetFacet(List<SymlinksDatasetFacetIdentifiers> identifiers) {
        return new SymlinksDatasetFacet(this.producer, identifiers);
    }

    public SymlinksDatasetFacetBuilder newSymlinksDatasetFacetBuilder() {
        return new SymlinksDatasetFacetBuilder();
    }

    public StorageDatasetFacet newStorageDatasetFacet(String storageLayer, String fileFormat) {
        return new StorageDatasetFacet(this.producer, storageLayer, fileFormat);
    }

    public StorageDatasetFacetBuilder newStorageDatasetFacetBuilder() {
        return new StorageDatasetFacetBuilder();
    }

    public InputDataset newInputDataset(String namespace, String name, DatasetFacets facets, InputDatasetInputFacets inputFacets) {
        return new InputDataset(namespace, name, facets, inputFacets);
    }

    public InputDatasetBuilder newInputDatasetBuilder() {
        return new InputDatasetBuilder();
    }

    public DatasourceDatasetFacet newDatasourceDatasetFacet(String name, URI uri) {
        return new DatasourceDatasetFacet(this.producer, name, uri);
    }

    public DatasourceDatasetFacetBuilder newDatasourceDatasetFacetBuilder() {
        return new DatasourceDatasetFacetBuilder();
    }

    @JsonDeserialize(as=SchemaDatasetFacetFields.class)
    @JsonPropertyOrder(value={"name", "type", "description", "fields"})
    public static final class SchemaDatasetFacetFields {
        private final String name;
        private final String type;
        private final String description;
        private final List<SchemaDatasetFacetFields> fields;

        @JsonCreator
        private SchemaDatasetFacetFields(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="fields") List<SchemaDatasetFacetFields> fields) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.fields = fields;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public List<SchemaDatasetFacetFields> getFields() {
            return this.fields;
        }
    }

    public static final class SchemaDatasetFacetFieldsBuilder
    implements Builder<SchemaDatasetFacetFields> {
        private String name;
        private String type;
        private String description;
        private List<SchemaDatasetFacetFields> fields;

        public SchemaDatasetFacetFieldsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder fields(List<SchemaDatasetFacetFields> fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public SchemaDatasetFacetFields build() {
            SchemaDatasetFacetFields __result = new SchemaDatasetFacetFields(this.name, this.type, this.description, this.fields);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "run", "job"})
    public static final class ParentRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ParentRunFacetRun run;
        private final ParentRunFacetJob job;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ParentRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="run") ParentRunFacetRun run, @JsonProperty(value="job") ParentRunFacetJob job) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/ParentRunFacet.json#/$defs/ParentRunFacet");
            this.run = run;
            this.job = job;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ParentRunFacetRun getRun() {
            return this.run;
        }

        public ParentRunFacetJob getJob() {
            return this.job;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=ParentRunFacetRun.class)
    @JsonPropertyOrder(value={"runId"})
    public static final class ParentRunFacetRun {
        private final UUID runId;

        @JsonCreator
        private ParentRunFacetRun(@JsonProperty(value="runId") UUID runId) {
            this.runId = runId;
        }

        public UUID getRunId() {
            return this.runId;
        }
    }

    @JsonDeserialize(as=ParentRunFacetJob.class)
    @JsonPropertyOrder(value={"namespace", "name"})
    public static final class ParentRunFacetJob {
        private final String namespace;
        private final String name;

        @JsonCreator
        private ParentRunFacetJob(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }
    }

    public final class ParentRunFacetBuilder
    implements Builder<ParentRunFacet> {
        private ParentRunFacetRun run;
        private ParentRunFacetJob job;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ParentRunFacetBuilder run(ParentRunFacetRun run) {
            this.run = run;
            return this;
        }

        public ParentRunFacetBuilder job(ParentRunFacetJob job) {
            this.job = job;
            return this;
        }

        public ParentRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ParentRunFacet build() {
            ParentRunFacet __result = new ParentRunFacet(OpenLineage.this.producer, this.run, this.job);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputStatisticsOutputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "size", "fileCount"})
    public static final class OutputStatisticsOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long size;
        private final Long fileCount;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OutputStatisticsOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="size") Long size, @JsonProperty(value="fileCount") Long fileCount) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-2/OutputStatisticsOutputDatasetFacet.json#/$defs/OutputStatisticsOutputDatasetFacet");
            this.rowCount = rowCount;
            this.size = size;
            this.fileCount = fileCount;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getSize() {
            return this.size;
        }

        public Long getFileCount() {
            return this.fileCount;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class OutputStatisticsOutputDatasetFacetBuilder
    implements Builder<OutputStatisticsOutputDatasetFacet> {
        private Long rowCount;
        private Long size;
        private Long fileCount;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OutputStatisticsOutputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OutputStatisticsOutputDatasetFacet build() {
            OutputStatisticsOutputDatasetFacet __result = new OutputStatisticsOutputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.size, this.fileCount);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ExtractionErrorRunFacetErrors.class)
    @JsonPropertyOrder(value={"errorMessage", "stackTrace", "task", "taskNumber"})
    public static final class ExtractionErrorRunFacetErrors {
        private final String errorMessage;
        private final String stackTrace;
        private final String task;
        private final Long taskNumber;

        @JsonCreator
        private ExtractionErrorRunFacetErrors(@JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="stackTrace") String stackTrace, @JsonProperty(value="task") String task, @JsonProperty(value="taskNumber") Long taskNumber) {
            this.errorMessage = errorMessage;
            this.stackTrace = stackTrace;
            this.task = task;
            this.taskNumber = taskNumber;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String getTask() {
            return this.task;
        }

        public Long getTaskNumber() {
            return this.taskNumber;
        }
    }

    public static final class ExtractionErrorRunFacetErrorsBuilder
    implements Builder<ExtractionErrorRunFacetErrors> {
        private String errorMessage;
        private String stackTrace;
        private String task;
        private Long taskNumber;

        public ExtractionErrorRunFacetErrorsBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder task(String task) {
            this.task = task;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder taskNumber(Long taskNumber) {
            this.taskNumber = taskNumber;
            return this;
        }

        @Override
        public ExtractionErrorRunFacetErrors build() {
            ExtractionErrorRunFacetErrors __result = new ExtractionErrorRunFacetErrors(this.errorMessage, this.stackTrace, this.task, this.taskNumber);
            return __result;
        }
    }

    @JsonDeserialize(as=JobTypeJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "processingType", "integration", "jobType"})
    public static final class JobTypeJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String processingType;
        private final String integration;
        private final String jobType;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private JobTypeJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="processingType") String processingType, @JsonProperty(value="integration") String integration, @JsonProperty(value="jobType") String jobType) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/2-0-3/JobTypeJobFacet.json#/$defs/JobTypeJobFacet");
            this._deleted = null;
            this.processingType = processingType;
            this.integration = integration;
            this.jobType = jobType;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getProcessingType() {
            return this.processingType;
        }

        public String getIntegration() {
            return this.integration;
        }

        public String getJobType() {
            return this.jobType;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class JobTypeJobFacetBuilder
    implements Builder<JobTypeJobFacet> {
        private String processingType;
        private String integration;
        private String jobType;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public JobTypeJobFacetBuilder processingType(String processingType) {
            this.processingType = processingType;
            return this;
        }

        public JobTypeJobFacetBuilder integration(String integration) {
            this.integration = integration;
            return this;
        }

        public JobTypeJobFacetBuilder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobTypeJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public JobTypeJobFacet build() {
            JobTypeJobFacet __result = new JobTypeJobFacet(OpenLineage.this.producer, this.processingType, this.integration, this.jobType);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=Run.class)
    @JsonPropertyOrder(value={"runId", "facets"})
    public static final class Run {
        private final UUID runId;
        private final RunFacets facets;

        @JsonCreator
        private Run(@JsonProperty(value="runId") UUID runId, @JsonProperty(value="facets") RunFacets facets) {
            this.runId = runId;
            this.facets = facets;
        }

        public UUID getRunId() {
            return this.runId;
        }

        public RunFacets getFacets() {
            return this.facets;
        }
    }

    @JsonDeserialize(as=RunFacets.class)
    @JsonPropertyOrder(value={"externalQuery", "gcp_dataproc", "extractionError", "parent", "nominalTime", "tags", "errorMessage", "environmentVariables", "processing_engine"})
    public static final class RunFacets {
        private final ExternalQueryRunFacet externalQuery;
        private final GcpDataprocRunFacet gcp_dataproc;
        private final ExtractionErrorRunFacet extractionError;
        private final ParentRunFacet parent;
        private final NominalTimeRunFacet nominalTime;
        private final TagsRunFacet tags;
        private final ErrorMessageRunFacet errorMessage;
        private final EnvironmentVariablesRunFacet environmentVariables;
        private final ProcessingEngineRunFacet processing_engine;
        @JsonAnySetter
        private final Map<String, RunFacet> additionalProperties;

        @JsonCreator
        private RunFacets(@JsonProperty(value="externalQuery") ExternalQueryRunFacet externalQuery, @JsonProperty(value="gcp_dataproc") GcpDataprocRunFacet gcp_dataproc, @JsonProperty(value="extractionError") ExtractionErrorRunFacet extractionError, @JsonProperty(value="parent") ParentRunFacet parent, @JsonProperty(value="nominalTime") NominalTimeRunFacet nominalTime, @JsonProperty(value="tags") TagsRunFacet tags, @JsonProperty(value="errorMessage") ErrorMessageRunFacet errorMessage, @JsonProperty(value="environmentVariables") EnvironmentVariablesRunFacet environmentVariables, @JsonProperty(value="processing_engine") ProcessingEngineRunFacet processing_engine) {
            this.externalQuery = externalQuery;
            this.gcp_dataproc = gcp_dataproc;
            this.extractionError = extractionError;
            this.parent = parent;
            this.nominalTime = nominalTime;
            this.tags = tags;
            this.errorMessage = errorMessage;
            this.environmentVariables = environmentVariables;
            this.processing_engine = processing_engine;
            this.additionalProperties = new LinkedHashMap<String, RunFacet>();
        }

        public ExternalQueryRunFacet getExternalQuery() {
            return this.externalQuery;
        }

        public GcpDataprocRunFacet getGcp_dataproc() {
            return this.gcp_dataproc;
        }

        public ExtractionErrorRunFacet getExtractionError() {
            return this.extractionError;
        }

        public ParentRunFacet getParent() {
            return this.parent;
        }

        public NominalTimeRunFacet getNominalTime() {
            return this.nominalTime;
        }

        public TagsRunFacet getTags() {
            return this.tags;
        }

        public ErrorMessageRunFacet getErrorMessage() {
            return this.errorMessage;
        }

        public EnvironmentVariablesRunFacet getEnvironmentVariables() {
            return this.environmentVariables;
        }

        public ProcessingEngineRunFacet getProcessing_engine() {
            return this.processing_engine;
        }

        @JsonAnyGetter
        public Map<String, RunFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class RunBuilder
    implements Builder<Run> {
        private UUID runId;
        private RunFacets facets;

        public RunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        public RunBuilder facets(RunFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public Run build() {
            Run __result = new Run(this.runId, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles {
        @JsonAnySetter
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        }

        @JsonAnyGetter
        public Map<String, Double> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles> {
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder put(String key, Double value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ExternalQueryRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "externalQueryId", "source"})
    public static final class ExternalQueryRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String externalQueryId;
        private final String source;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ExternalQueryRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="externalQueryId") String externalQueryId, @JsonProperty(value="source") String source) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-2/ExternalQueryRunFacet.json#/$defs/ExternalQueryRunFacet");
            this.externalQueryId = externalQueryId;
            this.source = source;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getExternalQueryId() {
            return this.externalQueryId;
        }

        public String getSource() {
            return this.source;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ExternalQueryRunFacetBuilder
    implements Builder<ExternalQueryRunFacet> {
        private String externalQueryId;
        private String source;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ExternalQueryRunFacetBuilder externalQueryId(String externalQueryId) {
            this.externalQueryId = externalQueryId;
            return this;
        }

        public ExternalQueryRunFacetBuilder source(String source) {
            this.source = source;
            return this;
        }

        public ExternalQueryRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ExternalQueryRunFacet build() {
            ExternalQueryRunFacet __result = new ExternalQueryRunFacet(OpenLineage.this.producer, this.externalQueryId, this.source);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDatasetOutputFacets.class)
    @JsonPropertyOrder(value={"iceberg_scan_report", "outputStatistics"})
    public static final class OutputDatasetOutputFacets {
        private final IcebergCommitReportOutputDatasetFacet iceberg_scan_report;
        private final OutputStatisticsOutputDatasetFacet outputStatistics;
        @JsonAnySetter
        private final Map<String, OutputDatasetFacet> additionalProperties;

        @JsonCreator
        private OutputDatasetOutputFacets(@JsonProperty(value="iceberg_scan_report") IcebergCommitReportOutputDatasetFacet iceberg_scan_report, @JsonProperty(value="outputStatistics") OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.iceberg_scan_report = iceberg_scan_report;
            this.outputStatistics = outputStatistics;
            this.additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();
        }

        public IcebergCommitReportOutputDatasetFacet getIceberg_scan_report() {
            return this.iceberg_scan_report;
        }

        public OutputStatisticsOutputDatasetFacet getOutputStatistics() {
            return this.outputStatistics;
        }

        @JsonAnyGetter
        public Map<String, OutputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=IcebergCommitReportOutputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "snapshotId", "sequenceNumber", "operation", "commitMetrics", "metadata"})
    public static final class IcebergCommitReportOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Double snapshotId;
        private final Double sequenceNumber;
        private final String operation;
        private final IcebergCommitReportOutputDatasetFacetCommitMetrics commitMetrics;
        private final IcebergCommitReportOutputDatasetFacetMetadata metadata;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private IcebergCommitReportOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="snapshotId") Double snapshotId, @JsonProperty(value="sequenceNumber") Double sequenceNumber, @JsonProperty(value="operation") String operation, @JsonProperty(value="commitMetrics") IcebergCommitReportOutputDatasetFacetCommitMetrics commitMetrics, @JsonProperty(value="metadata") IcebergCommitReportOutputDatasetFacetMetadata metadata) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/IcebergCommitReportOutputDatasetFacet.json#/$defs/IcebergCommitReportOutputDatasetFacet");
            this.snapshotId = snapshotId;
            this.sequenceNumber = sequenceNumber;
            this.operation = operation;
            this.commitMetrics = commitMetrics;
            this.metadata = metadata;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Double getSnapshotId() {
            return this.snapshotId;
        }

        public Double getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String getOperation() {
            return this.operation;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetrics getCommitMetrics() {
            return this.commitMetrics;
        }

        public IcebergCommitReportOutputDatasetFacetMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class OutputDatasetOutputFacetsBuilder
    implements Builder<OutputDatasetOutputFacets> {
        private IcebergCommitReportOutputDatasetFacet iceberg_scan_report;
        private OutputStatisticsOutputDatasetFacet outputStatistics;
        private final Map<String, OutputDatasetFacet> additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();

        public OutputDatasetOutputFacetsBuilder iceberg_scan_report(IcebergCommitReportOutputDatasetFacet iceberg_scan_report) {
            this.iceberg_scan_report = iceberg_scan_report;
            return this;
        }

        public OutputDatasetOutputFacetsBuilder outputStatistics(OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.outputStatistics = outputStatistics;
            return this;
        }

        public OutputDatasetOutputFacetsBuilder put(String key, OutputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OutputDatasetOutputFacets build() {
            OutputDatasetOutputFacets __result = new OutputDatasetOutputFacets(this.iceberg_scan_report, this.outputStatistics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=NominalTimeRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "nominalStartTime", "nominalEndTime"})
    public static final class NominalTimeRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ZonedDateTime nominalStartTime;
        private final ZonedDateTime nominalEndTime;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private NominalTimeRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="nominalStartTime") ZonedDateTime nominalStartTime, @JsonProperty(value="nominalEndTime") ZonedDateTime nominalEndTime) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/NominalTimeRunFacet.json#/$defs/NominalTimeRunFacet");
            this.nominalStartTime = nominalStartTime;
            this.nominalEndTime = nominalEndTime;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ZonedDateTime getNominalStartTime() {
            return this.nominalStartTime;
        }

        public ZonedDateTime getNominalEndTime() {
            return this.nominalEndTime;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class NominalTimeRunFacetBuilder
    implements Builder<NominalTimeRunFacet> {
        private ZonedDateTime nominalStartTime;
        private ZonedDateTime nominalEndTime;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public NominalTimeRunFacetBuilder nominalStartTime(ZonedDateTime nominalStartTime) {
            this.nominalStartTime = nominalStartTime;
            return this;
        }

        public NominalTimeRunFacetBuilder nominalEndTime(ZonedDateTime nominalEndTime) {
            this.nominalEndTime = nominalEndTime;
            return this;
        }

        public NominalTimeRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public NominalTimeRunFacet build() {
            NominalTimeRunFacet __result = new NominalTimeRunFacet(OpenLineage.this.producer, this.nominalStartTime, this.nominalEndTime);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static class DefaultInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultInputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/InputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacetFieldsAdditional.class)
    @JsonPropertyOrder(value={"inputFields", "transformationDescription", "transformationType"})
    public static final class ColumnLineageDatasetFacetFieldsAdditional {
        private final List<InputField> inputFields;
        private final String transformationDescription;
        private final String transformationType;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ColumnLineageDatasetFacetFieldsAdditional(@JsonProperty(value="inputFields") List<InputField> inputFields, @JsonProperty(value="transformationDescription") String transformationDescription, @JsonProperty(value="transformationType") String transformationType) {
            this.inputFields = inputFields;
            this.transformationDescription = transformationDescription;
            this.transformationType = transformationType;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public List<InputField> getInputFields() {
            return this.inputFields;
        }

        public String getTransformationDescription() {
            return this.transformationDescription;
        }

        public String getTransformationType() {
            return this.transformationType;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class ColumnLineageDatasetFacetFieldsAdditionalBuilder
    implements Builder<ColumnLineageDatasetFacetFieldsAdditional> {
        private List<InputField> inputFields;
        private String transformationDescription;
        private String transformationType;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder inputFields(List<InputField> inputFields) {
            this.inputFields = inputFields;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder transformationDescription(String transformationDescription) {
            this.transformationDescription = transformationDescription;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder transformationType(String transformationType) {
            this.transformationType = transformationType;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacetFieldsAdditional build() {
            ColumnLineageDatasetFacetFieldsAdditional __result = new ColumnLineageDatasetFacetFieldsAdditional(this.inputFields, this.transformationDescription, this.transformationType);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditional.class)
    @JsonPropertyOrder(value={"nullCount", "distinctCount", "sum", "count", "min", "max", "quantiles"})
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditional {
        private final Long nullCount;
        private final Long distinctCount;
        private final Double sum;
        private final Double count;
        private final Double min;
        private final Double max;
        private final DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(@JsonProperty(value="nullCount") Long nullCount, @JsonProperty(value="distinctCount") Long distinctCount, @JsonProperty(value="sum") Double sum, @JsonProperty(value="count") Double count, @JsonProperty(value="min") Double min2, @JsonProperty(value="max") Double max, @JsonProperty(value="quantiles") DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.nullCount = nullCount;
            this.distinctCount = distinctCount;
            this.sum = sum;
            this.count = count;
            this.min = min2;
            this.max = max;
            this.quantiles = quantiles;
        }

        public Long getNullCount() {
            return this.nullCount;
        }

        public Long getDistinctCount() {
            return this.distinctCount;
        }

        public Double getSum() {
            return this.sum;
        }

        public Double getCount() {
            return this.count;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles getQuantiles() {
            return this.quantiles;
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> {
        private Long nullCount;
        private Long distinctCount;
        private Double sum;
        private Double count;
        private Double min;
        private Double max;
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder nullCount(Long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder distinctCount(Long distinctCount) {
            this.distinctCount = distinctCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder count(Double count) {
            this.count = count;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder min(Double min2) {
            this.min = min2;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder quantiles(DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditional __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(this.nullCount, this.distinctCount, this.sum, this.count, this.min, this.max, this.quantiles);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "bytes", "fileCount", "columnMetrics"})
    public static final class DataQualityMetricsInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long bytes;
        private final Long fileCount;
        private final DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="bytes") Long bytes, @JsonProperty(value="fileCount") Long fileCount, @JsonProperty(value="columnMetrics") DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-2/DataQualityMetricsInputDatasetFacet.json#/$defs/DataQualityMetricsInputDatasetFacet");
            this.rowCount = rowCount;
            this.bytes = bytes;
            this.fileCount = fileCount;
            this.columnMetrics = columnMetrics;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public Long getFileCount() {
            return this.fileCount;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetrics getColumnMetrics() {
            return this.columnMetrics;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetrics.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetrics {
        @JsonAnySetter
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetrics() {
        }

        @JsonAnyGetter
        public Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DataQualityMetricsInputDatasetFacetBuilder
    implements Builder<DataQualityMetricsInputDatasetFacet> {
        private Long rowCount;
        private Long bytes;
        private Long fileCount;
        private DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityMetricsInputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder columnMetrics(DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this.columnMetrics = columnMetrics;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacet build() {
            DataQualityMetricsInputDatasetFacet __result = new DataQualityMetricsInputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.bytes, this.fileCount, this.columnMetrics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "description"})
    public static final class DocumentationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/DocumentationJobFacet.json#/$defs/DocumentationJobFacet");
            this._deleted = null;
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DocumentationJobFacetBuilder
    implements Builder<DocumentationJobFacet> {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationJobFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DocumentationJobFacet build() {
            DocumentationJobFacet __result = new DocumentationJobFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDatasetInputFacets.class)
    @JsonPropertyOrder(value={"dataQualityAssertions", "inputStatistics", "dataQualityMetrics", "iceberg_scan_report"})
    public static final class InputDatasetInputFacets {
        private final DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private final InputStatisticsInputDatasetFacet inputStatistics;
        private final DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        private final IcebergScanReportInputDatasetFacet iceberg_scan_report;
        @JsonAnySetter
        private final Map<String, InputDatasetFacet> additionalProperties;

        @JsonCreator
        private InputDatasetInputFacets(@JsonProperty(value="dataQualityAssertions") DataQualityAssertionsDatasetFacet dataQualityAssertions, @JsonProperty(value="inputStatistics") InputStatisticsInputDatasetFacet inputStatistics, @JsonProperty(value="dataQualityMetrics") DataQualityMetricsInputDatasetFacet dataQualityMetrics, @JsonProperty(value="iceberg_scan_report") IcebergScanReportInputDatasetFacet iceberg_scan_report) {
            this.dataQualityAssertions = dataQualityAssertions;
            this.inputStatistics = inputStatistics;
            this.dataQualityMetrics = dataQualityMetrics;
            this.iceberg_scan_report = iceberg_scan_report;
            this.additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();
        }

        public DataQualityAssertionsDatasetFacet getDataQualityAssertions() {
            return this.dataQualityAssertions;
        }

        public InputStatisticsInputDatasetFacet getInputStatistics() {
            return this.inputStatistics;
        }

        public DataQualityMetricsInputDatasetFacet getDataQualityMetrics() {
            return this.dataQualityMetrics;
        }

        public IcebergScanReportInputDatasetFacet getIceberg_scan_report() {
            return this.iceberg_scan_report;
        }

        @JsonAnyGetter
        public Map<String, InputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "assertions"})
    public static final class DataQualityAssertionsDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityAssertionsDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="assertions") List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/DataQualityAssertionsDatasetFacet.json#/$defs/DataQualityAssertionsDatasetFacet");
            this.assertions = assertions;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<DataQualityAssertionsDatasetFacetAssertions> getAssertions() {
            return this.assertions;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=InputStatisticsInputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "size", "fileCount"})
    public static final class InputStatisticsInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long size;
        private final Long fileCount;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private InputStatisticsInputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="size") Long size, @JsonProperty(value="fileCount") Long fileCount) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/InputStatisticsInputDatasetFacet.json#/$defs/InputStatisticsInputDatasetFacet");
            this.rowCount = rowCount;
            this.size = size;
            this.fileCount = fileCount;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getSize() {
            return this.size;
        }

        public Long getFileCount() {
            return this.fileCount;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=IcebergScanReportInputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "snapshotId", "filter", "schemaId", "projectedFieldNames", "scanMetrics", "metadata"})
    public static final class IcebergScanReportInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Double snapshotId;
        private final String filter;
        private final Double schemaId;
        private final List<String> projectedFieldNames;
        private final IcebergScanReportInputDatasetFacetScanMetrics scanMetrics;
        private final IcebergScanReportInputDatasetFacetMetadata metadata;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private IcebergScanReportInputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="snapshotId") Double snapshotId, @JsonProperty(value="filter") String filter, @JsonProperty(value="schemaId") Double schemaId, @JsonProperty(value="projectedFieldNames") List<String> projectedFieldNames, @JsonProperty(value="scanMetrics") IcebergScanReportInputDatasetFacetScanMetrics scanMetrics, @JsonProperty(value="metadata") IcebergScanReportInputDatasetFacetMetadata metadata) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/IcebergScanReportInputDatasetFacet.json#/$defs/IcebergScanReportInputDatasetFacet");
            this.snapshotId = snapshotId;
            this.filter = filter;
            this.schemaId = schemaId;
            this.projectedFieldNames = projectedFieldNames;
            this.scanMetrics = scanMetrics;
            this.metadata = metadata;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Double getSnapshotId() {
            return this.snapshotId;
        }

        public String getFilter() {
            return this.filter;
        }

        public Double getSchemaId() {
            return this.schemaId;
        }

        public List<String> getProjectedFieldNames() {
            return this.projectedFieldNames;
        }

        public IcebergScanReportInputDatasetFacetScanMetrics getScanMetrics() {
            return this.scanMetrics;
        }

        public IcebergScanReportInputDatasetFacetMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class InputDatasetInputFacetsBuilder
    implements Builder<InputDatasetInputFacets> {
        private DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private InputStatisticsInputDatasetFacet inputStatistics;
        private DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        private IcebergScanReportInputDatasetFacet iceberg_scan_report;
        private final Map<String, InputDatasetFacet> additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();

        public InputDatasetInputFacetsBuilder dataQualityAssertions(DataQualityAssertionsDatasetFacet dataQualityAssertions) {
            this.dataQualityAssertions = dataQualityAssertions;
            return this;
        }

        public InputDatasetInputFacetsBuilder inputStatistics(InputStatisticsInputDatasetFacet inputStatistics) {
            this.inputStatistics = inputStatistics;
            return this;
        }

        public InputDatasetInputFacetsBuilder dataQualityMetrics(DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
            this.dataQualityMetrics = dataQualityMetrics;
            return this;
        }

        public InputDatasetInputFacetsBuilder iceberg_scan_report(IcebergScanReportInputDatasetFacet iceberg_scan_report) {
            this.iceberg_scan_report = iceberg_scan_report;
            return this;
        }

        public InputDatasetInputFacetsBuilder put(String key, InputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public InputDatasetInputFacets build() {
            InputDatasetInputFacets __result = new InputDatasetInputFacets(this.dataQualityAssertions, this.inputStatistics, this.dataQualityMetrics, this.iceberg_scan_report);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SQLJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "query"})
    public static final class SQLJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String query;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SQLJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="query") String query) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/SQLJobFacet.json#/$defs/SQLJobFacet");
            this._deleted = null;
            this.query = query;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getQuery() {
            return this.query;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SQLJobFacetBuilder
    implements Builder<SQLJobFacet> {
        private String query;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SQLJobFacetBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SQLJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SQLJobFacet build() {
            SQLJobFacet __result = new SQLJobFacet(OpenLineage.this.producer, this.query);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "outputFacets"})
    public static final class OutputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final OutputDatasetOutputFacets outputFacets;

        @JsonCreator
        private OutputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="outputFacets") OutputDatasetOutputFacets outputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.outputFacets = outputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public OutputDatasetOutputFacets getOutputFacets() {
            return this.outputFacets;
        }
    }

    @JsonDeserialize(as=DatasetFacets.class)
    @JsonPropertyOrder(value={"dataSource", "version", "datasetType", "storage", "columnLineage", "lifecycleStateChange", "tags", "documentation", "schema", "ownership", "symlinks"})
    public static final class DatasetFacets {
        private final DatasourceDatasetFacet dataSource;
        private final DatasetVersionDatasetFacet version;
        private final DatasetTypeDatasetFacet datasetType;
        private final StorageDatasetFacet storage;
        private final ColumnLineageDatasetFacet columnLineage;
        private final LifecycleStateChangeDatasetFacet lifecycleStateChange;
        private final TagsDatasetFacet tags;
        private final DocumentationDatasetFacet documentation;
        private final SchemaDatasetFacet schema;
        private final OwnershipDatasetFacet ownership;
        private final SymlinksDatasetFacet symlinks;
        @JsonAnySetter
        private final Map<String, DatasetFacet> additionalProperties;

        @JsonCreator
        private DatasetFacets(@JsonProperty(value="dataSource") DatasourceDatasetFacet dataSource, @JsonProperty(value="version") DatasetVersionDatasetFacet version, @JsonProperty(value="datasetType") DatasetTypeDatasetFacet datasetType, @JsonProperty(value="storage") StorageDatasetFacet storage, @JsonProperty(value="columnLineage") ColumnLineageDatasetFacet columnLineage, @JsonProperty(value="lifecycleStateChange") LifecycleStateChangeDatasetFacet lifecycleStateChange, @JsonProperty(value="tags") TagsDatasetFacet tags, @JsonProperty(value="documentation") DocumentationDatasetFacet documentation, @JsonProperty(value="schema") SchemaDatasetFacet schema, @JsonProperty(value="ownership") OwnershipDatasetFacet ownership, @JsonProperty(value="symlinks") SymlinksDatasetFacet symlinks) {
            this.dataSource = dataSource;
            this.version = version;
            this.datasetType = datasetType;
            this.storage = storage;
            this.columnLineage = columnLineage;
            this.lifecycleStateChange = lifecycleStateChange;
            this.tags = tags;
            this.documentation = documentation;
            this.schema = schema;
            this.ownership = ownership;
            this.symlinks = symlinks;
            this.additionalProperties = new LinkedHashMap<String, DatasetFacet>();
        }

        public DatasourceDatasetFacet getDataSource() {
            return this.dataSource;
        }

        public DatasetVersionDatasetFacet getVersion() {
            return this.version;
        }

        public DatasetTypeDatasetFacet getDatasetType() {
            return this.datasetType;
        }

        public StorageDatasetFacet getStorage() {
            return this.storage;
        }

        public ColumnLineageDatasetFacet getColumnLineage() {
            return this.columnLineage;
        }

        public LifecycleStateChangeDatasetFacet getLifecycleStateChange() {
            return this.lifecycleStateChange;
        }

        public TagsDatasetFacet getTags() {
            return this.tags;
        }

        public DocumentationDatasetFacet getDocumentation() {
            return this.documentation;
        }

        public SchemaDatasetFacet getSchema() {
            return this.schema;
        }

        public OwnershipDatasetFacet getOwnership() {
            return this.ownership;
        }

        public SymlinksDatasetFacet getSymlinks() {
            return this.symlinks;
        }

        @JsonAnyGetter
        public Map<String, DatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class OutputDatasetBuilder
    implements Builder<OutputDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private OutputDatasetOutputFacets outputFacets;

        public OutputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public OutputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OutputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public OutputDatasetBuilder outputFacets(OutputDatasetOutputFacets outputFacets) {
            this.outputFacets = outputFacets;
            return this;
        }

        @Override
        public OutputDataset build() {
            OutputDataset __result = new OutputDataset(this.namespace, this.name, this.facets, this.outputFacets);
            return __result;
        }
    }

    @JsonDeserialize(as=TagsDatasetFacetFields.class)
    @JsonPropertyOrder(value={"key", "value", "source", "field"})
    public static final class TagsDatasetFacetFields {
        private final String key;
        private final String value;
        private final String source;
        private final String field;

        @JsonCreator
        private TagsDatasetFacetFields(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="source") String source, @JsonProperty(value="field") String field) {
            this.key = key;
            this.value = value;
            this.source = source;
            this.field = field;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getSource() {
            return this.source;
        }

        public String getField() {
            return this.field;
        }
    }

    public static final class TagsDatasetFacetFieldsBuilder
    implements Builder<TagsDatasetFacetFields> {
        private String key;
        private String value;
        private String source;
        private String field;

        public TagsDatasetFacetFieldsBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagsDatasetFacetFieldsBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TagsDatasetFacetFieldsBuilder source(String source) {
            this.source = source;
            return this;
        }

        public TagsDatasetFacetFieldsBuilder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public TagsDatasetFacetFields build() {
            TagsDatasetFacetFields __result = new TagsDatasetFacetFields(this.key, this.value, this.source, this.field);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "description"})
    public static final class DocumentationDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/DocumentationDatasetFacet.json#/$defs/DocumentationDatasetFacet");
            this._deleted = null;
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DocumentationDatasetFacetBuilder
    implements Builder<DocumentationDatasetFacet> {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationDatasetFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DocumentationDatasetFacet build() {
            DocumentationDatasetFacet __result = new DocumentationDatasetFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SourceCodeLocationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "type", "url", "repoUrl", "path", "version", "tag", "branch"})
    public static final class SourceCodeLocationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String type;
        private final URI url;
        private final String repoUrl;
        private final String path;
        private final String version;
        private final String tag;
        private final String branch;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SourceCodeLocationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="type") String type, @JsonProperty(value="url") URI url, @JsonProperty(value="repoUrl") String repoUrl, @JsonProperty(value="path") String path, @JsonProperty(value="version") String version, @JsonProperty(value="tag") String tag, @JsonProperty(value="branch") String branch) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/SourceCodeLocationJobFacet.json#/$defs/SourceCodeLocationJobFacet");
            this._deleted = null;
            this.type = type;
            this.url = url;
            this.repoUrl = repoUrl;
            this.path = path;
            this.version = version;
            this.tag = tag;
            this.branch = branch;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getType() {
            return this.type;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public String getPath() {
            return this.path;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTag() {
            return this.tag;
        }

        public String getBranch() {
            return this.branch;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SourceCodeLocationJobFacetBuilder
    implements Builder<SourceCodeLocationJobFacet> {
        private String type;
        private URI url;
        private String repoUrl;
        private String path;
        private String version;
        private String tag;
        private String branch;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SourceCodeLocationJobFacetBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder url(URI url) {
            this.url = url;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder repoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SourceCodeLocationJobFacet build() {
            SourceCodeLocationJobFacet __result = new SourceCodeLocationJobFacet(OpenLineage.this.producer, this.type, this.url, this.repoUrl, this.path, this.version, this.tag, this.branch);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=IcebergScanReportInputDatasetFacetScanMetrics.class)
    @JsonPropertyOrder(value={"totalPlanningDuration", "resultDataFiles", "resultDeleteFiles", "totalDataManifests", "totalDeleteManifests", "scannedDataManifests", "skippedDataManifests", "totalFileSizeInBytes", "totalDeleteFileSizeInBytes", "skippedDataFiles", "skippedDeleteFiles", "scannedDeleteManifests", "skippedDeleteManifests", "indexedDeleteFiles", "equalityDeleteFiles", "positionalDeleteFiles"})
    public static final class IcebergScanReportInputDatasetFacetScanMetrics {
        private final Double totalPlanningDuration;
        private final Double resultDataFiles;
        private final Double resultDeleteFiles;
        private final Double totalDataManifests;
        private final Double totalDeleteManifests;
        private final Double scannedDataManifests;
        private final Double skippedDataManifests;
        private final Double totalFileSizeInBytes;
        private final Double totalDeleteFileSizeInBytes;
        private final Double skippedDataFiles;
        private final Double skippedDeleteFiles;
        private final Double scannedDeleteManifests;
        private final Double skippedDeleteManifests;
        private final Double indexedDeleteFiles;
        private final Double equalityDeleteFiles;
        private final Double positionalDeleteFiles;

        @JsonCreator
        private IcebergScanReportInputDatasetFacetScanMetrics(@JsonProperty(value="totalPlanningDuration") Double totalPlanningDuration, @JsonProperty(value="resultDataFiles") Double resultDataFiles, @JsonProperty(value="resultDeleteFiles") Double resultDeleteFiles, @JsonProperty(value="totalDataManifests") Double totalDataManifests, @JsonProperty(value="totalDeleteManifests") Double totalDeleteManifests, @JsonProperty(value="scannedDataManifests") Double scannedDataManifests, @JsonProperty(value="skippedDataManifests") Double skippedDataManifests, @JsonProperty(value="totalFileSizeInBytes") Double totalFileSizeInBytes, @JsonProperty(value="totalDeleteFileSizeInBytes") Double totalDeleteFileSizeInBytes, @JsonProperty(value="skippedDataFiles") Double skippedDataFiles, @JsonProperty(value="skippedDeleteFiles") Double skippedDeleteFiles, @JsonProperty(value="scannedDeleteManifests") Double scannedDeleteManifests, @JsonProperty(value="skippedDeleteManifests") Double skippedDeleteManifests, @JsonProperty(value="indexedDeleteFiles") Double indexedDeleteFiles, @JsonProperty(value="equalityDeleteFiles") Double equalityDeleteFiles, @JsonProperty(value="positionalDeleteFiles") Double positionalDeleteFiles) {
            this.totalPlanningDuration = totalPlanningDuration;
            this.resultDataFiles = resultDataFiles;
            this.resultDeleteFiles = resultDeleteFiles;
            this.totalDataManifests = totalDataManifests;
            this.totalDeleteManifests = totalDeleteManifests;
            this.scannedDataManifests = scannedDataManifests;
            this.skippedDataManifests = skippedDataManifests;
            this.totalFileSizeInBytes = totalFileSizeInBytes;
            this.totalDeleteFileSizeInBytes = totalDeleteFileSizeInBytes;
            this.skippedDataFiles = skippedDataFiles;
            this.skippedDeleteFiles = skippedDeleteFiles;
            this.scannedDeleteManifests = scannedDeleteManifests;
            this.skippedDeleteManifests = skippedDeleteManifests;
            this.indexedDeleteFiles = indexedDeleteFiles;
            this.equalityDeleteFiles = equalityDeleteFiles;
            this.positionalDeleteFiles = positionalDeleteFiles;
        }

        public Double getTotalPlanningDuration() {
            return this.totalPlanningDuration;
        }

        public Double getResultDataFiles() {
            return this.resultDataFiles;
        }

        public Double getResultDeleteFiles() {
            return this.resultDeleteFiles;
        }

        public Double getTotalDataManifests() {
            return this.totalDataManifests;
        }

        public Double getTotalDeleteManifests() {
            return this.totalDeleteManifests;
        }

        public Double getScannedDataManifests() {
            return this.scannedDataManifests;
        }

        public Double getSkippedDataManifests() {
            return this.skippedDataManifests;
        }

        public Double getTotalFileSizeInBytes() {
            return this.totalFileSizeInBytes;
        }

        public Double getTotalDeleteFileSizeInBytes() {
            return this.totalDeleteFileSizeInBytes;
        }

        public Double getSkippedDataFiles() {
            return this.skippedDataFiles;
        }

        public Double getSkippedDeleteFiles() {
            return this.skippedDeleteFiles;
        }

        public Double getScannedDeleteManifests() {
            return this.scannedDeleteManifests;
        }

        public Double getSkippedDeleteManifests() {
            return this.skippedDeleteManifests;
        }

        public Double getIndexedDeleteFiles() {
            return this.indexedDeleteFiles;
        }

        public Double getEqualityDeleteFiles() {
            return this.equalityDeleteFiles;
        }

        public Double getPositionalDeleteFiles() {
            return this.positionalDeleteFiles;
        }
    }

    @JsonDeserialize(as=IcebergScanReportInputDatasetFacetMetadata.class)
    @JsonPropertyOrder
    public static final class IcebergScanReportInputDatasetFacetMetadata {
        @JsonAnySetter
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        @JsonCreator
        private IcebergScanReportInputDatasetFacetMetadata() {
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class IcebergScanReportInputDatasetFacetBuilder
    implements Builder<IcebergScanReportInputDatasetFacet> {
        private Double snapshotId;
        private String filter;
        private Double schemaId;
        private List<String> projectedFieldNames;
        private IcebergScanReportInputDatasetFacetScanMetrics scanMetrics;
        private IcebergScanReportInputDatasetFacetMetadata metadata;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public IcebergScanReportInputDatasetFacetBuilder snapshotId(Double snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder schemaId(Double schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder projectedFieldNames(List<String> projectedFieldNames) {
            this.projectedFieldNames = projectedFieldNames;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder scanMetrics(IcebergScanReportInputDatasetFacetScanMetrics scanMetrics) {
            this.scanMetrics = scanMetrics;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder metadata(IcebergScanReportInputDatasetFacetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public IcebergScanReportInputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public IcebergScanReportInputDatasetFacet build() {
            IcebergScanReportInputDatasetFacet __result = new IcebergScanReportInputDatasetFacet(OpenLineage.this.producer, this.snapshotId, this.filter, this.schemaId, this.projectedFieldNames, this.scanMetrics, this.metadata);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetTypeDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "datasetType", "subType"})
    public static final class DatasetTypeDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String datasetType;
        private final String subType;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasetTypeDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="datasetType") String datasetType, @JsonProperty(value="subType") String subType) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DatasetTypeDatasetFacet.json#/$defs/DatasetTypeDatasetFacet");
            this._deleted = null;
            this.datasetType = datasetType;
            this.subType = subType;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDatasetType() {
            return this.datasetType;
        }

        public String getSubType() {
            return this.subType;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DatasetTypeDatasetFacetBuilder
    implements Builder<DatasetTypeDatasetFacet> {
        private String datasetType;
        private String subType;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasetTypeDatasetFacetBuilder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public DatasetTypeDatasetFacetBuilder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public DatasetTypeDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasetTypeDatasetFacet build() {
            DatasetTypeDatasetFacet __result = new DatasetTypeDatasetFacet(OpenLineage.this.producer, this.datasetType, this.subType);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=Job.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class Job {
        private final String namespace;
        private final String name;
        private final JobFacets facets;

        @JsonCreator
        private Job(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") JobFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public JobFacets getFacets() {
            return this.facets;
        }
    }

    @JsonDeserialize(as=JobFacets.class)
    @JsonPropertyOrder(value={"jobType", "sourceCode", "gcp_lineage", "sql", "ownership", "sourceCodeLocation", "tags", "documentation"})
    public static final class JobFacets {
        private final JobTypeJobFacet jobType;
        private final SourceCodeJobFacet sourceCode;
        private final GcpLineageJobFacet gcp_lineage;
        private final SQLJobFacet sql;
        private final OwnershipJobFacet ownership;
        private final SourceCodeLocationJobFacet sourceCodeLocation;
        private final TagsJobFacet tags;
        private final DocumentationJobFacet documentation;
        @JsonAnySetter
        private final Map<String, JobFacet> additionalProperties;

        @JsonCreator
        private JobFacets(@JsonProperty(value="jobType") JobTypeJobFacet jobType, @JsonProperty(value="sourceCode") SourceCodeJobFacet sourceCode, @JsonProperty(value="gcp_lineage") GcpLineageJobFacet gcp_lineage, @JsonProperty(value="sql") SQLJobFacet sql, @JsonProperty(value="ownership") OwnershipJobFacet ownership, @JsonProperty(value="sourceCodeLocation") SourceCodeLocationJobFacet sourceCodeLocation, @JsonProperty(value="tags") TagsJobFacet tags, @JsonProperty(value="documentation") DocumentationJobFacet documentation) {
            this.jobType = jobType;
            this.sourceCode = sourceCode;
            this.gcp_lineage = gcp_lineage;
            this.sql = sql;
            this.ownership = ownership;
            this.sourceCodeLocation = sourceCodeLocation;
            this.tags = tags;
            this.documentation = documentation;
            this.additionalProperties = new LinkedHashMap<String, JobFacet>();
        }

        public JobTypeJobFacet getJobType() {
            return this.jobType;
        }

        public SourceCodeJobFacet getSourceCode() {
            return this.sourceCode;
        }

        public GcpLineageJobFacet getGcp_lineage() {
            return this.gcp_lineage;
        }

        public SQLJobFacet getSql() {
            return this.sql;
        }

        public OwnershipJobFacet getOwnership() {
            return this.ownership;
        }

        public SourceCodeLocationJobFacet getSourceCodeLocation() {
            return this.sourceCodeLocation;
        }

        public TagsJobFacet getTags() {
            return this.tags;
        }

        public DocumentationJobFacet getDocumentation() {
            return this.documentation;
        }

        @JsonAnyGetter
        public Map<String, JobFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class JobBuilder
    implements Builder<Job> {
        private String namespace;
        private String name;
        private JobFacets facets;

        public JobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public JobBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobBuilder facets(JobFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public Job build() {
            Job __result = new Job(this.namespace, this.name, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetVersionDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "datasetVersion"})
    public static final class DatasetVersionDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String datasetVersion;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasetVersionDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="datasetVersion") String datasetVersion) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/DatasetVersionDatasetFacet.json#/$defs/DatasetVersionDatasetFacet");
            this._deleted = null;
            this.datasetVersion = datasetVersion;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDatasetVersion() {
            return this.datasetVersion;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DatasetVersionDatasetFacetBuilder
    implements Builder<DatasetVersionDatasetFacet> {
        private String datasetVersion;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasetVersionDatasetFacetBuilder datasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        public DatasetVersionDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasetVersionDatasetFacet build() {
            DatasetVersionDatasetFacet __result = new DatasetVersionDatasetFacet(OpenLineage.this.producer, this.datasetVersion);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SymlinksDatasetFacetIdentifiers.class)
    @JsonPropertyOrder(value={"namespace", "name", "type"})
    public static final class SymlinksDatasetFacetIdentifiers {
        private final String namespace;
        private final String name;
        private final String type;

        @JsonCreator
        private SymlinksDatasetFacetIdentifiers(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.namespace = namespace;
            this.name = name;
            this.type = type;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class SymlinksDatasetFacetIdentifiersBuilder
    implements Builder<SymlinksDatasetFacetIdentifiers> {
        private String namespace;
        private String name;
        private String type;

        public SymlinksDatasetFacetIdentifiersBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SymlinksDatasetFacetIdentifiersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SymlinksDatasetFacetIdentifiersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public SymlinksDatasetFacetIdentifiers build() {
            SymlinksDatasetFacetIdentifiers __result = new SymlinksDatasetFacetIdentifiers(this.namespace, this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=IcebergCommitReportOutputDatasetFacetCommitMetrics.class)
    @JsonPropertyOrder(value={"totalDuration", "attempts", "addedDataFiles", "removedDataFiles", "totalDataFiles", "addedDeleteFiles", "addedEqualityDeleteFiles", "addedPositionalDeleteFiles", "addedDVs", "removedDeleteFiles", "removedEqualityDeleteFiles", "removedPositionalDeleteFiles", "removedDVs", "totalDeleteFiles", "addedRecords", "removedRecords", "totalRecords", "addedFilesSizeInBytes", "removedFilesSizeInBytes", "totalFilesSizeInBytes", "addedPositionalDeletes", "removedPositionalDeletes", "totalPositionalDeletes", "addedEqualityDeletes", "removedEqualityDeletes", "totalEqualityDeletes"})
    public static final class IcebergCommitReportOutputDatasetFacetCommitMetrics {
        private final Double totalDuration;
        private final Double attempts;
        private final Double addedDataFiles;
        private final Double removedDataFiles;
        private final Double totalDataFiles;
        private final Double addedDeleteFiles;
        private final Double addedEqualityDeleteFiles;
        private final Double addedPositionalDeleteFiles;
        private final Double addedDVs;
        private final Double removedDeleteFiles;
        private final Double removedEqualityDeleteFiles;
        private final Double removedPositionalDeleteFiles;
        private final Double removedDVs;
        private final Double totalDeleteFiles;
        private final Double addedRecords;
        private final Double removedRecords;
        private final Double totalRecords;
        private final Double addedFilesSizeInBytes;
        private final Double removedFilesSizeInBytes;
        private final Double totalFilesSizeInBytes;
        private final Double addedPositionalDeletes;
        private final Double removedPositionalDeletes;
        private final Double totalPositionalDeletes;
        private final Double addedEqualityDeletes;
        private final Double removedEqualityDeletes;
        private final Double totalEqualityDeletes;

        @JsonCreator
        private IcebergCommitReportOutputDatasetFacetCommitMetrics(@JsonProperty(value="totalDuration") Double totalDuration, @JsonProperty(value="attempts") Double attempts, @JsonProperty(value="addedDataFiles") Double addedDataFiles, @JsonProperty(value="removedDataFiles") Double removedDataFiles, @JsonProperty(value="totalDataFiles") Double totalDataFiles, @JsonProperty(value="addedDeleteFiles") Double addedDeleteFiles, @JsonProperty(value="addedEqualityDeleteFiles") Double addedEqualityDeleteFiles, @JsonProperty(value="addedPositionalDeleteFiles") Double addedPositionalDeleteFiles, @JsonProperty(value="addedDVs") Double addedDVs, @JsonProperty(value="removedDeleteFiles") Double removedDeleteFiles, @JsonProperty(value="removedEqualityDeleteFiles") Double removedEqualityDeleteFiles, @JsonProperty(value="removedPositionalDeleteFiles") Double removedPositionalDeleteFiles, @JsonProperty(value="removedDVs") Double removedDVs, @JsonProperty(value="totalDeleteFiles") Double totalDeleteFiles, @JsonProperty(value="addedRecords") Double addedRecords, @JsonProperty(value="removedRecords") Double removedRecords, @JsonProperty(value="totalRecords") Double totalRecords, @JsonProperty(value="addedFilesSizeInBytes") Double addedFilesSizeInBytes, @JsonProperty(value="removedFilesSizeInBytes") Double removedFilesSizeInBytes, @JsonProperty(value="totalFilesSizeInBytes") Double totalFilesSizeInBytes, @JsonProperty(value="addedPositionalDeletes") Double addedPositionalDeletes, @JsonProperty(value="removedPositionalDeletes") Double removedPositionalDeletes, @JsonProperty(value="totalPositionalDeletes") Double totalPositionalDeletes, @JsonProperty(value="addedEqualityDeletes") Double addedEqualityDeletes, @JsonProperty(value="removedEqualityDeletes") Double removedEqualityDeletes, @JsonProperty(value="totalEqualityDeletes") Double totalEqualityDeletes) {
            this.totalDuration = totalDuration;
            this.attempts = attempts;
            this.addedDataFiles = addedDataFiles;
            this.removedDataFiles = removedDataFiles;
            this.totalDataFiles = totalDataFiles;
            this.addedDeleteFiles = addedDeleteFiles;
            this.addedEqualityDeleteFiles = addedEqualityDeleteFiles;
            this.addedPositionalDeleteFiles = addedPositionalDeleteFiles;
            this.addedDVs = addedDVs;
            this.removedDeleteFiles = removedDeleteFiles;
            this.removedEqualityDeleteFiles = removedEqualityDeleteFiles;
            this.removedPositionalDeleteFiles = removedPositionalDeleteFiles;
            this.removedDVs = removedDVs;
            this.totalDeleteFiles = totalDeleteFiles;
            this.addedRecords = addedRecords;
            this.removedRecords = removedRecords;
            this.totalRecords = totalRecords;
            this.addedFilesSizeInBytes = addedFilesSizeInBytes;
            this.removedFilesSizeInBytes = removedFilesSizeInBytes;
            this.totalFilesSizeInBytes = totalFilesSizeInBytes;
            this.addedPositionalDeletes = addedPositionalDeletes;
            this.removedPositionalDeletes = removedPositionalDeletes;
            this.totalPositionalDeletes = totalPositionalDeletes;
            this.addedEqualityDeletes = addedEqualityDeletes;
            this.removedEqualityDeletes = removedEqualityDeletes;
            this.totalEqualityDeletes = totalEqualityDeletes;
        }

        public Double getTotalDuration() {
            return this.totalDuration;
        }

        public Double getAttempts() {
            return this.attempts;
        }

        public Double getAddedDataFiles() {
            return this.addedDataFiles;
        }

        public Double getRemovedDataFiles() {
            return this.removedDataFiles;
        }

        public Double getTotalDataFiles() {
            return this.totalDataFiles;
        }

        public Double getAddedDeleteFiles() {
            return this.addedDeleteFiles;
        }

        public Double getAddedEqualityDeleteFiles() {
            return this.addedEqualityDeleteFiles;
        }

        public Double getAddedPositionalDeleteFiles() {
            return this.addedPositionalDeleteFiles;
        }

        public Double getAddedDVs() {
            return this.addedDVs;
        }

        public Double getRemovedDeleteFiles() {
            return this.removedDeleteFiles;
        }

        public Double getRemovedEqualityDeleteFiles() {
            return this.removedEqualityDeleteFiles;
        }

        public Double getRemovedPositionalDeleteFiles() {
            return this.removedPositionalDeleteFiles;
        }

        public Double getRemovedDVs() {
            return this.removedDVs;
        }

        public Double getTotalDeleteFiles() {
            return this.totalDeleteFiles;
        }

        public Double getAddedRecords() {
            return this.addedRecords;
        }

        public Double getRemovedRecords() {
            return this.removedRecords;
        }

        public Double getTotalRecords() {
            return this.totalRecords;
        }

        public Double getAddedFilesSizeInBytes() {
            return this.addedFilesSizeInBytes;
        }

        public Double getRemovedFilesSizeInBytes() {
            return this.removedFilesSizeInBytes;
        }

        public Double getTotalFilesSizeInBytes() {
            return this.totalFilesSizeInBytes;
        }

        public Double getAddedPositionalDeletes() {
            return this.addedPositionalDeletes;
        }

        public Double getRemovedPositionalDeletes() {
            return this.removedPositionalDeletes;
        }

        public Double getTotalPositionalDeletes() {
            return this.totalPositionalDeletes;
        }

        public Double getAddedEqualityDeletes() {
            return this.addedEqualityDeletes;
        }

        public Double getRemovedEqualityDeletes() {
            return this.removedEqualityDeletes;
        }

        public Double getTotalEqualityDeletes() {
            return this.totalEqualityDeletes;
        }
    }

    @JsonDeserialize(as=IcebergCommitReportOutputDatasetFacetMetadata.class)
    @JsonPropertyOrder
    public static final class IcebergCommitReportOutputDatasetFacetMetadata {
        @JsonAnySetter
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        @JsonCreator
        private IcebergCommitReportOutputDatasetFacetMetadata() {
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class IcebergCommitReportOutputDatasetFacetBuilder
    implements Builder<IcebergCommitReportOutputDatasetFacet> {
        private Double snapshotId;
        private Double sequenceNumber;
        private String operation;
        private IcebergCommitReportOutputDatasetFacetCommitMetrics commitMetrics;
        private IcebergCommitReportOutputDatasetFacetMetadata metadata;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public IcebergCommitReportOutputDatasetFacetBuilder snapshotId(Double snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetBuilder sequenceNumber(Double sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetBuilder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetBuilder commitMetrics(IcebergCommitReportOutputDatasetFacetCommitMetrics commitMetrics) {
            this.commitMetrics = commitMetrics;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetBuilder metadata(IcebergCommitReportOutputDatasetFacetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public IcebergCommitReportOutputDatasetFacet build() {
            IcebergCommitReportOutputDatasetFacet __result = new IcebergCommitReportOutputDatasetFacet(OpenLineage.this.producer, this.snapshotId, this.sequenceNumber, this.operation, this.commitMetrics, this.metadata);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=TagsJobFacetFields.class)
    @JsonPropertyOrder(value={"key", "value", "source"})
    public static final class TagsJobFacetFields {
        private final String key;
        private final String value;
        private final String source;

        @JsonCreator
        private TagsJobFacetFields(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="source") String source) {
            this.key = key;
            this.value = value;
            this.source = source;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getSource() {
            return this.source;
        }
    }

    public static final class TagsJobFacetFieldsBuilder
    implements Builder<TagsJobFacetFields> {
        private String key;
        private String value;
        private String source;

        public TagsJobFacetFieldsBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagsJobFacetFieldsBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TagsJobFacetFieldsBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public TagsJobFacetFields build() {
            TagsJobFacetFields __result = new TagsJobFacetFields(this.key, this.value, this.source);
            return __result;
        }
    }

    public static class DefaultOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/OutputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=StaticDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class StaticDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;

        @JsonCreator
        private StaticDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }
    }

    public static final class StaticDatasetBuilder
    implements Builder<StaticDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;

        public StaticDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public StaticDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StaticDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public StaticDataset build() {
            StaticDataset __result = new StaticDataset(this.namespace, this.name, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=TagsRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "tags"})
    public static final class TagsRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<TagsRunFacetFields> tags;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private TagsRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="tags") List<TagsRunFacetFields> tags) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/TagsRunFacet.json#/$defs/TagsRunFacet");
            this.tags = tags;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<TagsRunFacetFields> getTags() {
            return this.tags;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class TagsRunFacetBuilder
    implements Builder<TagsRunFacet> {
        private List<TagsRunFacetFields> tags;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public TagsRunFacetBuilder tags(List<TagsRunFacetFields> tags) {
            this.tags = tags;
            return this;
        }

        public TagsRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public TagsRunFacet build() {
            TagsRunFacet __result = new TagsRunFacet(OpenLineage.this.producer, this.tags);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=LifecycleStateChangeDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "lifecycleStateChange", "previousIdentifier"})
    public static final class LifecycleStateChangeDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final LifecycleStateChange lifecycleStateChange;
        private final LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private LifecycleStateChangeDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="lifecycleStateChange") LifecycleStateChange lifecycleStateChange, @JsonProperty(value="previousIdentifier") LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/LifecycleStateChangeDatasetFacet.json#/$defs/LifecycleStateChangeDatasetFacet");
            this._deleted = null;
            this.lifecycleStateChange = lifecycleStateChange;
            this.previousIdentifier = previousIdentifier;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public LifecycleStateChange getLifecycleStateChange() {
            return this.lifecycleStateChange;
        }

        public LifecycleStateChangeDatasetFacetPreviousIdentifier getPreviousIdentifier() {
            return this.previousIdentifier;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }

        public static enum LifecycleStateChange {
            ALTER,
            CREATE,
            DROP,
            OVERWRITE,
            RENAME,
            TRUNCATE;

        }
    }

    @JsonDeserialize(as=LifecycleStateChangeDatasetFacetPreviousIdentifier.class)
    @JsonPropertyOrder(value={"name", "namespace"})
    public static final class LifecycleStateChangeDatasetFacetPreviousIdentifier {
        private final String name;
        private final String namespace;

        @JsonCreator
        private LifecycleStateChangeDatasetFacetPreviousIdentifier(@JsonProperty(value="name") String name, @JsonProperty(value="namespace") String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public final class LifecycleStateChangeDatasetFacetBuilder
    implements Builder<LifecycleStateChangeDatasetFacet> {
        private LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange;
        private LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public LifecycleStateChangeDatasetFacetBuilder lifecycleStateChange(LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange) {
            this.lifecycleStateChange = lifecycleStateChange;
            return this;
        }

        public LifecycleStateChangeDatasetFacetBuilder previousIdentifier(LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
            this.previousIdentifier = previousIdentifier;
            return this;
        }

        public LifecycleStateChangeDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public LifecycleStateChangeDatasetFacet build() {
            LifecycleStateChangeDatasetFacet __result = new LifecycleStateChangeDatasetFacet(OpenLineage.this.producer, this.lifecycleStateChange, this.previousIdentifier);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=RunEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "eventType", "run", "job", "inputs", "outputs"})
    public static final class RunEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final EventType eventType;
        private final Run run;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;

        @JsonCreator
        private RunEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="eventType") EventType eventType, @JsonProperty(value="run") Run run, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/RunEvent");
            this.eventType = eventType;
            this.run = run;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Run getRun() {
            return this.run;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        public static enum EventType {
            START,
            RUNNING,
            COMPLETE,
            ABORT,
            FAIL,
            OTHER;

        }
    }

    public final class RunEventBuilder
    implements Builder<RunEvent> {
        private ZonedDateTime eventTime;
        private RunEvent.EventType eventType;
        private Run run;
        private Job job;
        private List<InputDataset> inputs;
        private List<OutputDataset> outputs;

        public RunEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public RunEventBuilder eventType(RunEvent.EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public RunEventBuilder run(Run run) {
            this.run = run;
            return this;
        }

        public RunEventBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public RunEventBuilder inputs(List<InputDataset> inputs) {
            this.inputs = inputs;
            return this;
        }

        public RunEventBuilder outputs(List<OutputDataset> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Override
        public RunEvent build() {
            RunEvent __result = new RunEvent(this.eventTime, OpenLineage.this.producer, this.eventType, this.run, this.job, this.inputs, this.outputs);
            return __result;
        }
    }

    public static final class IcebergCommitReportOutputDatasetFacetMetadataBuilder
    implements Builder<IcebergCommitReportOutputDatasetFacetMetadata> {
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public IcebergCommitReportOutputDatasetFacetMetadataBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public IcebergCommitReportOutputDatasetFacetMetadata build() {
            IcebergCommitReportOutputDatasetFacetMetadata __result = new IcebergCommitReportOutputDatasetFacetMetadata();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=TagsDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "tags"})
    public static final class TagsDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<TagsDatasetFacetFields> tags;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private TagsDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="tags") List<TagsDatasetFacetFields> tags) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/TagsDatasetFacet.json#/$defs/TagsDatasetFacet");
            this._deleted = null;
            this.tags = tags;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<TagsDatasetFacetFields> getTags() {
            return this.tags;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class TagsDatasetFacetBuilder
    implements Builder<TagsDatasetFacet> {
        private List<TagsDatasetFacetFields> tags;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public TagsDatasetFacetBuilder tags(List<TagsDatasetFacetFields> tags) {
            this.tags = tags;
            return this;
        }

        public TagsDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public TagsDatasetFacet build() {
            TagsDatasetFacet __result = new TagsDatasetFacet(OpenLineage.this.producer, this.tags);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static class DefaultRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultRunFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/RunFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=OwnershipJobFacetOwners.class)
    @JsonPropertyOrder(value={"name", "type"})
    public static final class OwnershipJobFacetOwners {
        private final String name;
        private final String type;

        @JsonCreator
        private OwnershipJobFacetOwners(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class OwnershipJobFacetOwnersBuilder
    implements Builder<OwnershipJobFacetOwners> {
        private String name;
        private String type;

        public OwnershipJobFacetOwnersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OwnershipJobFacetOwnersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public OwnershipJobFacetOwners build() {
            OwnershipJobFacetOwners __result = new OwnershipJobFacetOwners(this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=GcpLineageJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "displayName", "origin"})
    public static final class GcpLineageJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String displayName;
        private final GcpLineageJobFacetOrigin origin;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private GcpLineageJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="origin") GcpLineageJobFacetOrigin origin) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/GcpLineageJobFacet.json#/$defs/GcpLineageJobFacet");
            this._deleted = null;
            this.displayName = displayName;
            this.origin = origin;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public GcpLineageJobFacetOrigin getOrigin() {
            return this.origin;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=GcpLineageJobFacetOrigin.class)
    @JsonPropertyOrder(value={"sourceType", "name"})
    public static final class GcpLineageJobFacetOrigin {
        private final String sourceType;
        private final String name;

        @JsonCreator
        private GcpLineageJobFacetOrigin(@JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="name") String name) {
            this.sourceType = sourceType;
            this.name = name;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getName() {
            return this.name;
        }
    }

    public final class GcpLineageJobFacetBuilder
    implements Builder<GcpLineageJobFacet> {
        private String displayName;
        private GcpLineageJobFacetOrigin origin;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public GcpLineageJobFacetBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GcpLineageJobFacetBuilder origin(GcpLineageJobFacetOrigin origin) {
            this.origin = origin;
            return this;
        }

        public GcpLineageJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public GcpLineageJobFacet build() {
            GcpLineageJobFacet __result = new GcpLineageJobFacet(OpenLineage.this.producer, this.displayName, this.origin);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=JobEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "job", "inputs", "outputs"})
    public static final class JobEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;

        @JsonCreator
        private JobEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/JobEvent");
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }
    }

    public final class JobEventBuilder
    implements Builder<JobEvent> {
        private ZonedDateTime eventTime;
        private Job job;
        private List<InputDataset> inputs;
        private List<OutputDataset> outputs;

        public JobEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public JobEventBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public JobEventBuilder inputs(List<InputDataset> inputs) {
            this.inputs = inputs;
            return this;
        }

        public JobEventBuilder outputs(List<OutputDataset> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Override
        public JobEvent build() {
            JobEvent __result = new JobEvent(this.eventTime, OpenLineage.this.producer, this.job, this.inputs, this.outputs);
            return __result;
        }
    }

    @JsonDeserialize(as=OwnershipDatasetFacetOwners.class)
    @JsonPropertyOrder(value={"name", "type"})
    public static final class OwnershipDatasetFacetOwners {
        private final String name;
        private final String type;

        @JsonCreator
        private OwnershipDatasetFacetOwners(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class OwnershipDatasetFacetOwnersBuilder
    implements Builder<OwnershipDatasetFacetOwners> {
        private String name;
        private String type;

        public OwnershipDatasetFacetOwnersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OwnershipDatasetFacetOwnersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public OwnershipDatasetFacetOwners build() {
            OwnershipDatasetFacetOwners __result = new OwnershipDatasetFacetOwners(this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=ExtractionErrorRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "totalTasks", "failedTasks", "errors"})
    public static final class ExtractionErrorRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long totalTasks;
        private final Long failedTasks;
        private final List<ExtractionErrorRunFacetErrors> errors;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ExtractionErrorRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="totalTasks") Long totalTasks, @JsonProperty(value="failedTasks") Long failedTasks, @JsonProperty(value="errors") List<ExtractionErrorRunFacetErrors> errors) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-1-2/ExtractionErrorRunFacet.json#/$defs/ExtractionErrorRunFacet");
            this.totalTasks = totalTasks;
            this.failedTasks = failedTasks;
            this.errors = errors;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getTotalTasks() {
            return this.totalTasks;
        }

        public Long getFailedTasks() {
            return this.failedTasks;
        }

        public List<ExtractionErrorRunFacetErrors> getErrors() {
            return this.errors;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ExtractionErrorRunFacetBuilder
    implements Builder<ExtractionErrorRunFacet> {
        private Long totalTasks;
        private Long failedTasks;
        private List<ExtractionErrorRunFacetErrors> errors;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ExtractionErrorRunFacetBuilder totalTasks(Long totalTasks) {
            this.totalTasks = totalTasks;
            return this;
        }

        public ExtractionErrorRunFacetBuilder failedTasks(Long failedTasks) {
            this.failedTasks = failedTasks;
            return this;
        }

        public ExtractionErrorRunFacetBuilder errors(List<ExtractionErrorRunFacetErrors> errors) {
            this.errors = errors;
            return this;
        }

        public ExtractionErrorRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ExtractionErrorRunFacet build() {
            ExtractionErrorRunFacet __result = new ExtractionErrorRunFacet(OpenLineage.this.producer, this.totalTasks, this.failedTasks, this.errors);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetrics> {
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder put(String key, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetrics build() {
            DataQualityMetricsInputDatasetFacetColumnMetrics __result = new DataQualityMetricsInputDatasetFacetColumnMetrics();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=InputField.class)
    @JsonPropertyOrder(value={"namespace", "name", "field", "transformations"})
    public static final class InputField {
        private final String namespace;
        private final String name;
        private final String field;
        private final List<InputFieldTransformations> transformations;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private InputField(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="field") String field, @JsonProperty(value="transformations") List<InputFieldTransformations> transformations) {
            this.namespace = namespace;
            this.name = name;
            this.field = field;
            this.transformations = transformations;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getField() {
            return this.field;
        }

        public List<InputFieldTransformations> getTransformations() {
            return this.transformations;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class InputFieldBuilder
    implements Builder<InputField> {
        private String namespace;
        private String name;
        private String field;
        private List<InputFieldTransformations> transformations;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public InputFieldBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InputFieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputFieldBuilder field(String field) {
            this.field = field;
            return this;
        }

        public InputFieldBuilder transformations(List<InputFieldTransformations> transformations) {
            this.transformations = transformations;
            return this;
        }

        public InputFieldBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public InputField build() {
            InputField __result = new InputField(this.namespace, this.name, this.field, this.transformations);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class InputStatisticsInputDatasetFacetBuilder
    implements Builder<InputStatisticsInputDatasetFacet> {
        private Long rowCount;
        private Long size;
        private Long fileCount;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public InputStatisticsInputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public InputStatisticsInputDatasetFacetBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public InputStatisticsInputDatasetFacetBuilder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public InputStatisticsInputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public InputStatisticsInputDatasetFacet build() {
            InputStatisticsInputDatasetFacet __result = new InputStatisticsInputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.size, this.fileCount);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SourceCodeJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "language", "sourceCode"})
    public static final class SourceCodeJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String language;
        private final String sourceCode;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SourceCodeJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="language") String language, @JsonProperty(value="sourceCode") String sourceCode) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/SourceCodeJobFacet.json#/$defs/SourceCodeJobFacet");
            this._deleted = null;
            this.language = language;
            this.sourceCode = sourceCode;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=OwnershipJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "owners"})
    public static final class OwnershipJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<OwnershipJobFacetOwners> owners;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OwnershipJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="owners") List<OwnershipJobFacetOwners> owners) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/OwnershipJobFacet.json#/$defs/OwnershipJobFacet");
            this._deleted = null;
            this.owners = owners;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<OwnershipJobFacetOwners> getOwners() {
            return this.owners;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=TagsJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "tags"})
    public static final class TagsJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<TagsJobFacetFields> tags;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private TagsJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="tags") List<TagsJobFacetFields> tags) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/TagsJobFacet.json#/$defs/TagsJobFacet");
            this._deleted = null;
            this.tags = tags;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<TagsJobFacetFields> getTags() {
            return this.tags;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class JobFacetsBuilder
    implements Builder<JobFacets> {
        private JobTypeJobFacet jobType;
        private SourceCodeJobFacet sourceCode;
        private GcpLineageJobFacet gcp_lineage;
        private SQLJobFacet sql;
        private OwnershipJobFacet ownership;
        private SourceCodeLocationJobFacet sourceCodeLocation;
        private TagsJobFacet tags;
        private DocumentationJobFacet documentation;
        private final Map<String, JobFacet> additionalProperties = new LinkedHashMap<String, JobFacet>();

        public JobFacetsBuilder jobType(JobTypeJobFacet jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobFacetsBuilder sourceCode(SourceCodeJobFacet sourceCode) {
            this.sourceCode = sourceCode;
            return this;
        }

        public JobFacetsBuilder gcp_lineage(GcpLineageJobFacet gcp_lineage) {
            this.gcp_lineage = gcp_lineage;
            return this;
        }

        public JobFacetsBuilder sql(SQLJobFacet sql) {
            this.sql = sql;
            return this;
        }

        public JobFacetsBuilder ownership(OwnershipJobFacet ownership) {
            this.ownership = ownership;
            return this;
        }

        public JobFacetsBuilder sourceCodeLocation(SourceCodeLocationJobFacet sourceCodeLocation) {
            this.sourceCodeLocation = sourceCodeLocation;
            return this;
        }

        public JobFacetsBuilder tags(TagsJobFacet tags) {
            this.tags = tags;
            return this;
        }

        public JobFacetsBuilder documentation(DocumentationJobFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public JobFacetsBuilder put(String key, JobFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public JobFacets build() {
            JobFacets __result = new JobFacets(this.jobType, this.sourceCode, this.gcp_lineage, this.sql, this.ownership, this.sourceCodeLocation, this.tags, this.documentation);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder
    implements Builder<IcebergCommitReportOutputDatasetFacetCommitMetrics> {
        private Double totalDuration;
        private Double attempts;
        private Double addedDataFiles;
        private Double removedDataFiles;
        private Double totalDataFiles;
        private Double addedDeleteFiles;
        private Double addedEqualityDeleteFiles;
        private Double addedPositionalDeleteFiles;
        private Double addedDVs;
        private Double removedDeleteFiles;
        private Double removedEqualityDeleteFiles;
        private Double removedPositionalDeleteFiles;
        private Double removedDVs;
        private Double totalDeleteFiles;
        private Double addedRecords;
        private Double removedRecords;
        private Double totalRecords;
        private Double addedFilesSizeInBytes;
        private Double removedFilesSizeInBytes;
        private Double totalFilesSizeInBytes;
        private Double addedPositionalDeletes;
        private Double removedPositionalDeletes;
        private Double totalPositionalDeletes;
        private Double addedEqualityDeletes;
        private Double removedEqualityDeletes;
        private Double totalEqualityDeletes;

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalDuration(Double totalDuration) {
            this.totalDuration = totalDuration;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder attempts(Double attempts) {
            this.attempts = attempts;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedDataFiles(Double addedDataFiles) {
            this.addedDataFiles = addedDataFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedDataFiles(Double removedDataFiles) {
            this.removedDataFiles = removedDataFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalDataFiles(Double totalDataFiles) {
            this.totalDataFiles = totalDataFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedDeleteFiles(Double addedDeleteFiles) {
            this.addedDeleteFiles = addedDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedEqualityDeleteFiles(Double addedEqualityDeleteFiles) {
            this.addedEqualityDeleteFiles = addedEqualityDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedPositionalDeleteFiles(Double addedPositionalDeleteFiles) {
            this.addedPositionalDeleteFiles = addedPositionalDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedDVs(Double addedDVs) {
            this.addedDVs = addedDVs;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedDeleteFiles(Double removedDeleteFiles) {
            this.removedDeleteFiles = removedDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedEqualityDeleteFiles(Double removedEqualityDeleteFiles) {
            this.removedEqualityDeleteFiles = removedEqualityDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedPositionalDeleteFiles(Double removedPositionalDeleteFiles) {
            this.removedPositionalDeleteFiles = removedPositionalDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedDVs(Double removedDVs) {
            this.removedDVs = removedDVs;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalDeleteFiles(Double totalDeleteFiles) {
            this.totalDeleteFiles = totalDeleteFiles;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedRecords(Double addedRecords) {
            this.addedRecords = addedRecords;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedRecords(Double removedRecords) {
            this.removedRecords = removedRecords;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalRecords(Double totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedFilesSizeInBytes(Double addedFilesSizeInBytes) {
            this.addedFilesSizeInBytes = addedFilesSizeInBytes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedFilesSizeInBytes(Double removedFilesSizeInBytes) {
            this.removedFilesSizeInBytes = removedFilesSizeInBytes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalFilesSizeInBytes(Double totalFilesSizeInBytes) {
            this.totalFilesSizeInBytes = totalFilesSizeInBytes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedPositionalDeletes(Double addedPositionalDeletes) {
            this.addedPositionalDeletes = addedPositionalDeletes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedPositionalDeletes(Double removedPositionalDeletes) {
            this.removedPositionalDeletes = removedPositionalDeletes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalPositionalDeletes(Double totalPositionalDeletes) {
            this.totalPositionalDeletes = totalPositionalDeletes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder addedEqualityDeletes(Double addedEqualityDeletes) {
            this.addedEqualityDeletes = addedEqualityDeletes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder removedEqualityDeletes(Double removedEqualityDeletes) {
            this.removedEqualityDeletes = removedEqualityDeletes;
            return this;
        }

        public IcebergCommitReportOutputDatasetFacetCommitMetricsBuilder totalEqualityDeletes(Double totalEqualityDeletes) {
            this.totalEqualityDeletes = totalEqualityDeletes;
            return this;
        }

        @Override
        public IcebergCommitReportOutputDatasetFacetCommitMetrics build() {
            IcebergCommitReportOutputDatasetFacetCommitMetrics __result = new IcebergCommitReportOutputDatasetFacetCommitMetrics(this.totalDuration, this.attempts, this.addedDataFiles, this.removedDataFiles, this.totalDataFiles, this.addedDeleteFiles, this.addedEqualityDeleteFiles, this.addedPositionalDeleteFiles, this.addedDVs, this.removedDeleteFiles, this.removedEqualityDeleteFiles, this.removedPositionalDeleteFiles, this.removedDVs, this.totalDeleteFiles, this.addedRecords, this.removedRecords, this.totalRecords, this.addedFilesSizeInBytes, this.removedFilesSizeInBytes, this.totalFilesSizeInBytes, this.addedPositionalDeletes, this.removedPositionalDeletes, this.totalPositionalDeletes, this.addedEqualityDeletes, this.removedEqualityDeletes, this.totalEqualityDeletes);
            return __result;
        }
    }

    public static class DefaultDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_deleted") Boolean _deleted) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/DatasetFacet");
            this._deleted = _deleted;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=OwnershipDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "owners"})
    public static final class OwnershipDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<OwnershipDatasetFacetOwners> owners;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OwnershipDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="owners") List<OwnershipDatasetFacetOwners> owners) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/OwnershipDatasetFacet.json#/$defs/OwnershipDatasetFacet");
            this._deleted = null;
            this.owners = owners;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<OwnershipDatasetFacetOwners> getOwners() {
            return this.owners;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class OwnershipDatasetFacetBuilder
    implements Builder<OwnershipDatasetFacet> {
        private List<OwnershipDatasetFacetOwners> owners;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OwnershipDatasetFacetBuilder owners(List<OwnershipDatasetFacetOwners> owners) {
            this.owners = owners;
            return this;
        }

        public OwnershipDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OwnershipDatasetFacet build() {
            OwnershipDatasetFacet __result = new OwnershipDatasetFacet(OpenLineage.this.producer, this.owners);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=EnvironmentVariablesRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "environmentVariables"})
    public static final class EnvironmentVariablesRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<EnvironmentVariable> environmentVariables;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private EnvironmentVariablesRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="environmentVariables") List<EnvironmentVariable> environmentVariables) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/EnvironmentVariablesRunFacet.json#/$defs/EnvironmentVariablesRunFacet");
            this.environmentVariables = environmentVariables;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<EnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class EnvironmentVariablesRunFacetBuilder
    implements Builder<EnvironmentVariablesRunFacet> {
        private List<EnvironmentVariable> environmentVariables;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public EnvironmentVariablesRunFacetBuilder environmentVariables(List<EnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public EnvironmentVariablesRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public EnvironmentVariablesRunFacet build() {
            EnvironmentVariablesRunFacet __result = new EnvironmentVariablesRunFacet(OpenLineage.this.producer, this.environmentVariables);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasourceDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "name", "uri"})
    public static final class DatasourceDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String name;
        private final URI uri;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasourceDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="name") String name, @JsonProperty(value="uri") URI uri) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/DatasourceDatasetFacet.json#/$defs/DatasourceDatasetFacet");
            this._deleted = null;
            this.name = name;
            this.uri = uri;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=StorageDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "storageLayer", "fileFormat"})
    public static final class StorageDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String storageLayer;
        private final String fileFormat;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private StorageDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="storageLayer") String storageLayer, @JsonProperty(value="fileFormat") String fileFormat) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/StorageDatasetFacet.json#/$defs/StorageDatasetFacet");
            this._deleted = null;
            this.storageLayer = storageLayer;
            this.fileFormat = fileFormat;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getStorageLayer() {
            return this.storageLayer;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "fields", "dataset"})
    public static final class ColumnLineageDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final ColumnLineageDatasetFacetFields fields;
        private final List<InputField> dataset;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ColumnLineageDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="fields") ColumnLineageDatasetFacetFields fields, @JsonProperty(value="dataset") List<InputField> dataset) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-2-0/ColumnLineageDatasetFacet.json#/$defs/ColumnLineageDatasetFacet");
            this._deleted = null;
            this.fields = fields;
            this.dataset = dataset;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public ColumnLineageDatasetFacetFields getFields() {
            return this.fields;
        }

        public List<InputField> getDataset() {
            return this.dataset;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=SchemaDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "fields"})
    public static final class SchemaDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<SchemaDatasetFacetFields> fields;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SchemaDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="fields") List<SchemaDatasetFacetFields> fields) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-1-1/SchemaDatasetFacet.json#/$defs/SchemaDatasetFacet");
            this._deleted = null;
            this.fields = fields;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<SchemaDatasetFacetFields> getFields() {
            return this.fields;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=SymlinksDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "identifiers"})
    public static final class SymlinksDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<SymlinksDatasetFacetIdentifiers> identifiers;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SymlinksDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="identifiers") List<SymlinksDatasetFacetIdentifiers> identifiers) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/SymlinksDatasetFacet.json#/$defs/SymlinksDatasetFacet");
            this._deleted = null;
            this.identifiers = identifiers;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<SymlinksDatasetFacetIdentifiers> getIdentifiers() {
            return this.identifiers;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DatasetFacetsBuilder
    implements Builder<DatasetFacets> {
        private DatasourceDatasetFacet dataSource;
        private DatasetVersionDatasetFacet version;
        private DatasetTypeDatasetFacet datasetType;
        private StorageDatasetFacet storage;
        private ColumnLineageDatasetFacet columnLineage;
        private LifecycleStateChangeDatasetFacet lifecycleStateChange;
        private TagsDatasetFacet tags;
        private DocumentationDatasetFacet documentation;
        private SchemaDatasetFacet schema;
        private OwnershipDatasetFacet ownership;
        private SymlinksDatasetFacet symlinks;
        private final Map<String, DatasetFacet> additionalProperties = new LinkedHashMap<String, DatasetFacet>();

        public DatasetFacetsBuilder dataSource(DatasourceDatasetFacet dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DatasetFacetsBuilder version(DatasetVersionDatasetFacet version) {
            this.version = version;
            return this;
        }

        public DatasetFacetsBuilder datasetType(DatasetTypeDatasetFacet datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public DatasetFacetsBuilder storage(StorageDatasetFacet storage) {
            this.storage = storage;
            return this;
        }

        public DatasetFacetsBuilder columnLineage(ColumnLineageDatasetFacet columnLineage) {
            this.columnLineage = columnLineage;
            return this;
        }

        public DatasetFacetsBuilder lifecycleStateChange(LifecycleStateChangeDatasetFacet lifecycleStateChange) {
            this.lifecycleStateChange = lifecycleStateChange;
            return this;
        }

        public DatasetFacetsBuilder tags(TagsDatasetFacet tags) {
            this.tags = tags;
            return this;
        }

        public DatasetFacetsBuilder documentation(DocumentationDatasetFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public DatasetFacetsBuilder schema(SchemaDatasetFacet schema) {
            this.schema = schema;
            return this;
        }

        public DatasetFacetsBuilder ownership(OwnershipDatasetFacet ownership) {
            this.ownership = ownership;
            return this;
        }

        public DatasetFacetsBuilder symlinks(SymlinksDatasetFacet symlinks) {
            this.symlinks = symlinks;
            return this;
        }

        public DatasetFacetsBuilder put(String key, DatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasetFacets build() {
            DatasetFacets __result = new DatasetFacets(this.dataSource, this.version, this.datasetType, this.storage, this.columnLineage, this.lifecycleStateChange, this.tags, this.documentation, this.schema, this.ownership, this.symlinks);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class OwnershipJobFacetBuilder
    implements Builder<OwnershipJobFacet> {
        private List<OwnershipJobFacetOwners> owners;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OwnershipJobFacetBuilder owners(List<OwnershipJobFacetOwners> owners) {
            this.owners = owners;
            return this;
        }

        public OwnershipJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OwnershipJobFacet build() {
            OwnershipJobFacet __result = new OwnershipJobFacet(OpenLineage.this.producer, this.owners);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class ParentRunFacetJobBuilder
    implements Builder<ParentRunFacetJob> {
        private String namespace;
        private String name;

        public ParentRunFacetJobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ParentRunFacetJobBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ParentRunFacetJob build() {
            ParentRunFacetJob __result = new ParentRunFacetJob(this.namespace, this.name);
            return __result;
        }
    }

    public static final class GcpLineageJobFacetOriginBuilder
    implements Builder<GcpLineageJobFacetOrigin> {
        private String sourceType;
        private String name;

        public GcpLineageJobFacetOriginBuilder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public GcpLineageJobFacetOriginBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GcpLineageJobFacetOrigin build() {
            GcpLineageJobFacetOrigin __result = new GcpLineageJobFacetOrigin(this.sourceType, this.name);
            return __result;
        }
    }

    @JsonDeserialize(as=ErrorMessageRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "message", "programmingLanguage", "stackTrace"})
    public static final class ErrorMessageRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String message;
        private final String programmingLanguage;
        private final String stackTrace;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ErrorMessageRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="message") String message, @JsonProperty(value="programmingLanguage") String programmingLanguage, @JsonProperty(value="stackTrace") String stackTrace) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/ErrorMessageRunFacet.json#/$defs/ErrorMessageRunFacet");
            this.message = message;
            this.programmingLanguage = programmingLanguage;
            this.stackTrace = stackTrace;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getMessage() {
            return this.message;
        }

        public String getProgrammingLanguage() {
            return this.programmingLanguage;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ErrorMessageRunFacetBuilder
    implements Builder<ErrorMessageRunFacet> {
        private String message;
        private String programmingLanguage;
        private String stackTrace;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ErrorMessageRunFacetBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorMessageRunFacetBuilder programmingLanguage(String programmingLanguage) {
            this.programmingLanguage = programmingLanguage;
            return this;
        }

        public ErrorMessageRunFacetBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public ErrorMessageRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ErrorMessageRunFacet build() {
            ErrorMessageRunFacet __result = new ErrorMessageRunFacet(OpenLineage.this.producer, this.message, this.programmingLanguage, this.stackTrace);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static class DefaultJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_deleted") Boolean _deleted) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/JobFacet");
            this._deleted = _deleted;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=GcpDataprocRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "appId", "appName", "batchId", "batchUuid", "clusterName", "clusterUuid", "jobId", "jobUuid", "projectId", "queryNodeName", "jobType", "sessionId", "sessionUuid"})
    public static final class GcpDataprocRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String appId;
        private final String appName;
        private final String batchId;
        private final String batchUuid;
        private final String clusterName;
        private final String clusterUuid;
        private final String jobId;
        private final String jobUuid;
        private final String projectId;
        private final String queryNodeName;
        private final String jobType;
        private final String sessionId;
        private final String sessionUuid;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private GcpDataprocRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="appId") String appId, @JsonProperty(value="appName") String appName, @JsonProperty(value="batchId") String batchId, @JsonProperty(value="batchUuid") String batchUuid, @JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="clusterUuid") String clusterUuid, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="jobUuid") String jobUuid, @JsonProperty(value="projectId") String projectId, @JsonProperty(value="queryNodeName") String queryNodeName, @JsonProperty(value="jobType") String jobType, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="sessionUuid") String sessionUuid) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/GcpDataprocRunFacet.json#/$defs/GcpDataprocRunFacet");
            this.appId = appId;
            this.appName = appName;
            this.batchId = batchId;
            this.batchUuid = batchUuid;
            this.clusterName = clusterName;
            this.clusterUuid = clusterUuid;
            this.jobId = jobId;
            this.jobUuid = jobUuid;
            this.projectId = projectId;
            this.queryNodeName = queryNodeName;
            this.jobType = jobType;
            this.sessionId = sessionId;
            this.sessionUuid = sessionUuid;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getBatchId() {
            return this.batchId;
        }

        public String getBatchUuid() {
            return this.batchUuid;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getClusterUuid() {
            return this.clusterUuid;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getJobUuid() {
            return this.jobUuid;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getQueryNodeName() {
            return this.queryNodeName;
        }

        public String getJobType() {
            return this.jobType;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getSessionUuid() {
            return this.sessionUuid;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=ProcessingEngineRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "version", "name", "openlineageAdapterVersion"})
    public static final class ProcessingEngineRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String version;
        private final String name;
        private final String openlineageAdapterVersion;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ProcessingEngineRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="version") String version, @JsonProperty(value="name") String name, @JsonProperty(value="openlineageAdapterVersion") String openlineageAdapterVersion) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-1-1/ProcessingEngineRunFacet.json#/$defs/ProcessingEngineRunFacet");
            this.version = version;
            this.name = name;
            this.openlineageAdapterVersion = openlineageAdapterVersion;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }

        public String getOpenlineageAdapterVersion() {
            return this.openlineageAdapterVersion;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class RunFacetsBuilder
    implements Builder<RunFacets> {
        private ExternalQueryRunFacet externalQuery;
        private GcpDataprocRunFacet gcp_dataproc;
        private ExtractionErrorRunFacet extractionError;
        private ParentRunFacet parent;
        private NominalTimeRunFacet nominalTime;
        private TagsRunFacet tags;
        private ErrorMessageRunFacet errorMessage;
        private EnvironmentVariablesRunFacet environmentVariables;
        private ProcessingEngineRunFacet processing_engine;
        private final Map<String, RunFacet> additionalProperties = new LinkedHashMap<String, RunFacet>();

        public RunFacetsBuilder externalQuery(ExternalQueryRunFacet externalQuery) {
            this.externalQuery = externalQuery;
            return this;
        }

        public RunFacetsBuilder gcp_dataproc(GcpDataprocRunFacet gcp_dataproc) {
            this.gcp_dataproc = gcp_dataproc;
            return this;
        }

        public RunFacetsBuilder extractionError(ExtractionErrorRunFacet extractionError) {
            this.extractionError = extractionError;
            return this;
        }

        public RunFacetsBuilder parent(ParentRunFacet parent) {
            this.parent = parent;
            return this;
        }

        public RunFacetsBuilder nominalTime(NominalTimeRunFacet nominalTime) {
            this.nominalTime = nominalTime;
            return this;
        }

        public RunFacetsBuilder tags(TagsRunFacet tags) {
            this.tags = tags;
            return this;
        }

        public RunFacetsBuilder errorMessage(ErrorMessageRunFacet errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public RunFacetsBuilder environmentVariables(EnvironmentVariablesRunFacet environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public RunFacetsBuilder processing_engine(ProcessingEngineRunFacet processing_engine) {
            this.processing_engine = processing_engine;
            return this;
        }

        public RunFacetsBuilder put(String key, RunFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public RunFacets build() {
            RunFacets __result = new RunFacets(this.externalQuery, this.gcp_dataproc, this.extractionError, this.parent, this.nominalTime, this.tags, this.errorMessage, this.environmentVariables, this.processing_engine);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class SchemaDatasetFacetBuilder
    implements Builder<SchemaDatasetFacet> {
        private List<SchemaDatasetFacetFields> fields;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SchemaDatasetFacetBuilder fields(List<SchemaDatasetFacetFields> fields) {
            this.fields = fields;
            return this;
        }

        public SchemaDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SchemaDatasetFacet build() {
            SchemaDatasetFacet __result = new SchemaDatasetFacet(OpenLineage.this.producer, this.fields);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class SourceCodeJobFacetBuilder
    implements Builder<SourceCodeJobFacet> {
        private String language;
        private String sourceCode;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SourceCodeJobFacetBuilder language(String language) {
            this.language = language;
            return this;
        }

        public SourceCodeJobFacetBuilder sourceCode(String sourceCode) {
            this.sourceCode = sourceCode;
            return this;
        }

        public SourceCodeJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SourceCodeJobFacet build() {
            SourceCodeJobFacet __result = new SourceCodeJobFacet(OpenLineage.this.producer, this.language, this.sourceCode);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class IcebergScanReportInputDatasetFacetMetadataBuilder
    implements Builder<IcebergScanReportInputDatasetFacetMetadata> {
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public IcebergScanReportInputDatasetFacetMetadataBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public IcebergScanReportInputDatasetFacetMetadata build() {
            IcebergScanReportInputDatasetFacetMetadata __result = new IcebergScanReportInputDatasetFacetMetadata();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class DataQualityAssertionsDatasetFacetBuilder
    implements Builder<DataQualityAssertionsDatasetFacet> {
        private List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityAssertionsDatasetFacetBuilder assertions(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this.assertions = assertions;
            return this;
        }

        public DataQualityAssertionsDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityAssertionsDatasetFacet build() {
            DataQualityAssertionsDatasetFacet __result = new DataQualityAssertionsDatasetFacet(OpenLineage.this.producer, this.assertions);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacetFields.class)
    @JsonPropertyOrder
    public static final class ColumnLineageDatasetFacetFields {
        @JsonAnySetter
        private final Map<String, ColumnLineageDatasetFacetFieldsAdditional> additionalProperties = new LinkedHashMap<String, ColumnLineageDatasetFacetFieldsAdditional>();

        @JsonCreator
        private ColumnLineageDatasetFacetFields() {
        }

        @JsonAnyGetter
        public Map<String, ColumnLineageDatasetFacetFieldsAdditional> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ColumnLineageDatasetFacetBuilder
    implements Builder<ColumnLineageDatasetFacet> {
        private ColumnLineageDatasetFacetFields fields;
        private List<InputField> dataset;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ColumnLineageDatasetFacetBuilder fields(ColumnLineageDatasetFacetFields fields) {
            this.fields = fields;
            return this;
        }

        public ColumnLineageDatasetFacetBuilder dataset(List<InputField> dataset) {
            this.dataset = dataset;
            return this;
        }

        public ColumnLineageDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacet build() {
            ColumnLineageDatasetFacet __result = new ColumnLineageDatasetFacet(OpenLineage.this.producer, this.fields, this.dataset);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "dataset"})
    public static final class DatasetEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final StaticDataset dataset;

        @JsonCreator
        private DatasetEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="dataset") StaticDataset dataset) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/DatasetEvent");
            this.dataset = dataset;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public StaticDataset getDataset() {
            return this.dataset;
        }
    }

    public final class DatasetEventBuilder
    implements Builder<DatasetEvent> {
        private ZonedDateTime eventTime;
        private StaticDataset dataset;

        public DatasetEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public DatasetEventBuilder dataset(StaticDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public DatasetEvent build() {
            DatasetEvent __result = new DatasetEvent(this.eventTime, OpenLineage.this.producer, this.dataset);
            return __result;
        }
    }

    public final class TagsJobFacetBuilder
    implements Builder<TagsJobFacet> {
        private List<TagsJobFacetFields> tags;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public TagsJobFacetBuilder tags(List<TagsJobFacetFields> tags) {
            this.tags = tags;
            return this;
        }

        public TagsJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public TagsJobFacet build() {
            TagsJobFacet __result = new TagsJobFacet(OpenLineage.this.producer, this.tags);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class ProcessingEngineRunFacetBuilder
    implements Builder<ProcessingEngineRunFacet> {
        private String version;
        private String name;
        private String openlineageAdapterVersion;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ProcessingEngineRunFacetBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ProcessingEngineRunFacetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessingEngineRunFacetBuilder openlineageAdapterVersion(String openlineageAdapterVersion) {
            this.openlineageAdapterVersion = openlineageAdapterVersion;
            return this;
        }

        public ProcessingEngineRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ProcessingEngineRunFacet build() {
            ProcessingEngineRunFacet __result = new ProcessingEngineRunFacet(OpenLineage.this.producer, this.version, this.name, this.openlineageAdapterVersion);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder
    implements Builder<LifecycleStateChangeDatasetFacetPreviousIdentifier> {
        private String name;
        private String namespace;

        public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public LifecycleStateChangeDatasetFacetPreviousIdentifier build() {
            LifecycleStateChangeDatasetFacetPreviousIdentifier __result = new LifecycleStateChangeDatasetFacetPreviousIdentifier(this.name, this.namespace);
            return __result;
        }
    }

    @JsonDeserialize(as=InputFieldTransformations.class)
    @JsonPropertyOrder(value={"type", "subtype", "description", "masking"})
    public static final class InputFieldTransformations {
        private final String type;
        private final String subtype;
        private final String description;
        private final Boolean masking;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private InputFieldTransformations(@JsonProperty(value="type") String type, @JsonProperty(value="subtype") String subtype, @JsonProperty(value="description") String description, @JsonProperty(value="masking") Boolean masking) {
            this.type = type;
            this.subtype = subtype;
            this.description = description;
            this.masking = masking;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getType() {
            return this.type;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getMasking() {
            return this.masking;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class InputFieldTransformationsBuilder
    implements Builder<InputFieldTransformations> {
        private String type;
        private String subtype;
        private String description;
        private Boolean masking;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public InputFieldTransformationsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public InputFieldTransformationsBuilder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public InputFieldTransformationsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InputFieldTransformationsBuilder masking(Boolean masking) {
            this.masking = masking;
            return this;
        }

        public InputFieldTransformationsBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public InputFieldTransformations build() {
            InputFieldTransformations __result = new InputFieldTransformations(this.type, this.subtype, this.description, this.masking);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=EnvironmentVariable.class)
    @JsonPropertyOrder(value={"name", "value"})
    public static final class EnvironmentVariable {
        private final String name;
        private final String value;

        @JsonCreator
        private EnvironmentVariable(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class EnvironmentVariableBuilder
    implements Builder<EnvironmentVariable> {
        private String name;
        private String value;

        public EnvironmentVariableBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EnvironmentVariableBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public EnvironmentVariable build() {
            EnvironmentVariable __result = new EnvironmentVariable(this.name, this.value);
            return __result;
        }
    }

    public static final class IcebergScanReportInputDatasetFacetScanMetricsBuilder
    implements Builder<IcebergScanReportInputDatasetFacetScanMetrics> {
        private Double totalPlanningDuration;
        private Double resultDataFiles;
        private Double resultDeleteFiles;
        private Double totalDataManifests;
        private Double totalDeleteManifests;
        private Double scannedDataManifests;
        private Double skippedDataManifests;
        private Double totalFileSizeInBytes;
        private Double totalDeleteFileSizeInBytes;
        private Double skippedDataFiles;
        private Double skippedDeleteFiles;
        private Double scannedDeleteManifests;
        private Double skippedDeleteManifests;
        private Double indexedDeleteFiles;
        private Double equalityDeleteFiles;
        private Double positionalDeleteFiles;

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder totalPlanningDuration(Double totalPlanningDuration) {
            this.totalPlanningDuration = totalPlanningDuration;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder resultDataFiles(Double resultDataFiles) {
            this.resultDataFiles = resultDataFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder resultDeleteFiles(Double resultDeleteFiles) {
            this.resultDeleteFiles = resultDeleteFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder totalDataManifests(Double totalDataManifests) {
            this.totalDataManifests = totalDataManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder totalDeleteManifests(Double totalDeleteManifests) {
            this.totalDeleteManifests = totalDeleteManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder scannedDataManifests(Double scannedDataManifests) {
            this.scannedDataManifests = scannedDataManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder skippedDataManifests(Double skippedDataManifests) {
            this.skippedDataManifests = skippedDataManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder totalFileSizeInBytes(Double totalFileSizeInBytes) {
            this.totalFileSizeInBytes = totalFileSizeInBytes;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder totalDeleteFileSizeInBytes(Double totalDeleteFileSizeInBytes) {
            this.totalDeleteFileSizeInBytes = totalDeleteFileSizeInBytes;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder skippedDataFiles(Double skippedDataFiles) {
            this.skippedDataFiles = skippedDataFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder skippedDeleteFiles(Double skippedDeleteFiles) {
            this.skippedDeleteFiles = skippedDeleteFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder scannedDeleteManifests(Double scannedDeleteManifests) {
            this.scannedDeleteManifests = scannedDeleteManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder skippedDeleteManifests(Double skippedDeleteManifests) {
            this.skippedDeleteManifests = skippedDeleteManifests;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder indexedDeleteFiles(Double indexedDeleteFiles) {
            this.indexedDeleteFiles = indexedDeleteFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder equalityDeleteFiles(Double equalityDeleteFiles) {
            this.equalityDeleteFiles = equalityDeleteFiles;
            return this;
        }

        public IcebergScanReportInputDatasetFacetScanMetricsBuilder positionalDeleteFiles(Double positionalDeleteFiles) {
            this.positionalDeleteFiles = positionalDeleteFiles;
            return this;
        }

        @Override
        public IcebergScanReportInputDatasetFacetScanMetrics build() {
            IcebergScanReportInputDatasetFacetScanMetrics __result = new IcebergScanReportInputDatasetFacetScanMetrics(this.totalPlanningDuration, this.resultDataFiles, this.resultDeleteFiles, this.totalDataManifests, this.totalDeleteManifests, this.scannedDataManifests, this.skippedDataManifests, this.totalFileSizeInBytes, this.totalDeleteFileSizeInBytes, this.skippedDataFiles, this.skippedDeleteFiles, this.scannedDeleteManifests, this.skippedDeleteManifests, this.indexedDeleteFiles, this.equalityDeleteFiles, this.positionalDeleteFiles);
            return __result;
        }
    }

    @JsonDeserialize(as=TagsRunFacetFields.class)
    @JsonPropertyOrder(value={"key", "value", "source"})
    public static final class TagsRunFacetFields {
        private final String key;
        private final String value;
        private final String source;

        @JsonCreator
        private TagsRunFacetFields(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="source") String source) {
            this.key = key;
            this.value = value;
            this.source = source;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getSource() {
            return this.source;
        }
    }

    public static final class TagsRunFacetFieldsBuilder
    implements Builder<TagsRunFacetFields> {
        private String key;
        private String value;
        private String source;

        public TagsRunFacetFieldsBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagsRunFacetFieldsBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TagsRunFacetFieldsBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public TagsRunFacetFields build() {
            TagsRunFacetFields __result = new TagsRunFacetFields(this.key, this.value, this.source);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacetAssertions.class)
    @JsonPropertyOrder(value={"assertion", "success", "column"})
    public static final class DataQualityAssertionsDatasetFacetAssertions {
        private final String assertion;
        private final Boolean success;
        private final String column;

        @JsonCreator
        private DataQualityAssertionsDatasetFacetAssertions(@JsonProperty(value="assertion") String assertion, @JsonProperty(value="success") Boolean success, @JsonProperty(value="column") String column) {
            this.assertion = assertion;
            this.success = success;
            this.column = column;
        }

        public String getAssertion() {
            return this.assertion;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getColumn() {
            return this.column;
        }
    }

    public static final class DataQualityAssertionsDatasetFacetAssertionsBuilder
    implements Builder<DataQualityAssertionsDatasetFacetAssertions> {
        private String assertion;
        private Boolean success;
        private String column;

        public DataQualityAssertionsDatasetFacetAssertionsBuilder assertion(String assertion) {
            this.assertion = assertion;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder success(Boolean success) {
            this.success = success;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder column(String column) {
            this.column = column;
            return this;
        }

        @Override
        public DataQualityAssertionsDatasetFacetAssertions build() {
            DataQualityAssertionsDatasetFacetAssertions __result = new DataQualityAssertionsDatasetFacetAssertions(this.assertion, this.success, this.column);
            return __result;
        }
    }

    public static final class ParentRunFacetRunBuilder
    implements Builder<ParentRunFacetRun> {
        private UUID runId;

        public ParentRunFacetRunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public ParentRunFacetRun build() {
            ParentRunFacetRun __result = new ParentRunFacetRun(this.runId);
            return __result;
        }
    }

    public final class GcpDataprocRunFacetBuilder
    implements Builder<GcpDataprocRunFacet> {
        private String appId;
        private String appName;
        private String batchId;
        private String batchUuid;
        private String clusterName;
        private String clusterUuid;
        private String jobId;
        private String jobUuid;
        private String projectId;
        private String queryNodeName;
        private String jobType;
        private String sessionId;
        private String sessionUuid;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public GcpDataprocRunFacetBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public GcpDataprocRunFacetBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public GcpDataprocRunFacetBuilder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public GcpDataprocRunFacetBuilder batchUuid(String batchUuid) {
            this.batchUuid = batchUuid;
            return this;
        }

        public GcpDataprocRunFacetBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public GcpDataprocRunFacetBuilder clusterUuid(String clusterUuid) {
            this.clusterUuid = clusterUuid;
            return this;
        }

        public GcpDataprocRunFacetBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public GcpDataprocRunFacetBuilder jobUuid(String jobUuid) {
            this.jobUuid = jobUuid;
            return this;
        }

        public GcpDataprocRunFacetBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public GcpDataprocRunFacetBuilder queryNodeName(String queryNodeName) {
            this.queryNodeName = queryNodeName;
            return this;
        }

        public GcpDataprocRunFacetBuilder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        public GcpDataprocRunFacetBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public GcpDataprocRunFacetBuilder sessionUuid(String sessionUuid) {
            this.sessionUuid = sessionUuid;
            return this;
        }

        public GcpDataprocRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public GcpDataprocRunFacet build() {
            GcpDataprocRunFacet __result = new GcpDataprocRunFacet(OpenLineage.this.producer, this.appId, this.appName, this.batchId, this.batchUuid, this.clusterName, this.clusterUuid, this.jobId, this.jobUuid, this.projectId, this.queryNodeName, this.jobType, this.sessionId, this.sessionUuid);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public static final class ColumnLineageDatasetFacetFieldsBuilder
    implements Builder<ColumnLineageDatasetFacetFields> {
        private final Map<String, ColumnLineageDatasetFacetFieldsAdditional> additionalProperties = new LinkedHashMap<String, ColumnLineageDatasetFacetFieldsAdditional>();

        public ColumnLineageDatasetFacetFieldsBuilder put(String key, ColumnLineageDatasetFacetFieldsAdditional value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacetFields build() {
            ColumnLineageDatasetFacetFields __result = new ColumnLineageDatasetFacetFields();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class SymlinksDatasetFacetBuilder
    implements Builder<SymlinksDatasetFacet> {
        private List<SymlinksDatasetFacetIdentifiers> identifiers;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SymlinksDatasetFacetBuilder identifiers(List<SymlinksDatasetFacetIdentifiers> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        public SymlinksDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SymlinksDatasetFacet build() {
            SymlinksDatasetFacet __result = new SymlinksDatasetFacet(OpenLineage.this.producer, this.identifiers);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    public final class StorageDatasetFacetBuilder
    implements Builder<StorageDatasetFacet> {
        private String storageLayer;
        private String fileFormat;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public StorageDatasetFacetBuilder storageLayer(String storageLayer) {
            this.storageLayer = storageLayer;
            return this;
        }

        public StorageDatasetFacetBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public StorageDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public StorageDatasetFacet build() {
            StorageDatasetFacet __result = new StorageDatasetFacet(OpenLineage.this.producer, this.storageLayer, this.fileFormat);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "inputFacets"})
    public static final class InputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final InputDatasetInputFacets inputFacets;

        @JsonCreator
        private InputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="inputFacets") InputDatasetInputFacets inputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.inputFacets = inputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public InputDatasetInputFacets getInputFacets() {
            return this.inputFacets;
        }
    }

    public static final class InputDatasetBuilder
    implements Builder<InputDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private InputDatasetInputFacets inputFacets;

        public InputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public InputDatasetBuilder inputFacets(InputDatasetInputFacets inputFacets) {
            this.inputFacets = inputFacets;
            return this;
        }

        @Override
        public InputDataset build() {
            InputDataset __result = new InputDataset(this.namespace, this.name, this.facets, this.inputFacets);
            return __result;
        }
    }

    public final class DatasourceDatasetFacetBuilder
    implements Builder<DatasourceDatasetFacet> {
        private String name;
        private URI uri;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasourceDatasetFacetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatasourceDatasetFacetBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public DatasourceDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasourceDatasetFacet build() {
            DatasourceDatasetFacet __result = new DatasourceDatasetFacet(OpenLineage.this.producer, this.name, this.uri);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DefaultJobFacet.class)
    public static interface JobFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Boolean get_deleted();

        @JsonIgnore
        default public Boolean isDeleted() {
            return this.get_deleted();
        }

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonDeserialize(as=DefaultDatasetFacet.class)
    public static interface DatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Boolean get_deleted();

        @JsonIgnore
        default public Boolean isDeleted() {
            return this.get_deleted();
        }

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonDeserialize(as=DefaultRunFacet.class)
    public static interface RunFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonDeserialize(as=DefaultOutputDatasetFacet.class)
    public static interface OutputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static interface Dataset {
        public String getNamespace();

        public String getName();

        public DatasetFacets getFacets();
    }

    @JsonDeserialize(as=DefaultInputDatasetFacet.class)
    public static interface InputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static interface BaseFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static interface BaseEvent {
        public ZonedDateTime getEventTime();

        public URI getProducer();

        public URI getSchemaURL();
    }

    public static interface Builder<T> {
        public T build();
    }
}

