/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.annotation.Beta;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBagIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ParallelUnsortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Bags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.AbstractMutableBagIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.HashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.bag.NonParallelUnsortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public abstract class AbstractMutableBag<T>
extends AbstractMutableBagIterable<T>
implements MutableBag<T> {
    @Override
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll(this);
    }

    @Override
    public UnmodifiableBag<T> asUnmodifiable() {
        return UnmodifiableBag.of(this);
    }

    @Override
    public SynchronizedBag<T> asSynchronized() {
        return new SynchronizedBag(this);
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag();
        this.forEachWithOccurrences((each, occurrences) -> {
            if (clazz.isInstance(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        return (MutableBag)this.select(predicate, this.newEmpty());
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)this.selectWith(predicate, parameter, this.newEmpty());
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return (MutableBag)this.reject(predicate, this.newEmpty());
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)this.rejectWith(predicate, parameter, this.newEmpty());
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences((each, index) -> {
            MutableBagIterable bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result;
    }

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences((each, index) -> {
            MutableBagIterable bucket = predicate.accept((Object)each, (Object)parameter) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result;
    }

    @Override
    public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return this.collectWithOccurrences(function, Bags.mutable.empty());
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, HashBag.newBag());
    }

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, HashBag.newBag());
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, HashBag.newBag());
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, HashBag.newBag());
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            HashBag target = HashBag.newBag(Math.min(this.size(), thatSize));
            return this.zip(that, target);
        }
        return this.zip(that, HashBag.newBag());
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Sets.mutable.empty());
    }

    @Beta
    public ParallelUnsortedBag<T> asParallel(ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        return new NonParallelUnsortedBag(this);
    }
}

