/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.function;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import java.util.Collection;
import java.util.Map;

public final class MinSizeFunction {
    public static final Function2<Integer, String, Integer> STRING = new MinSizeStringFunction();
    public static final Function2<Integer, Collection<?>, Integer> COLLECTION = new MinSizeCollectionFunction();
    public static final Function2<Integer, Map<?, ?>, Integer> MAP = new MinSizeMapFunction();

    private MinSizeFunction() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    private static class MinSizeMapFunction
    implements Function2<Integer, Map<?, ?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeMapFunction() {
        }

        @Override
        public Integer value(Integer previousMin, Map<?, ?> map) {
            return Math.min(previousMin, map.size());
        }
    }

    private static class MinSizeCollectionFunction
    implements Function2<Integer, Collection<?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeCollectionFunction() {
        }

        @Override
        public Integer value(Integer previousMin, Collection<?> collection) {
            return Math.min(previousMin, collection.size());
        }
    }

    private static class MinSizeStringFunction
    implements Function2<Integer, String, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeStringFunction() {
        }

        @Override
        public Integer value(Integer previousMin, String s2) {
            return Math.min(previousMin, s2.length());
        }
    }
}

