/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bimap.MutableBiMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;

public final class BiMapCollectProcedure<T, K, V>
implements Procedure<T> {
    private static final long serialVersionUID = 1L;
    private final MutableBiMap<K, V> biMap;
    private final Function<? super T, ? extends K> keyFunction;
    private final Function<? super T, ? extends V> valueFunction;

    public BiMapCollectProcedure(MutableBiMap<K, V> newMap, Function<? super T, ? extends K> newKeyFunction, Function<? super T, ? extends V> newValueFunction) {
        this.biMap = newMap;
        this.keyFunction = newKeyFunction;
        this.valueFunction = newValueFunction;
    }

    @Override
    public void value(T object) {
        K key = this.keyFunction.valueOf(object);
        V value = this.valueFunction.valueOf(object);
        if (this.biMap.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " already exists in map!");
        }
        if (this.biMap.inverse().containsKey(value)) {
            throw new IllegalArgumentException("Value " + value + " already exists in map!");
        }
        this.biMap.put(key, value);
    }
}

