/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function3;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Bags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ObjectDoubleMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Twin;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.AbstractRichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Procedures2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.IterableIterate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.BinaryOperator;

public abstract class AbstractMutableCollection<T>
extends AbstractRichIterable<T>
implements MutableCollection<T> {
    @Override
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.selectAndRejectWith(this, predicate, parameter);
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return IterableIterate.removeIf(this, predicate);
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.removeIfWith(this, predicate, parameter);
    }

    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        return IterableIterate.injectIntoWith(injectValue, this, function, parameter);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.injectInto(null, (? super IV result, ? super T each) -> result == null ? each : accumulator.apply(result, each)));
    }

    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        int oldSize = this.size();
        if (iterable instanceof List && iterable instanceof RandomAccess) {
            List list = (List)iterable;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.add((T)list.get(i));
            }
        } else {
            Iterate.forEachWith(iterable, Procedures2.addToCollection(), this);
        }
        return oldSize != this.size();
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        return this.removeAll(CollectionAdapter.wrapSet(iterable));
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        return this.retainAll(CollectionAdapter.wrapSet(iterable));
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = this.iterator();
        MutableList<RichIterable<T>> result = Lists.mutable.empty();
        while (iterator.hasNext()) {
            MutableCollection batch = this.newEmpty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    @Override
    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    @Override
    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(o, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> source) {
        return this.addAllIterable(source);
    }

    @Override
    public boolean removeAll(Collection<?> source) {
        return this.removeAllIterable(source);
    }

    @Override
    public boolean retainAll(Collection<?> source) {
        int oldSize = this.size();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (source.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.size() != oldSize;
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return Iterate.groupByUniqueKey(this, function);
    }

    @Override
    public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.countBy(function, Bags.mutable.empty());
    }

    @Override
    public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.countByWith(function, parameter, Bags.mutable.empty());
    }

    @Override
    public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.countByEach(function, Bags.mutable.empty());
    }
}

