/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.iterator.DistinctIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Iterator;
import java.util.Optional;

public class DistinctIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public DistinctIterable(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    @Override
    public LazyIterable<T> distinct() {
        return this;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        MutableSet seenSoFar = Sets.mutable.empty();
        Iterate.forEach(this.adapted, each -> {
            if (seenSoFar.add(each)) {
                procedure.value(each);
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.each(new AdaptObjectIntProcedureToProcedure<T>(objectIntProcedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.anySatisfy(this.adapted, each -> seenSoFar.add(each) && predicate.accept(each));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.allSatisfy(this.adapted, each -> !seenSoFar.add(each) || predicate.accept(each));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.allSatisfy(this.adapted, each -> !seenSoFar.add(each) || !predicate.accept(each));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return (T)Iterate.detect(this.adapted, each -> seenSoFar.add(each) && predicate.accept(each));
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        MutableSet seenSoFar = Sets.mutable.empty();
        return Iterate.detectOptional(this.adapted, each -> seenSoFar.add(each) && predicate.accept(each));
    }

    @Override
    public Iterator<T> iterator() {
        return new DistinctIterator<T>(this.adapted);
    }
}

