/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.iterator.TakeIterator;
import java.util.Iterator;

public class TakeIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final int count;

    public TakeIterable(Iterable<T> newAdapted, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        this.adapted = newAdapted;
        this.count = count;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), i);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), parameter);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.count];
        this.forEachWithIndex((each, index) -> {
            result[index] = each;
        });
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new TakeIterator<T>(this.adapted, this.count);
    }
}

