/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.iterator.TakeWhileIterator;
import java.util.Iterator;

public class TakeWhileIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Predicate<? super T> predicate;

    public TakeWhileIterable(Iterable<T> newAdapted, Predicate<? super T> predicate) {
        if (predicate == null) {
            throw new IllegalStateException("Predicate cannot be null");
        }
        this.adapted = newAdapted;
        this.predicate = predicate;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        for (T each : this.adapted) {
            if (!this.predicate.accept(each)) {
                return;
            }
            procedure.value(each);
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        int i = 0;
        for (T each : this.adapted) {
            if (!this.predicate.accept(each)) {
                return;
            }
            procedure.value(each, i);
            ++i;
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        for (T each : this.adapted) {
            if (!this.predicate.accept(each)) {
                return;
            }
            procedure.value(each, parameter);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new TakeWhileIterator<T>(this.adapted, this.predicate);
    }
}

