/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.annotation.Beta;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.SortedBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.sorted.MutableSortedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.MutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.Counter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.HashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Comparators;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Functions2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Predicates;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Procedures;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.DoubleSumResultHolder;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.Batch;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.RootBatch;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.CompositeFastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.FastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.ConcurrentHashMapUnsafe;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.SetAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Beta
public abstract class AbstractParallelIterable<T, B extends Batch<T>>
implements ParallelIterable<T> {
    protected static <T> void forEach(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, Procedure<? super T> procedure) {
        RichIterable futures = parallelIterable.split().collect((T chunk) -> parallelIterable.getExecutorService().submit(() -> chunk.forEach(procedure)));
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static <T> boolean anySatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = parallelIterable.split().collect(batch -> completionService.submit(() -> batch.anySatisfy(predicate)), Sets.mutable.empty());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return true;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected static <T> boolean allSatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = parallelIterable.split().collect(batch -> completionService.submit(() -> batch.allSatisfy(predicate)), Sets.mutable.empty());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (!((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return false;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected static <T> T detect(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        LazyIterable<RootBatch<T>> chunks = parallelIterable.split();
        RichIterable futures = chunks.collect((T chunk) -> parallelIterable.getExecutorService().submit(() -> chunk.detect(predicate)));
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                Object eachResult = future.get();
                if (eachResult == null) continue;
                for (Future eachFutureToCancel : futuresList) {
                    eachFutureToCancel.cancel(true);
                }
                return (T)eachResult;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public abstract ExecutorService getExecutorService();

    public abstract int getBatchSize();

    public abstract LazyIterable<B> split();

    protected abstract boolean isOrdered();

    protected <S, V> void collectCombine(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        if (this.isOrdered()) {
            this.collectCombineOrdered(function, combineProcedure, state);
        } else {
            this.collectCombineUnordered(function, combineProcedure, state);
        }
    }

    private <S, V> void collectCombineOrdered(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        RichIterable futures = chunks.collect((T chunk) -> this.getExecutorService().submit(() -> function.valueOf((Batch)chunk)));
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                combineProcedure.value(state, future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <S, V> void collectCombineUnordered(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        MutableList<Callable> callables = chunks.collect((T chunk) -> () -> function.valueOf((Batch)chunk)).toList();
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.each(completionService::submit);
        for (int numTasks = callables.size(); numTasks > 0; --numTasks) {
            try {
                Future future = completionService.take();
                combineProcedure.value(state, future.get());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private T collectReduce(Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        return this.isOrdered() ? this.collectReduceOrdered(map, function2) : this.collectReduceUnordered(map, function2);
    }

    private T collectReduceOrdered(Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        RichIterable futures = chunks.collect((T chunk) -> this.getExecutorService().submit(() -> map.valueOf((Batch)chunk)));
        MutableList futuresList = futures.toList();
        try {
            Object result = ((Future)futuresList.getFirst()).get();
            for (int i = 1; i < futuresList.size(); ++i) {
                Object next = ((Future)futuresList.get(i)).get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private T collectReduceUnordered(Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        MutableList<Callable> callables = chunks.collect((T chunk) -> () -> map.valueOf((Batch)chunk)).toList();
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.each(completionService::submit);
        try {
            Object result = completionService.take().get();
            for (int numTasks = callables.size() - 1; numTasks > 0; --numTasks) {
                Object next = completionService.take().get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        try {
            appendable.append(start);
            Function<Batch, String> map = batch -> batch.makeString(separator);
            CheckedProcedure2<Appendable, String> reduce = new CheckedProcedure2<Appendable, String>(){
                private boolean first = true;

                @Override
                public void safeValue(Appendable accumulator, String each) throws IOException {
                    if ("".equals(each)) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                    } else {
                        appendable.append(separator);
                    }
                    appendable.append(each);
                }
            };
            this.collectCombine(map, reduce, appendable);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.forEach(Procedures.bind(procedure, parameter));
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.allSatisfy(Predicates.not(predicate));
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.detect(Predicates.bind(predicate, parameter));
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        return result == null ? function.value() : result;
    }

    @Override
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        return this.detectIfNone(Predicates.bind(predicate, parameter), function);
    }

    @Override
    public <E> E[] toArray(E[] array) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    @Override
    public MutableList<T> toList() {
        Function<Batch, FastList> map = batch -> {
            FastList list = FastList.newList();
            batch.forEach(CollectionAddProcedure.on(list));
            return list;
        };
        CompositeFastList state = new CompositeFastList();
        this.collectCombine(map, List::addAll, state);
        return state;
    }

    @Override
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return this.toList().toSortedList(comparator);
    }

    @Override
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        return this.toSortedList(Comparators.byFunction(function));
    }

    @Override
    public MutableSet<T> toSet() {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        Set result = Collections.newSetFromMap(map);
        this.forEach(CollectionAddProcedure.on(result));
        return SetAdapter.adapt(map.keySet());
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        MutableCollection result = TreeSortedSet.newSet().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        return this.toSortedSet(Comparators.byFunction(function));
    }

    @Override
    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag() {
        MutableCollection result = TreeBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        MutableCollection<T> result = SortedBags.mutable.empty(comparator);
        result = result.asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        return this.toSortedBag(Comparators.byFunction(function));
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        MutableCollection<T> result = TreeSortedSet.newSet(comparator);
        result = result.asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable map = UnifiedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable sortedMap = TreeSortedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable sortedMap = TreeSortedMap.newMap(comparator).asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        Function<Batch, Integer> map = batch -> batch.count(predicate);
        Counter state = new Counter();
        this.collectCombineUnordered(map, Counter::add, state);
        return state.getCount();
    }

    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.count(Predicates.bind(predicate, parameter));
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        Function<Batch, Object> map = batch -> batch.min(comparator);
        return this.collectReduce(map, Functions2.min(comparator));
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        Function<Batch, Object> map = batch -> batch.max(comparator);
        return this.collectReduce(map, Functions2.max(comparator));
    }

    @Override
    public T min() {
        return this.min(Comparators.naturalOrder());
    }

    @Override
    public T max() {
        return this.max(Comparators.naturalOrder());
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        Function<Batch, Object> map = batch -> batch.minBy(function);
        return this.collectReduce(map, Functions2.minBy(function));
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        Function<Batch, Object> map = batch -> batch.maxBy(function);
        return this.collectReduce(map, Functions2.maxBy(function));
    }

    @Override
    public long sumOfInt(IntFunction<? super T> function) {
        return this.sumOfLongOrdered(batch -> batch.sumOfInt(function));
    }

    @Override
    public double sumOfFloat(FloatFunction<? super T> function) {
        return this.sumOfDoubleOrdered(batch -> batch.sumOfFloat(function));
    }

    @Override
    public long sumOfLong(LongFunction<? super T> function) {
        return this.sumOfLongOrdered(batch -> batch.sumOfLong(function));
    }

    @Override
    public double sumOfDouble(DoubleFunction<? super T> function) {
        return this.sumOfDoubleOrdered(batch -> batch.sumOfDouble(function));
    }

    private long sumOfLongOrdered(LongFunction<Batch<T>> map) {
        LazyIterable<B> chunks = this.split();
        RichIterable futures = chunks.collect((T chunk) -> this.getExecutorService().submit(() -> map.longValueOf((Batch)chunk)));
        MutableList futuresList = futures.toList();
        try {
            long result = 0L;
            for (int i = 0; i < futuresList.size(); ++i) {
                result += ((Long)((Future)futuresList.get(i)).get()).longValue();
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private double sumOfDoubleOrdered(Function<Batch<T>, DoubleSumResultHolder> map) {
        LazyIterable<B> chunks = this.split();
        RichIterable futures = chunks.collect((T chunk) -> this.getExecutorService().submit(() -> (DoubleSumResultHolder)map.valueOf((Batch)chunk)));
        MutableList futuresList = futures.toList();
        try {
            double sum = 0.0;
            double compensation = 0.0;
            for (int i = 0; i < futuresList.size(); ++i) {
                double adjustedValue = ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getResult() - (compensation += ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getCompensation());
                double nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            return sum;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        ConcurrentHashMap result = ConcurrentHashMap.newMap(this.getBatchSize());
        this.forEach(value -> {
            Object key = function.valueOf(value);
            if (result.put(key, value) != null) {
                throw new IllegalStateException("Key " + key + " already exists in map!");
            }
        });
        return result;
    }
}

