/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.BooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.BooleanIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.IterableIterate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChunkBooleanIterable
extends AbstractLazyIterable<BooleanIterable> {
    private final BooleanIterable adapted;
    private final int size;

    public ChunkBooleanIterable(BooleanIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<BooleanIterable> iterator() {
        return new ChunkBooleanIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super BooleanIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkBooleanIterator
    implements Iterator<BooleanIterable> {
        private final BooleanIterator iterator;
        private final int size;
        private final Function0<MutableBooleanCollection> speciesNewStrategy;

        public ChunkBooleanIterator(BooleanIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.booleanIterator();
            this.speciesNewStrategy = iterable instanceof MutableBooleanCollection ? ((MutableBooleanCollection)iterable)::newEmpty : BooleanLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public BooleanIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableBooleanCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

