/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.IterableIterate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChunkShortIterable
extends AbstractLazyIterable<ShortIterable> {
    private final ShortIterable adapted;
    private final int size;

    public ChunkShortIterable(ShortIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<ShortIterable> iterator() {
        return new ChunkShortIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super ShortIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkShortIterator
    implements Iterator<ShortIterable> {
        private final ShortIterator iterator;
        private final int size;
        private final Function0<MutableShortCollection> speciesNewStrategy;

        public ChunkShortIterator(ShortIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.shortIterator();
            this.speciesNewStrategy = iterable instanceof MutableShortCollection ? ((MutableShortCollection)iterable)::newEmpty : ShortLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ShortIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableShortCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

