/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.FloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.FloatIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableFloatList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableFloatSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import java.util.Arrays;
import java.util.Iterator;

public class CollectFloatIterable<T>
extends AbstractLazyFloatIterable {
    private final LazyIterable<T> iterable;
    private final FloatFunction<? super T> function;
    private final FloatFunctionToProcedure<T> floatFunctionToProcedure;

    public CollectFloatIterable(LazyIterable<T> adapted, FloatFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.floatFunctionToProcedure = new FloatFunctionToProcedure(function);
    }

    @Override
    public FloatIterator floatIterator() {
        return new FloatIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectFloatIterable.this.iterable.iterator();
            }

            @Override
            public float next() {
                return CollectFloatIterable.this.function.floatValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.iterable.forEachWith(this.floatFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.iterable.count((? super T each) -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.iterable.anySatisfy((? super T each) -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        this.iterable.forEachWithIndex((each, index) -> {
            array[index] = this.function.floatValueOf(each);
        });
        return array;
    }

    @Override
    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableFloatList toList() {
        return FloatLists.mutable.withAll(this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatSets.mutable.withAll(this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class FloatFunctionToProcedure<T>
    implements Procedure2<T, FloatProcedure> {
        private static final long serialVersionUID = 1L;
        private final FloatFunction<? super T> function;

        private FloatFunctionToProcedure(FloatFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, FloatProcedure procedure) {
            procedure.value(this.function.floatValueOf(each));
        }
    }
}

