/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.CharIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.list.primitive.ImmutableCharListFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableCharList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.CharLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharEmptyList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharSingletonList;

public class ImmutableCharListFactoryImpl
implements ImmutableCharListFactory {
    public static final ImmutableCharListFactory INSTANCE = new ImmutableCharListFactoryImpl();

    @Override
    public ImmutableCharList empty() {
        return ImmutableCharEmptyList.INSTANCE;
    }

    @Override
    public ImmutableCharList of() {
        return this.empty();
    }

    @Override
    public ImmutableCharList with() {
        return this.empty();
    }

    @Override
    public ImmutableCharList of(char one) {
        return this.with(one);
    }

    @Override
    public ImmutableCharList with(char one) {
        return new ImmutableCharSingletonList(one);
    }

    @Override
    public ImmutableCharList of(char ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayList.newListWith(items);
    }

    @Override
    public ImmutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableCharList withAll(CharIterable items) {
        if (items instanceof ImmutableCharList) {
            return (ImmutableCharList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableCharArrayList.newList(items);
    }

    @Override
    public ImmutableCharList ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableCharList withAll(Iterable<Character> iterable) {
        return CharLists.mutable.withAll(iterable).toImmutable();
    }
}

