/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.list.primitive.MutableIntListFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableIntList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.IntStream;

public class MutableIntListFactoryImpl
implements MutableIntListFactory {
    public static final MutableIntListFactory INSTANCE = new MutableIntListFactoryImpl();

    @Override
    public MutableIntList empty() {
        return new IntArrayList();
    }

    @Override
    public MutableIntList of() {
        return this.empty();
    }

    @Override
    public MutableIntList with() {
        return this.empty();
    }

    @Override
    public MutableIntList withInitialCapacity(int capacity) {
        return new IntArrayList(capacity);
    }

    @Override
    public MutableIntList of(int ... items) {
        return this.with(items);
    }

    @Override
    public MutableIntList with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return IntArrayList.newListWith(items);
    }

    @Override
    public MutableIntList ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntList withAll(IntIterable items) {
        return IntArrayList.newList(items);
    }

    @Override
    public MutableIntList ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableIntList withAll(Iterable<Integer> iterable) {
        return Iterate.collectInt(iterable, Integer::intValue, IntLists.mutable.empty());
    }

    @Override
    public MutableIntList ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntList withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

