/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.FloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyFloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntFloatPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntFloatProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.FloatIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableFloatList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableFloatIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableIntFloatMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.IntFloatMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableFloatIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableIntFloatMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableFloatSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.IntFloatPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntFloatProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.FloatBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.FloatIntMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.IntFloatHashMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

final class ImmutableIntFloatHashMap
implements ImmutableIntFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntFloatMap delegate;

    ImmutableIntFloatHashMap(IntFloatMap delegate) {
        this.delegate = new IntFloatHashMap(delegate);
    }

    @Override
    public float get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public float getIfAbsent(int key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public float getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableFloatIntMap flipUniqueValues() {
        MutableFloatIntMap result = FloatIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableIntFloatMap select(IntFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntFloatMap reject(IntFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            FloatIterator iterator = this.delegate.floatIterator();
            while (iterator.hasNext()) {
                MutableFloatBag batch = FloatBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableIntFloatMap toImmutable() {
        return this;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableFloatBag select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((FloatToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public float max() {
        return this.delegate.max();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public float min() {
        return this.delegate.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public float[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public float[] toArray(float[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntFloatMap newWithKeyValue(int key, float value) {
        IntFloatHashMap map = new IntFloatHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntFloatMap newWithoutKey(int key) {
        IntFloatHashMap map = new IntFloatHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntFloatMap newWithoutAllKeys(IntIterable keys) {
        IntFloatHashMap map = new IntFloatHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntFloatMapSerializationProxy(this);
    }

    protected static class ImmutableIntFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntFloatMap map;

        public ImmutableIntFloatMapSerializationProxy() {
        }

        protected ImmutableIntFloatMapSerializationProxy(IntFloatMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntFloatProcedure(){

                    @Override
                    public void safeValue(int key, float value) throws IOException {
                        out.writeInt(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntFloatHashMap deserializedMap = new IntFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

