/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntIntToIntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntIntMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableIntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableIntIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.IntIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.IntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.IntIntPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.SpreadFunctions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.ImmutableIntIntMapKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableIntIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntIntHashMap
extends AbstractMutableIntValuesMap
implements MutableIntIntMap,
Externalizable,
MutableIntKeysMap {
    private static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableIntValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public IntIntHashMap() {
        this.allocateTable(16);
    }

    public IntIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public IntIntHashMap(IntIntMap map) {
        if (map instanceof IntIntHashMap && ((IntIntHashMap)map).occupiedWithSentinels == 0) {
            IntIntHashMap hashMap = (IntIntHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static IntIntHashMap newWithKeysValues(int key1, int value1) {
        return new IntIntHashMap(1).withKeyValue(key1, value1);
    }

    public static IntIntHashMap newWithKeysValues(int key1, int value1, int key2, int value2) {
        return new IntIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntIntHashMap newWithKeysValues(int key1, int value1, int key2, int value2, int key3, int value3) {
        return new IntIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntIntHashMap newWithKeysValues(int key1, int value1, int key2, int value2, int key3, int value3, int key4, int value4) {
        return new IntIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected int getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected int getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntIntMap)) {
            return false;
        }
        IntIntMap other = (IntIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            int key = this.keysValues[i];
            if (!IntIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.keysValues[i + 1] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += this.keysValues[i] ^ this.keysValues[i + 1];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            int key = this.keysValues[i];
            if (!IntIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, 0);
    }

    @Override
    public void put(int key, int value) {
        if (IntIntHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        int keyAtIndex = this.keysValues[index];
        if (keyAtIndex == key) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(IntIntMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(IntIntToIntFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            this.keysValues[i + 1] = function.valueOf(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public void removeKey(int key) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(int key) {
        this.removeKey(key);
    }

    @Override
    public int removeKeyIfAbsent(int key, int value) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public int getIfAbsentPut(int key, int value) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getAndPut(int key, int putValue, int defaultValue) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                int existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                int existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int existingValue = this.keysValues[index + 1];
            this.keysValues[index + 1] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public int getIfAbsentPut(int key, IntFunction0 function) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> int getIfAbsentPutWith(int key, IntFunction<? super P> function, P parameter) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.intValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.intValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getIfAbsentPutWithKey(int key, IntToIntFunction function) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        int value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int addToValue(int key, int toBeAdded) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int n = index + 1;
            this.keysValues[n] = this.keysValues[n] + toBeAdded;
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(int key, int value, int index) {
        if (this.keysValues[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = 1;
        this.keysValues[index + 1] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        int[] copy = new int[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public int updateValue(int key, int initialValueIfAbsent, IntToIntFunction function) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public IntIntHashMap withKeyValue(int key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public IntIntHashMap withKeysValues(int key1, int value1, int key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntIntHashMap withKeysValues(int key1, int value1, int key2, int value2, int key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntIntHashMap withKeysValues(int key1, int value1, int key2, int value2, int key3, int value3, int key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public IntIntHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public IntIntHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableIntIntMap asUnmodifiable() {
        return new UnmodifiableIntIntMap(this);
    }

    @Override
    public MutableIntIntMap asSynchronized() {
        return new SynchronizedIntIntMap(this);
    }

    @Override
    public ImmutableIntIntMap toImmutable() {
        return IntIntMaps.immutable.ofAll(this);
    }

    @Override
    public int get(int key) {
        return this.getIfAbsent(key, 0);
    }

    @Override
    public int getIfAbsent(int key, int ifAbsent) {
        if (IntIntHashMap.isEmptyKey(key) || IntIntHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private int getForSentinel(int key, int ifAbsent) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private int slowGetIfAbsent(int key, int ifAbsent) {
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    private int fastGetIfAbsent(int key, int ifAbsent) {
        int index = this.mask(key) << 1;
        for (int i = 0; i < 8; i += 2) {
            int keyAtIndex = this.keysValues[index];
            if (keyAtIndex == key) {
                return this.keysValues[index + 1];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 2 & this.keysValues.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private int slowGetIfAbsentTwo(int key, int ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    @Override
    public int getOrThrow(int key) {
        if (IntIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntIntHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        if (IntIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keysValues[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    @Override
    public void forEachKeyValue(IntIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public LazyIntIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<IntIntPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableIntIntMap flipUniqueValues() {
        MutableIntIntMap result = IntIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public IntIntHashMap select(IntIntPredicate predicate) {
        IntIntHashMap result = new IntIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public IntIntHashMap reject(IntIntPredicate predicate) {
        IntIntHashMap result = new IntIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!IntIntHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeInt(this.keysValues[i]);
            out.writeInt(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        int[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!IntIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(int element) {
        int index = this.mask(element) << 1;
        int keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 2; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            int keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keysValues = new int[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntIntHashMap.isEmptyKey(key) && !IntIntHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntIntHashMap.isEmptyKey(this.keysValues[index * 2]) && !IntIntHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    @Override
    public MutableIntSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntIntHashMap x0, int[] x1) {
        x0.keysValues = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<IntIntPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super IntIntPair> procedure) {
            if (IntIntHashMap.this.sentinelValues != null) {
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.zeroValue));
                }
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntIntHashMap.this.keysValues.length; i += 2) {
                if (!IntIntHashMap.isNonSentinel(IntIntHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntIntHashMap.this.keysValues[i], IntIntHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntIntPair> objectIntProcedure) {
            int index = 0;
            if (IntIntHashMap.this.sentinelValues != null) {
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntIntHashMap.this.keysValues.length; i += 2) {
                if (!IntIntHashMap.isNonSentinel(IntIntHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(IntIntHashMap.this.keysValues[i], IntIntHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntIntPair, ? super P> procedure, P parameter) {
            if (IntIntHashMap.this.sentinelValues != null) {
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntIntHashMap.this.keysValues.length; i += 2) {
                if (!IntIntHashMap.isNonSentinel(IntIntHashMap.this.keysValues[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntIntHashMap.this.keysValues[i], IntIntHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        @Override
        public Iterator<IntIntPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<IntIntPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntIntPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntIntHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntIntHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, ((IntIntHashMap)IntIntHashMap.this).sentinelValues.oneValue);
                    }
                }
                int[] keys = IntIntHashMap.this.keysValues;
                while (!IntIntHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                IntIntPair result = PrimitiveTuples.pair(keys[this.position], IntIntHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntIntHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableIntValuesMap.AbstractIntValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableIntIterator intIterator() {
            return IntIntHashMap.this.intIterator();
        }

        @Override
        public boolean remove(int item) {
            int oldSize = IntIntHashMap.this.size();
            if (IntIntHashMap.this.sentinelValues != null && ((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsZeroKey && item == ((IntIntHashMap)IntIntHashMap.this).sentinelValues.zeroValue) {
                IntIntHashMap.this.removeKey(0);
            }
            if (IntIntHashMap.this.sentinelValues != null && ((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsOneKey && item == ((IntIntHashMap)IntIntHashMap.this).sentinelValues.oneValue) {
                IntIntHashMap.this.removeKey(1);
            }
            for (int i = 0; i < IntIntHashMap.this.keysValues.length; i += 2) {
                if (!IntIntHashMap.isNonSentinel(IntIntHashMap.this.keysValues[i]) || item != IntIntHashMap.this.keysValues[i + 1]) continue;
                IntIntHashMap.this.removeKey(IntIntHashMap.this.keysValues[i]);
            }
            return oldSize != IntIntHashMap.this.size();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = IntIntHashMap.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntIntHashMap retained = IntIntHashMap.this.select((int key, int value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                IntIntHashMap.access$302(IntIntHashMap.this, retained.keysValues);
                IntIntHashMap.this.sentinelValues = retained.sentinelValues;
                IntIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableIntCollection newEmpty() {
            return new IntHashBag();
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        @Override
        protected MutableIntKeysMap getOuter() {
            return IntIntHashMap.this;
        }

        @Override
        protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
            return IntIntHashMap.this.sentinelValues;
        }

        @Override
        protected int getKeyAtIndex(int index) {
            return IntIntHashMap.this.keysValues[index * 2];
        }

        @Override
        protected int getTableSize() {
            return IntIntHashMap.this.keysValues.length / 2;
        }

        @Override
        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = IntIntHashMap.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntIntHashMap retained = IntIntHashMap.this.select((int key, int value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                IntIntHashMap.access$302(IntIntHashMap.this, retained.keysValues);
                IntIntHashMap.this.sentinelValues = retained.sentinelValues;
                IntIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        @Override
        public IntSet freeze() {
            IntIntHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (IntIntHashMap.this.sentinelValues != null) {
                containsZeroKey = ((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((IntIntHashMap)IntIntHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableIntIntMapKeySet(IntIntHashMap.this.keysValues, IntIntHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableIntSet newEmpty() {
            return new IntHashSet();
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntIntHashMap.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntIntHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntIntHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntIntHashMap.this.keysValues;
            while (!IntIntHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        @Override
        public IntIterator intIterator() {
            return new UnmodifiableIntIterator(new KeySetIterator());
        }

        @Override
        public void each(IntProcedure procedure) {
            IntIntHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntIntHashMap.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntIntHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntIntHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntIntHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntIntHashMap.this.get(1);
                }
            }
            int[] keys = IntIntHashMap.this.keysValues;
            while (!IntIntHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            int result = IntIntHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

