/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.Bag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Bags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.SetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.SortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.CompositeFastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.FastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.AbstractProcedureCombiner;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.DefaultSpeciesNewStrategy;
import java.util.Collection;

public abstract class AbstractTransformerBasedCombiner<V, T, BT extends Procedure<T>>
extends AbstractProcedureCombiner<BT> {
    private static final long serialVersionUID = 1L;
    protected final Collection<V> result;

    protected AbstractTransformerBasedCombiner(boolean useCombineOne, Collection<V> targetCollection, Iterable<T> iterable, int initialCapacity) {
        super(useCombineOne);
        this.result = this.initializeResult(iterable, targetCollection, initialCapacity);
    }

    protected Collection<V> initializeResult(Iterable<T> sourceIterable, Collection<V> targetCollection, int initialCapacity) {
        if (targetCollection != null) {
            return targetCollection;
        }
        if (sourceIterable instanceof ListIterable) {
            return new CompositeFastList();
        }
        if (sourceIterable instanceof SortedSetIterable) {
            return FastList.newList();
        }
        if (sourceIterable instanceof SetIterable) {
            this.setCombineOne(true);
            return Sets.mutable.withInitialCapacity(initialCapacity);
        }
        if (sourceIterable instanceof Bag || sourceIterable instanceof MapIterable) {
            return Bags.mutable.withInitialCapacity(initialCapacity);
        }
        return this.createResultForCollection(sourceIterable, initialCapacity);
    }

    private Collection<V> createResultForCollection(Iterable<T> sourceCollection, int initialCapacity) {
        if (sourceCollection instanceof Collection) {
            return DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)sourceCollection, initialCapacity);
        }
        return Lists.mutable.withInitialCapacity(initialCapacity);
    }

    public Collection<V> getResult() {
        return this.result;
    }
}

