/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.BatchIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.BatchIterableProcedureFJTaskRunner;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.ProcedureFactory;

public final class BatchIterableProcedureFJTask<T, BT extends Procedure<? super T>>
implements Runnable {
    private final ProcedureFactory<BT> procedureFactory;
    private BT procedure;
    private final BatchIterable<T> iterable;
    private final int sectionIndex;
    private final int sectionCount;
    private final BatchIterableProcedureFJTaskRunner<T, BT> taskRunner;

    public BatchIterableProcedureFJTask(BatchIterableProcedureFJTaskRunner<T, BT> newFJTaskRunner, ProcedureFactory<BT> procedureFactory, BatchIterable<T> iterable, int index, int count) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = procedureFactory;
        this.iterable = iterable;
        this.sectionIndex = index;
        this.sectionCount = count;
    }

    @Override
    public void run() {
        try {
            this.procedure = this.procedureFactory.create();
            this.iterable.batchForEach((Procedure<T>)this.procedure, this.sectionIndex, this.sectionCount);
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
    }

    public BT getProcedure() {
        return this.procedure;
    }
}

